/*
 * Decompiled with CFR 0.152.
 */
package obp.if2.structure.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import obp.if2.If2Visitor;
import obp.if2.behaviour.states.ProcessState;
import obp.if2.data.constants.ConstantLiteral;
import obp.if2.data.variables.FormalParameter;
import obp.if2.structure.Entity;
import obp.if2.structure.Signal;
import obp.if2.structure.Signalroute;
import obp.if2.structure.entities.System;

public class Process
extends Entity {
    private ConstantLiteral initialInstancesNumber;
    private final List<FormalParameter> formalParametersList = new ArrayList<FormalParameter>();
    private final List<ProcessState> statesList = new ArrayList<ProcessState>();
    private final List<Signalroute> inRoutesList = new ArrayList<Signalroute>();
    private final List<Signalroute> outRoutesList = new ArrayList<Signalroute>();
    private final List<Signal> inSignalsList = new ArrayList<Signal>();
    private final List<Signal> outSignalsList = new ArrayList<Signal>();
    private final List<Signal> envSignalsList = new ArrayList<Signal>();
    private System system;

    public ConstantLiteral getInitialInstancesNumber() {
        return this.initialInstancesNumber;
    }

    public void setInitialInstancesNumber(ConstantLiteral newValue) {
        if (this.initialInstancesNumber == null ? newValue != null : !this.initialInstancesNumber.equals(newValue)) {
            this.initialInstancesNumber = newValue;
        }
    }

    public List<FormalParameter> getFormalParametersList() {
        return Collections.unmodifiableList(this.formalParametersList);
    }

    public int getFormalParametersCount() {
        return this.formalParametersList.size();
    }

    public FormalParameter getFormalParameters(int index) {
        if (index < 0 || index >= this.getFormalParametersCount()) {
            return null;
        }
        return this.formalParametersList.get(index);
    }

    public void addFormalParameters(FormalParameter newValue) {
        this.addFormalParameters(this.getFormalParametersCount(), newValue);
    }

    public void addFormalParameters(int index, FormalParameter newValue) {
        this.formalParametersList.add(index, newValue);
    }

    public FormalParameter setFormalParameters(int index, FormalParameter newValue) {
        return this.formalParametersList.set(index, newValue);
    }

    public void addAllFormalParameters(Collection<FormalParameter> toAddList) {
        for (FormalParameter newValue : toAddList) {
            this.addFormalParameters(this.getFormalParametersCount(), newValue);
        }
    }

    public void removeFormalParameters(FormalParameter value) {
        int index = this.formalParametersList.indexOf(value);
        if (index >= 0) {
            this.removeFormalParameters(index);
        }
    }

    public void removeFormalParameters(int index) {
        this.formalParametersList.remove(index);
    }

    public List<ProcessState> getStatesList() {
        return Collections.unmodifiableList(this.statesList);
    }

    public int getStatesCount() {
        return this.statesList.size();
    }

    public ProcessState getStates(int index) {
        if (index < 0 || index >= this.getStatesCount()) {
            return null;
        }
        return this.statesList.get(index);
    }

    public void addStates(ProcessState newValue) {
        this.addStates(this.getStatesCount(), newValue);
    }

    public void addStates(int index, ProcessState newValue) {
        this.statesList.add(index, newValue);
    }

    public ProcessState setStates(int index, ProcessState newValue) {
        return this.statesList.set(index, newValue);
    }

    public void addAllStates(Collection<ProcessState> toAddList) {
        for (ProcessState newValue : toAddList) {
            this.addStates(this.getStatesCount(), newValue);
        }
    }

    public void removeStates(ProcessState value) {
        int index = this.statesList.indexOf(value);
        if (index >= 0) {
            this.removeStates(index);
        }
    }

    public void removeStates(int index) {
        this.statesList.remove(index);
    }

    public List<Signalroute> getInRoutesList() {
        return Collections.unmodifiableList(this.inRoutesList);
    }

    public int getInRoutesCount() {
        return this.inRoutesList.size();
    }

    public Signalroute getInRoutes(int index) {
        if (index < 0 || index >= this.getInRoutesCount()) {
            return null;
        }
        return this.inRoutesList.get(index);
    }

    public void addInRoutes(Signalroute newValue) {
        this.addInRoutes(this.getInRoutesCount(), newValue);
    }

    public void addInRoutes(int index, Signalroute newValue) {
        this.inRoutesList.add(index, newValue);
    }

    public Signalroute setInRoutes(int index, Signalroute newValue) {
        return this.inRoutesList.set(index, newValue);
    }

    public void addAllInRoutes(Collection<Signalroute> toAddList) {
        for (Signalroute newValue : toAddList) {
            this.addInRoutes(this.getInRoutesCount(), newValue);
        }
    }

    public void removeInRoutes(Signalroute value) {
        int index = this.inRoutesList.indexOf(value);
        if (index >= 0) {
            this.removeInRoutes(index);
        }
    }

    public void removeInRoutes(int index) {
        this.inRoutesList.remove(index);
    }

    public void addInRoutesAndOpposite(Signalroute newValue) {
        this.addInRoutes(newValue);
        if (newValue != null) {
            newValue.setTo(this);
        }
    }

    public void addAllInRoutesAndOpposite(Collection<Signalroute> toAddList) {
        for (Signalroute newValue : toAddList) {
            this.addInRoutesAndOpposite(this.getInRoutesCount(), newValue);
        }
    }

    public void addInRoutesAndOpposite(int index, Signalroute newValue) {
        this.addInRoutes(index, newValue);
        if (newValue != null) {
            newValue.setTo(this);
        }
    }

    public Signalroute setInRoutesAndOpposite(int index, Signalroute newValue) {
        Signalroute oldValue = this.inRoutesList.set(index, newValue);
        if (newValue != null) {
            newValue.setTo(this);
        }
        return oldValue;
    }

    public void removeInRoutesAndOpposite(Signalroute removed) {
        this.removeInRoutes(removed);
        if (removed != null) {
            removed.setTo(null);
        }
    }

    public void removeInRoutesAndOpposite(int index) {
        Signalroute removed = this.inRoutesList.get(index);
        this.removeInRoutes(index);
        if (removed != null) {
            removed.setTo(null);
        }
    }

    public List<Signalroute> getOutRoutesList() {
        return Collections.unmodifiableList(this.outRoutesList);
    }

    public int getOutRoutesCount() {
        return this.outRoutesList.size();
    }

    public Signalroute getOutRoutes(int index) {
        if (index < 0 || index >= this.getOutRoutesCount()) {
            return null;
        }
        return this.outRoutesList.get(index);
    }

    public void addOutRoutes(Signalroute newValue) {
        this.addOutRoutes(this.getOutRoutesCount(), newValue);
    }

    public void addOutRoutes(int index, Signalroute newValue) {
        this.outRoutesList.add(index, newValue);
    }

    public Signalroute setOutRoutes(int index, Signalroute newValue) {
        return this.outRoutesList.set(index, newValue);
    }

    public void addAllOutRoutes(Collection<Signalroute> toAddList) {
        for (Signalroute newValue : toAddList) {
            this.addOutRoutes(this.getOutRoutesCount(), newValue);
        }
    }

    public void removeOutRoutes(Signalroute value) {
        int index = this.outRoutesList.indexOf(value);
        if (index >= 0) {
            this.removeOutRoutes(index);
        }
    }

    public void removeOutRoutes(int index) {
        this.outRoutesList.remove(index);
    }

    public void addOutRoutesAndOpposite(Signalroute newValue) {
        this.addOutRoutes(newValue);
        if (newValue != null) {
            newValue.setFrom(this);
        }
    }

    public void addAllOutRoutesAndOpposite(Collection<Signalroute> toAddList) {
        for (Signalroute newValue : toAddList) {
            this.addOutRoutesAndOpposite(this.getOutRoutesCount(), newValue);
        }
    }

    public void addOutRoutesAndOpposite(int index, Signalroute newValue) {
        this.addOutRoutes(index, newValue);
        if (newValue != null) {
            newValue.setFrom(this);
        }
    }

    public Signalroute setOutRoutesAndOpposite(int index, Signalroute newValue) {
        Signalroute oldValue = this.outRoutesList.set(index, newValue);
        if (newValue != null) {
            newValue.setFrom(this);
        }
        return oldValue;
    }

    public void removeOutRoutesAndOpposite(Signalroute removed) {
        this.removeOutRoutes(removed);
        if (removed != null) {
            removed.setFrom(null);
        }
    }

    public void removeOutRoutesAndOpposite(int index) {
        Signalroute removed = this.outRoutesList.get(index);
        this.removeOutRoutes(index);
        if (removed != null) {
            removed.setFrom(null);
        }
    }

    public List<Signal> getInSignalsList() {
        return Collections.unmodifiableList(this.inSignalsList);
    }

    public int getInSignalsCount() {
        return this.inSignalsList.size();
    }

    public Signal getInSignals(int index) {
        if (index < 0 || index >= this.getInSignalsCount()) {
            return null;
        }
        return this.inSignalsList.get(index);
    }

    public void addInSignals(Signal newValue) {
        this.addInSignals(this.getInSignalsCount(), newValue);
    }

    public void addInSignals(int index, Signal newValue) {
        this.inSignalsList.add(index, newValue);
    }

    public Signal setInSignals(int index, Signal newValue) {
        return this.inSignalsList.set(index, newValue);
    }

    public void addAllInSignals(Collection<Signal> toAddList) {
        for (Signal newValue : toAddList) {
            this.addInSignals(this.getInSignalsCount(), newValue);
        }
    }

    public void removeInSignals(Signal value) {
        int index = this.inSignalsList.indexOf(value);
        if (index >= 0) {
            this.removeInSignals(index);
        }
    }

    public void removeInSignals(int index) {
        this.inSignalsList.remove(index);
    }

    public List<Signal> getOutSignalsList() {
        return Collections.unmodifiableList(this.outSignalsList);
    }

    public int getOutSignalsCount() {
        return this.outSignalsList.size();
    }

    public Signal getOutSignals(int index) {
        if (index < 0 || index >= this.getOutSignalsCount()) {
            return null;
        }
        return this.outSignalsList.get(index);
    }

    public void addOutSignals(Signal newValue) {
        this.addOutSignals(this.getOutSignalsCount(), newValue);
    }

    public void addOutSignals(int index, Signal newValue) {
        this.outSignalsList.add(index, newValue);
    }

    public Signal setOutSignals(int index, Signal newValue) {
        return this.outSignalsList.set(index, newValue);
    }

    public void addAllOutSignals(Collection<Signal> toAddList) {
        for (Signal newValue : toAddList) {
            this.addOutSignals(this.getOutSignalsCount(), newValue);
        }
    }

    public void removeOutSignals(Signal value) {
        int index = this.outSignalsList.indexOf(value);
        if (index >= 0) {
            this.removeOutSignals(index);
        }
    }

    public void removeOutSignals(int index) {
        this.outSignalsList.remove(index);
    }

    public List<Signal> getEnvSignalsList() {
        return Collections.unmodifiableList(this.envSignalsList);
    }

    public int getEnvSignalsCount() {
        return this.envSignalsList.size();
    }

    public Signal getEnvSignals(int index) {
        if (index < 0 || index >= this.getEnvSignalsCount()) {
            return null;
        }
        return this.envSignalsList.get(index);
    }

    public void addEnvSignals(Signal newValue) {
        this.addEnvSignals(this.getEnvSignalsCount(), newValue);
    }

    public void addEnvSignals(int index, Signal newValue) {
        this.envSignalsList.add(index, newValue);
    }

    public Signal setEnvSignals(int index, Signal newValue) {
        return this.envSignalsList.set(index, newValue);
    }

    public void addAllEnvSignals(Collection<Signal> toAddList) {
        for (Signal newValue : toAddList) {
            this.addEnvSignals(this.getEnvSignalsCount(), newValue);
        }
    }

    public void removeEnvSignals(Signal value) {
        int index = this.envSignalsList.indexOf(value);
        if (index >= 0) {
            this.removeEnvSignals(index);
        }
    }

    public void removeEnvSignals(int index) {
        this.envSignalsList.remove(index);
    }

    public System getSystem() {
        return this.system;
    }

    public void setSystem(System newValue) {
        if (this.system == null ? newValue != null : !this.system.equals(newValue)) {
            this.system = newValue;
        }
    }

    @Override
    public void accept(If2Visitor visitor) {
        visitor.visitProcess(this);
    }
}

