/*
 * Decompiled with CFR 0.152.
 */
package obp.fiacre.compiler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import obp.explorer.runtime.util.NameUtil;
import obp.fiacre.checker.type.CBool;
import obp.fiacre.checker.type.CExisting;
import obp.fiacre.compiler.ProgramGenerator;
import obp.fiacre.model.ArgumentVariable;
import obp.fiacre.model.Communication;
import obp.fiacre.model.Emission;
import obp.fiacre.model.Exp;
import obp.fiacre.model.LocalVariable;
import obp.fiacre.model.PortDecl;
import obp.fiacre.model.ProcessDecl;
import obp.fiacre.model.Reception;
import obp.fiacre.model.Statement;
import obp.fiacre.model.Synchronization;
import obp.fiacre.model.Transition;
import obp.fiacre.model.Variable;
import obp.fiacre.model.Wait;
import obp.fiacre.util.ExpressionUtil;
import obp.fiacre.util.StatementUtil;
import obp.fiacre.util.TransitionBranch;
import obp.fiacre.util.TypeUtil;
import org.xid.basics.generation.java.DependencyManager;
import org.xid.basics.generation.java.Java;
import org.xid.basics.generation.java.JavaContentHandler;

public class TransitionGenerator {
    private final ProgramGenerator caller;
    private final JavaContentHandler content;
    private int transitionCount = 0;

    public TransitionGenerator(ProgramGenerator caller) {
        this.caller = caller;
        this.content = caller.getContent();
    }

    private DependencyManager getDependencyManager() {
        return this.caller.getDependencyManager();
    }

    public void generateProcessBehaviorTransitions(ProcessDecl process) {
        this.transitionCount = 0;
        Map<Transition, Collection<TransitionBranch>> processBranchMap = this.caller.getTransitionAnalyser().getBranchList(process);
        ArrayList<TransitionBranch> allBranchesOrdered = new ArrayList<TransitionBranch>();
        for (Transition transition : process.getTransitionList()) {
            Collection<TransitionBranch> extract = processBranchMap.get(transition);
            allBranchesOrdered.addAll(extract);
            for (TransitionBranch branch : extract) {
                this.generateTransitionBranch(process, branch);
                ++this.transitionCount;
            }
        }
        this.content.beginAttribute(17, "Transition[]", "transitions");
        this.content.codeln(0, "new Transition[] {");
        for (int i = 0; i < this.transitionCount; ++i) {
            StringBuilder code = new StringBuilder();
            code.append("transition");
            code.append(i);
            if (i < this.transitionCount) {
                code.append(",");
            }
            this.content.codeln(1, code.toString());
        }
        this.content.codeln(0, "}");
        this.content.endAttribute("transitions");
        this.content.annotation("Override", null);
        this.getDependencyManager().getShortName("obp.explorer.runtime.Configuration");
        this.content.beginMethod(4, "Transition[]", "getTransitions", null, new Java.Parameter[]{new Java.Parameter(0, "Configuration", "configuration")});
        this.content.codeln(0, "return transitions;");
        this.content.endMethod("getTransitions");
    }

    /*
     * WARNING - void declaration
     */
    private void generateTransitionBranch(ProcessDecl process, TransitionBranch branch) {
        void var11_22;
        String typeDeclaration;
        Wait wait;
        String instanceName = ProgramGenerator.getConfigurationName(process);
        List<ArgumentVariable> referencedSharedVariableList = this.collectReferenceArguments(branch.getAction());
        this.getDependencyManager().getShortName("java.util.List");
        this.getDependencyManager().getShortName("java.util.ArrayList");
        this.getDependencyManager().getShortName("obp.explorer.runtime.core.Transition");
        this.getDependencyManager().getShortName("obp.explorer.runtime.ExplorationContext");
        this.getDependencyManager().getShortName("obp.explorer.runtime.Configuration");
        this.getDependencyManager().getShortName("obp.explorer.runtime.BehaviorConfiguration");
        this.getDependencyManager().getShortName("obp.explorer.runtime.core.Channel");
        this.getDependencyManager().getShortName("obp.explorer.runtime.obs.AtomicAction");
        this.getDependencyManager().getShortName("obp.explorer.runtime.AbstractCallable");
        Java.Parameter[] parameters = new Java.Parameter[]{new Java.Parameter(0, "Configuration", "configuration"), new Java.Parameter(0, "ExplorationContext", "context")};
        String transitionName = "transition" + this.transitionCount;
        this.content.beginAttribute(17, "Transition", transitionName);
        this.content.beginAnonymousClass("Transition", new String[]{"id"});
        Communication communication = StatementUtil.findFirst(Communication.class, branch.getAction());
        if (communication != null) {
            this.generateSynchronisation(communication);
        }
        if ((wait = StatementUtil.findFirst(Wait.class, branch.getAction())) != null) {
            this.generateWait(wait);
        }
        if (referencedSharedVariableList.size() > 0) {
            this.content.annotation("Override", null);
            this.content.beginMethod(4, "void", "updateModifiedBehaviors", null, new Java.Parameter[]{new Java.Parameter(0, "Configuration", "configuration"), new Java.Parameter(0, "ExplorationContext", "context"), new Java.Parameter(0, "boolean[]", "modifiedBehaviors")});
            this.content.codeln(0, instanceName + " me = (" + instanceName + ") configuration.behaviorConfigurations[id];");
            for (ArgumentVariable argumentVariable : referencedSharedVariableList) {
                String string = NameUtil.uncapName(argumentVariable.getName());
                typeDeclaration = TypeUtil.toJavaDeclaration(argumentVariable.getType(), this.caller.getTypeNames());
                this.content.codeln(0, typeDeclaration + " " + string + " = " + string + "Ref.get(configuration);");
            }
            this.caller.getStatementGenerator().generateForModifiedBehaviors(branch.getAction());
            this.content.endMethod("updateModifiedBehaviors");
        }
        this.content.annotation("Override", null);
        this.content.beginMethod(4, "boolean", "guard", null, parameters);
        this.content.codeln(0, instanceName + " me = (" + instanceName + ") configuration.behaviorConfigurations[id];");
        for (ArgumentVariable argumentVariable : this.collectReferenceArguments(branch.getConditionList())) {
            String string = NameUtil.uncapName(argumentVariable.getName());
            typeDeclaration = TypeUtil.toJavaDeclaration(argumentVariable.getType(), this.caller.getTypeNames());
            this.content.codeln(0, typeDeclaration + " " + string + " = " + string + "Ref.get(configuration);");
        }
        String sourceName = NameUtil.capName(branch.getSource());
        this.content.codeln(0, "if (me.state != " + sourceName + ") return false;");
        for (Exp exp : branch.getConditionList()) {
            String conditionJava = this.caller.getExpressionGenerator().generateForBehavior(CBool.boolType, exp);
            this.content.codeln(0, "if ( (" + conditionJava + ") == false) return false;");
        }
        this.content.codeln(0, "return true;");
        this.content.endMethod("guard");
        this.content.annotation("Override", null);
        this.content.beginMethod(4, "boolean", "action", null, new Java.Parameter[]{new Java.Parameter(16, "ExplorationContext", "context"), new Java.Parameter(0, "List<AtomicAction>", "actions"), new Java.Parameter(0, "Configuration", "configuration")});
        this.content.codeln(0, "final " + instanceName + " me = (" + instanceName + ") configuration.behaviorConfigurations[id];");
        Set<Variable> set = StatementUtil.findUsedVariables(branch.getAction());
        for (LocalVariable variable : process.getVarList()) {
            boolean localToTransitions = this.caller.getVariableAnalyser().isLocalToTransitions(variable);
            boolean used = set.contains(variable);
            if (!localToTransitions || !used) continue;
            StringBuilder declaration = new StringBuilder();
            declaration.append(TypeUtil.toJavaDeclaration(variable.getType(), this.caller.getTypeNames()));
            declaration.append(" ");
            declaration.append(NameUtil.uncapName(variable.getName()));
            if (variable.getInitializer() != null) {
                declaration.append(" = ");
                CExisting type = new CExisting(variable.getType());
                declaration.append(this.caller.getExpressionGenerator().generateForBehavior(type, variable.getInitializer()));
            }
            declaration.append(";");
            this.content.codeln(0, declaration.toString());
        }
        boolean bl = false;
        if (referencedSharedVariableList.size() > 0) {
            for (ArgumentVariable argument : referencedSharedVariableList) {
                String name2 = NameUtil.uncapName(argument.getName());
                String typeDeclaration2 = TypeUtil.toJavaDeclaration(argument.getType(), this.caller.getTypeNames());
                this.content.codeln(0, typeDeclaration2 + " " + name2 + " = " + name2 + "Ref.get(configuration);");
            }
            this.content.codeln(0, "try {");
            ++var11_22;
        }
        this.caller.getStatementGenerator().generateForTransition((int)var11_22, branch.getAction());
        if (referencedSharedVariableList.size() > 0) {
            this.content.codeln(0, "} finally {");
            for (ArgumentVariable argument : referencedSharedVariableList) {
                if (!argument.isRef() || !argument.isWrite()) continue;
                String name3 = NameUtil.uncapName(argument.getName());
                this.content.codeln(1, name3 + "Ref.set(configuration, " + name3 + ");");
            }
            this.content.codeln(0, "}");
        }
        this.content.codeln(0, "if (true) { return true; } else { return true; }");
        this.content.endMethod("action");
        this.content.endAnnonymousClass("Transition");
        this.content.endAttribute(transitionName);
    }

    private List<ArgumentVariable> collectReferenceArguments(Statement action) {
        ArrayList<ArgumentVariable> result = new ArrayList<ArgumentVariable>();
        for (Variable referenced : StatementUtil.findUsedVariables(action)) {
            ArgumentVariable argument;
            if (!(referenced instanceof ArgumentVariable) || !(argument = (ArgumentVariable)referenced).isRef()) continue;
            result.add(argument);
        }
        return result;
    }

    private List<ArgumentVariable> collectReferenceArguments(List<Exp> conditionList) {
        ExpressionUtil visitor = new ExpressionUtil();
        for (Exp condition : conditionList) {
            condition.accept(visitor);
        }
        ArrayList<ArgumentVariable> result = new ArrayList<ArgumentVariable>();
        for (Variable referenced : visitor.getVariableSet()) {
            ArgumentVariable argument;
            if (!(referenced instanceof ArgumentVariable) || !(argument = (ArgumentVariable)referenced).isRef()) continue;
            result.add(argument);
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void generateSynchronisation(Communication communication) {
        this.content.annotation("Override", null);
        this.content.beginMethod(4, "short", "getSynchronisationType", null, new Java.Parameter[0]);
        if (communication instanceof Emission) {
            this.content.codeln(0, "return Output;");
        } else if (communication instanceof Reception) {
            this.content.codeln(0, "return Input;");
        } else if (communication instanceof Synchronization) {
            PortDecl port = communication.getPort();
            if (port.isIn() && !port.isOut()) {
                this.content.codeln(0, "return Input;");
            } else {
                if (port.isIn() || !port.isOut()) throw new IllegalArgumentException("Can't determinate synchronous direction for port '" + port.getName() + "'.");
                this.content.codeln(0, "return Output;");
            }
        } else {
            this.content.codeln(0, "return None;");
        }
        this.content.endMethod("getSynchronisationType");
        String name = NameUtil.uncapName(communication.getPort().getName());
        this.content.annotation("Override", null);
        this.content.beginMethod(4, "short", "getSynchronisationChannelId", null, new Java.Parameter[0]);
        this.content.codeln(0, "return " + name + ".id;");
        this.content.endMethod("getSynchronisationChannelId");
    }

    private void generateWait(Wait wait) {
        this.content.annotation("Override", null);
        this.content.beginMethod(4, "short", "getSynchronisationType", null, new Java.Parameter[0]);
        this.content.codeln(0, "return Output;");
        this.content.endMethod("getSynchronisationType");
        String name = this.caller.getNodeAnalyzer().getWaitNameMap().get(wait);
        this.content.annotation("Override", null);
        this.content.beginMethod(4, "short", "getSynchronisationChannelId", null, new Java.Parameter[0]);
        this.content.codeln(0, "return " + name + ".id;");
        this.content.endMethod("getSynchronisationChannelId");
    }
}

