/*
 * Decompiled with CFR 0.152.
 */
package obp.explorer.runtime.obs;

import obp.explorer.runtime.SymbolsTable;
import obp.explorer.runtime.obs.AtomicAction;
import obp.explorer.runtime.util.ActionUtil;
import org.xid.basics.serializer.Boost;
import org.xid.basics.serializer.BoostObject;

public class ASynchronousCommunicationAction
implements AtomicAction {
    public final short behaviorId;
    public final short commType;
    public final Object message;

    public ASynchronousCommunicationAction(short commType, short behaviorId, Object message) {
        this.commType = commType;
        this.behaviorId = behaviorId;
        this.message = message;
    }

    protected ASynchronousCommunicationAction(Boost boost) {
        boost.register((BoostObject)this);
        this.behaviorId = boost.readShort();
        this.commType = boost.readShort();
        this.message = ActionUtil.readValue(boost);
    }

    public void writeToBoost(Boost boost) {
        boost.writeShort(this.behaviorId);
        boost.writeShort(this.commType);
        ActionUtil.writeValue(boost, this.message);
    }

    public int hashCode() {
        int total = 17;
        total = total * 37 + this.behaviorId;
        total = total * 37 + this.commType;
        total = total * 37 + (this.message == null ? 0 : this.message.hashCode());
        return total;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ASynchronousCommunicationAction) {
            ASynchronousCommunicationAction other = (ASynchronousCommunicationAction)obj;
            return this.behaviorId == other.behaviorId && this.commType == other.commType && this.message == null ? other.message == null : this.message.equals(other.message);
        }
        return false;
    }

    @Override
    public String toFancyString(SymbolsTable symbols) {
        StringBuilder label = new StringBuilder();
        label.append("async: {");
        label.append(symbols.getBehaviorName(this.behaviorId));
        label.append(":");
        switch (this.commType) {
            case 1: {
                label.append("?");
                break;
            }
            case 2: {
                label.append("!");
                break;
            }
            case 0: {
                label.append("*");
            }
        }
        if (this.message != null) {
            label.append(this.message);
        }
        label.append("}");
        return label.toString();
    }

    public String toString() {
        StringBuilder label = new StringBuilder();
        label.append(this.behaviorId);
        label.append(":");
        switch (this.commType) {
            case 1: {
                label.append("?");
                break;
            }
            case 2: {
                label.append("!");
                break;
            }
            case 0: {
                label.append("*");
            }
        }
        if (this.message != null) {
            label.append(this.message);
        }
        return label.toString();
    }
}

