/*
 * Decompiled with CFR 0.152.
 */
package obp.simulation.component;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import obp.simulation.graph.ZGRPanelViewer;
import obp.simulation.model.ConfigurationModel;
import obp.simulation.observer.ConfigurationObservable;
import obp.simulation.observer.ConfigurationObserver;
import obp.simulation.observer.GraphicsObserver;
import obp.simulation.zgr.Observateur;

public class GraphicsPanel
extends JPanel
implements ConfigurationObserver,
GraphicsObserver {
    private static final long serialVersionUID = 4337024847794863551L;
    private ZGRPanelViewer graphViewer;
    private JButton globalView = new JButton("Global view");
    private JButton radarView = new JButton("Radar view");

    public GraphicsPanel() {
        this.graphViewer = new ZGRPanelViewer();
        JToolBar graphTool = new JToolBar();
        graphTool.add(this.globalView);
        graphTool.add(this.radarView);
        this.setLayout(new BorderLayout());
        this.add("North", graphTool);
        this.add(this.graphViewer.getPanel());
        this.globalView.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ((GraphicsPanel)GraphicsPanel.this).graphViewer.zgrViewer.getGraphicsManager().getGlobalView();
            }
        });
        this.radarView.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ((GraphicsPanel)GraphicsPanel.this).graphViewer.zgrViewer.getGraphicsManager().showRadarView(true);
            }
        });
    }

    public void setGraphFile(File graphFile) {
        this.graphViewer.loadFile(graphFile);
    }

    public void addObserver(Observateur obs) {
        this.graphViewer.addObservateur(obs);
    }

    public void highligthEdge(int node1, int node2) {
        this.graphViewer.highLigthEdge(node1, node2);
    }

    public void unHighLigthAllEdge() {
        this.graphViewer.unHighLigthAllEdge();
    }

    public void svgExport(File file) {
        this.graphViewer.svgExport(file);
    }

    public void exit() {
        this.graphViewer.exit();
    }

    @Override
    public void changeConfig(ConfigurationObservable confModel) {
        ConfigurationModel config = (ConfigurationModel)confModel;
        this.graphViewer.focusOn(Integer.toString(config.getCurrentConfigId()));
        JTabbedPane parent = (JTabbedPane)this.getParent().getParent().getParent();
        parent.setSelectedIndex(1);
    }

    @Override
    public void graphChange(String focusOn) {
        this.graphViewer.reload(false, focusOn);
        JTabbedPane parent = (JTabbedPane)this.getParent().getParent().getParent();
        parent.setSelectedIndex(1);
    }
}

