/*
 * Decompiled with CFR 0.152.
 */
package obp.result;

import java.io.File;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import obp.cc.ConcreteContext;
import obp.result.FinalState;
import org.xid.basics.serializer.Boost;
import org.xid.basics.serializer.BoostObject;
import org.xid.basics.serializer.BoostUtil;

public class ExplorationResultInfo
implements BoostObject {
    protected static final NumberFormat integerFormat = DecimalFormat.getIntegerInstance();
    private final ConcreteContext context;
    private final File ccslFile;
    private final File resultFile;
    private BigInteger configurationCount;
    private BigInteger actionCount;
    private FinalState state = FinalState.Error;
    private double duration;

    public ExplorationResultInfo(ConcreteContext context, File ccslFile, File resultFile) {
        this.context = context;
        this.ccslFile = ccslFile;
        this.resultFile = resultFile;
    }

    protected ExplorationResultInfo(Boost boost) {
        boost.register((BoostObject)this);
        this.context = (ConcreteContext)boost.readObject(ConcreteContext.class);
        this.ccslFile = BoostUtil.readFile((Boost)boost);
        this.resultFile = BoostUtil.readFile((Boost)boost);
        this.configurationCount = new BigInteger(boost.readString());
        this.actionCount = new BigInteger(boost.readString());
        this.state = (FinalState)boost.readEnum(FinalState.class);
        this.duration = boost.readDouble();
    }

    public ConcreteContext getContext() {
        return this.context;
    }

    public File getCCSLFile() {
        return this.ccslFile;
    }

    public File getResultFile() {
        return this.resultFile;
    }

    public BigInteger getConfigurationCount() {
        return this.configurationCount;
    }

    public void setConfigurationCount(BigInteger stateCount) {
        this.configurationCount = stateCount;
    }

    public BigInteger getActionCount() {
        return this.actionCount;
    }

    public void setActionCount(BigInteger transitionCount) {
        this.actionCount = transitionCount;
    }

    public boolean isComplete() {
        return this.state == FinalState.Complete;
    }

    public FinalState getState() {
        return this.state;
    }

    public void setState(FinalState state) {
        if (state == null) {
            state = FinalState.Error;
        }
        this.state = state;
    }

    public double getDuration() {
        return this.duration;
    }

    public void setDuration(double duration) {
        this.duration = duration;
    }

    public void writeToBoost(Boost boost) {
        boost.writeObject((BoostObject)this.context);
        BoostUtil.writeFile((Boost)boost, (File)this.ccslFile);
        BoostUtil.writeFile((Boost)boost, (File)this.resultFile);
        boost.writeString(this.configurationCount.toString());
        boost.writeString(this.actionCount.toString());
        boost.writeEnum((Enum)this.state);
        boost.writeDouble(this.duration);
    }

    private String formatNumber(BigInteger n) {
        if (n.compareTo(BigInteger.valueOf(Integer.MAX_VALUE)) <= 0) {
            return integerFormat.format(n);
        }
        return n.toString();
    }

    public String toShortString() {
        StringBuilder description = new StringBuilder();
        description.append("Explored ");
        if (this.configurationCount != null && this.actionCount != null) {
            description.append(this.formatNumber(this.getConfigurationCount()));
            description.append(" states and ");
            description.append(this.formatNumber(this.getActionCount()));
            description.append(" transitions ");
        }
        description.append("in ");
        description.append(DecimalFormat.getNumberInstance().format(this.getDuration()));
        description.append(" seconds.");
        description.append("\n");
        switch (this.state) {
            case Complete: {
                description.append("Exploration ended normally.\n");
                break;
            }
            case Incomplete: {
                description.append("Exploration is INCOMPLETE.\n");
                break;
            }
            case Interrupted: {
                description.append("Exploration was interrupted.\n");
                break;
            }
            case Error: {
                description.append("Exploration was unsuccessful.\n");
            }
        }
        return description.toString();
    }

    public String toString() {
        StringBuilder description = new StringBuilder();
        description.append("--------------------Synthesis---------------------");
        description.append("\n");
        description.append("Explored ");
        if (this.configurationCount != null && this.actionCount != null) {
            description.append(this.formatNumber(this.getConfigurationCount()));
            description.append(" states and ");
            description.append(this.formatNumber(this.getActionCount()));
            description.append(" transitions ");
        }
        description.append("in ");
        description.append(DecimalFormat.getNumberInstance().format(this.getDuration()));
        description.append(" seconds.");
        description.append("\n");
        switch (this.state) {
            case Complete: {
                description.append("Exploration ended normally.\n");
                break;
            }
            case Incomplete: {
                description.append("Exploration is INCOMPLETE.\n");
                break;
            }
            case Interrupted: {
                description.append("Exploration was interrupted.\n");
                break;
            }
            case Error: {
                description.append("Exploration was unsuccessful.\n");
            }
        }
        if (this.getContext() != null) {
            description.append("Context '");
            description.append(this.getContext().getName());
            description.append("' contained ");
            description.append(this.formatNumber(BigInteger.valueOf(this.getContext().getStateCount())));
            description.append(" states, and ");
            description.append(this.formatNumber(BigInteger.valueOf(this.getContext().getTransitionCount())));
            description.append(" transitions.");
            description.append("\n");
        }
        if (this.getResultFile() != null) {
            description.append("Result is stored in file '");
            description.append(this.getResultFile().getAbsolutePath());
            description.append("'.");
            description.append("\n");
        }
        return description.toString();
    }
}

