/*
 * Decompiled with CFR 0.152.
 */
package org.xid.basics.generation.c;

import java.util.regex.Pattern;
import org.xid.basics.generation.c.C;
import org.xid.basics.generation.c.CContentFilter;
import org.xid.basics.generation.c.CContentHandler;

public class CContentFormatter
extends CContentFilter {
    private final String NL = System.getProperty("line.separator");
    private final Pattern NL_REGEX = Pattern.compile(this.NL);
    private int level = 0;
    private String indentString;

    public CContentFormatter(CContentHandler target, String indentString) {
        super(target);
        this.indentString = indentString;
    }

    public CContentFormatter(CContentHandler target) {
        this(target, "\t");
    }

    @Override
    public void beginFile(String name) {
        super.beginFile(name);
        super.codeln(0, this.NL);
        super.codeln(0, this.NL);
    }

    @Override
    public void functionDeclaration(int flags, String returnType, String name, C.Parameter ... parameters) {
        super.codeln(0, this.indentation(this.level));
        super.functionDeclaration(flags, returnType, name, parameters);
        super.codeln(0, this.NL);
    }

    @Override
    public void beginFunction(int flags, String returnType, String name, C.Parameter ... parameters) {
        super.codeln(0, this.indentation(this.level++));
        super.beginFunction(flags, returnType, name, parameters);
        super.codeln(0, this.NL);
    }

    @Override
    public void beginDirectory(String name) {
        super.beginDirectory(name);
    }

    @Override
    public void endFile(String name) {
        super.endFile(name);
    }

    @Override
    public void endFunction(String name) {
        super.codeln(0, this.indentation(--this.level));
        super.endFunction(name);
        super.codeln(0, this.NL);
        super.codeln(0, this.NL);
    }

    @Override
    public void endDirectory(String name) {
        super.endDirectory(name);
    }

    @Override
    public void codeln(int localLevel, String statements) {
        String[] lines;
        for (String line : lines = this.NL_REGEX.split(statements)) {
            super.codeln(this.level + localLevel, this.indentation(this.level + localLevel));
            super.codeln(this.level + localLevel, line);
            super.codeln(this.level + localLevel, this.NL);
        }
    }

    @Override
    public void code(String statements) {
        super.code(statements);
    }

    @Override
    public void comment(int type, int localLevel, String comment) {
        int innerLevel = this.level + localLevel;
        switch (type) {
            case 1: {
                super.codeln(0, this.indentation(innerLevel));
                super.comment(type, localLevel, comment);
                break;
            }
            case 2: {
                String[] lines = this.NL_REGEX.split(comment);
                super.codeln(localLevel, this.indentation(innerLevel));
                super.codeln(localLevel, "/*");
                super.codeln(innerLevel, this.NL);
                for (int i = 0; i < lines.length; ++i) {
                    super.codeln(localLevel, this.indentation(innerLevel));
                    if (!lines[i].startsWith(" *")) {
                        super.codeln(localLevel, " * ");
                    }
                    super.codeln(localLevel, lines[i]);
                    super.codeln(localLevel, this.NL);
                }
                super.codeln(localLevel, this.indentation(innerLevel));
                super.codeln(localLevel, " */");
                super.codeln(localLevel, this.NL);
            }
        }
    }

    private String indentation(int level) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < level; ++i) {
            result.append(this.indentString);
        }
        return result.toString();
    }
}

