/*
 * Decompiled with CFR 0.152.
 */
package obp.ui.tina;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import obp.tina.OBPtConfiguration;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.xid.basics.error.Validator;
import org.xid.basics.progress.ActionMonitor;
import org.xid.basics.ui.action.Action;
import org.xid.basics.ui.controller.Controller;
import org.xid.basics.ui.field.CheckboxField;
import org.xid.basics.ui.field.ChoiceField;
import org.xid.basics.ui.field.CompositeField;
import org.xid.basics.ui.field.Field;
import org.xid.basics.ui.field.MultiTabField;
import org.xid.basics.ui.field.TextField;

public class OBPtConfigurationController
extends Controller<OBPtConfiguration> {
    private static final List<String> tinaExplorationModeTooltips = Arrays.asList("Default mode.", "Builds the strong state class graph.");
    private static final List<String> tinaExplorationModeNames = Arrays.asList("Default", "Strong state class graph");
    private static final List<String> tinaExplorationModeOptions = Arrays.asList("", "-S");
    private static final List<String> tinaStopConditionNames = Arrays.asList("None", "Time (in seconds)", "Configurations");
    private static final List<String> tinaStopConditionTooltips = Arrays.asList("No stop condition.", "Stop over a time condition (in seconds).", "Stop over a maximum number of reacheable configurations.");
    private static final List<String> tinaStopConditionOptions = Arrays.asList("", "-t", "-c");
    private static final List<String> seltDiagnosticNames = Arrays.asList("Default", "Condensed", "Full");
    private static final List<String> seltDiagnosticOptions = Arrays.asList("", "-c", "-p");
    private final Shell parentShell;
    private CompositeField compositeField;
    private TextField fracField;
    private TextField tinaField;
    private TextField gccField;
    private ChoiceField<String> tinaExplorationModeField;
    private ChoiceField<String> tinaStopConditionField;
    private TextField tinaStopConditionParameterField;
    private ChoiceField<String> seltDiagnosticField;
    private TextField preludeField;
    private CheckboxField erasePreviousResultField;

    public OBPtConfigurationController(Shell parentShell) {
        this.parentShell = parentShell;
    }

    public CompositeField createFields() {
        this.fracField = new TextField("Frac Directory");
        this.fracField.setTooltip("Frac directory that contains 'frac' executable.");
        this.fracField.addAction((Action)new Action.Stub("\u2026"){

            public int run(ActionMonitor monitor) {
                DirectoryDialog dialog = new DirectoryDialog(OBPtConfigurationController.this.parentShell);
                dialog.setFilterPath(OBPtConfigurationController.this.fracField.getValue());
                dialog.setMessage("Choose Frac directory");
                String newFracDirectory = dialog.open();
                if (newFracDirectory == null) {
                    return 2;
                }
                OBPtConfigurationController.this.fracField.setValue(newFracDirectory);
                ((OBPtConfiguration)OBPtConfigurationController.this.getSubject()).setFracDirectory(newFracDirectory);
                return 1;
            }
        });
        this.fracField.setValidator((Validator)new Validator.Stub<String>(1, "Invalid Frac directory."){

            public boolean isValid(String value) {
                if (OBPtConfigurationController.this.fracField.getValue() == null) {
                    return false;
                }
                File fileFile = new File(OBPtConfigurationController.this.fracField.getValue(), OBPtConfigurationController.isWindows() ? "frac.exe" : "frac");
                return fileFile.exists() && fileFile.isFile() && fileFile.canExecute();
            }
        });
        this.tinaField = new TextField("Tina Directory");
        this.tinaField.setTooltip("Tina directory that contains 'bin/tina' executable.");
        this.tinaField.addAction((Action)new Action.Stub("\u2026"){

            public int run(ActionMonitor monitor) {
                DirectoryDialog dialog = new DirectoryDialog(OBPtConfigurationController.this.parentShell);
                dialog.setFilterPath(OBPtConfigurationController.this.tinaField.getValue());
                dialog.setMessage("Choose Tina directory");
                String newTinaDirectory = dialog.open();
                if (newTinaDirectory == null) {
                    return 2;
                }
                OBPtConfigurationController.this.tinaField.setValue(newTinaDirectory);
                ((OBPtConfiguration)OBPtConfigurationController.this.getSubject()).setTinaDirectory(newTinaDirectory);
                return 1;
            }
        });
        this.tinaField.setValidator((Validator)new Validator.Stub<String>(1, "Invalid Tina directory."){

            public boolean isValid(String value) {
                if (OBPtConfigurationController.this.tinaField.getValue() == null) {
                    return false;
                }
                File tinaFile = new File(OBPtConfigurationController.this.tinaField.getValue(), OBPtConfigurationController.isWindows() ? "bin\\tina.exe" : "bin/tina");
                return tinaFile.exists() && tinaFile.isFile() && tinaFile.canExecute();
            }
        });
        this.gccField = new TextField("GCC Executable");
        this.gccField.setTooltip("GCC executable path.");
        this.gccField.addAction((Action)new Action.Stub("\u2026"){

            public int run(ActionMonitor monitor) {
                String newGcc;
                FileDialog dialog = new FileDialog(OBPtConfigurationController.this.parentShell);
                if (OBPtConfigurationController.this.gccField.getValue() != null) {
                    File gccFile = new File(OBPtConfigurationController.this.gccField.getValue());
                    dialog.setFilterPath(gccFile.getParent());
                    dialog.setFileName(gccFile.getName());
                }
                if ((newGcc = dialog.open()) == null) {
                    return 2;
                }
                OBPtConfigurationController.this.gccField.setValue(newGcc);
                ((OBPtConfiguration)OBPtConfigurationController.this.getSubject()).setGcc(newGcc);
                return 1;
            }
        });
        this.gccField.setValidator((Validator)new Validator.Stub<String>(1, "Invalid GCC file."){

            public boolean isValid(String value) {
                if (OBPtConfigurationController.this.gccField.getValue() == null) {
                    return false;
                }
                File file = new File(OBPtConfigurationController.this.gccField.getValue());
                return file.exists() && file.isFile() && file.canExecute();
            }
        });
        this.tinaExplorationModeField = new ChoiceField<String>("Exploration mode", tinaExplorationModeNames.get(0), tinaExplorationModeNames, 0){

            public String getTooltip() {
                return (String)tinaExplorationModeTooltips.get(this.range.indexOf(this.value));
            }
        };
        this.tinaStopConditionField = new ChoiceField<String>("Stop condition", tinaStopConditionNames.get(0), tinaStopConditionNames, 0){

            public String getTooltip() {
                return (String)tinaStopConditionTooltips.get(this.range.indexOf(this.value));
            }
        };
        this.tinaStopConditionParameterField = new TextField("Parameter");
        this.tinaStopConditionParameterField.setTooltip("Stop condition parameter.");
        this.tinaStopConditionParameterField.setEnable(false);
        this.tinaStopConditionParameterField.setValidator((Validator)new Validator.Stub<String>(1, "Invalid stop condition parameter (must be an integer)."){

            public boolean isValid(String value) {
                if (value == null) {
                    return true;
                }
                try {
                    int intValue = Integer.parseInt(value);
                    return intValue >= 0;
                }
                catch (NumberFormatException e) {
                    return false;
                }
            }
        });
        this.seltDiagnosticField = new ChoiceField("Diagnostic Output", 0);
        this.seltDiagnosticField.setTooltip("Counter example form for Selt.");
        this.seltDiagnosticField.setRange(seltDiagnosticNames);
        this.preludeField = new TextField("LTL Prelude File");
        this.preludeField.setTooltip("LTL file to load before formula file.");
        this.preludeField.addAction((Action)new Action.Stub("\u2026"){

            public int run(ActionMonitor monitor) {
                String newPrelude;
                FileDialog dialog = new FileDialog(OBPtConfigurationController.this.parentShell);
                if (OBPtConfigurationController.this.preludeField.getValue() != null) {
                    File gccFile = new File(OBPtConfigurationController.this.preludeField.getValue());
                    dialog.setFilterPath(gccFile.getParent());
                    dialog.setFileName(gccFile.getName());
                }
                if ((newPrelude = dialog.open()) == null) {
                    return 2;
                }
                OBPtConfigurationController.this.preludeField.setValue(newPrelude);
                ((OBPtConfiguration)OBPtConfigurationController.this.getSubject()).setPreludeFile(newPrelude);
                return 1;
            }
        });
        this.preludeField.setValidator((Validator)new Validator.Stub<String>(1, "Invalid Prelude file."){

            public boolean isValid(String value) {
                if (value == null) {
                    return true;
                }
                File file = new File(value);
                return file.exists() && file.isFile();
            }
        });
        CompositeField directoriesCompositeField = new CompositeField("Directories", 16, new Field[]{this.fracField, this.tinaField, this.gccField});
        CompositeField tinaCompositeField = new CompositeField("Tina", 16, new Field[]{this.tinaExplorationModeField, this.tinaStopConditionField, this.tinaStopConditionParameterField});
        CompositeField seltCompositeField = new CompositeField("Selt", 16, new Field[]{this.seltDiagnosticField, this.preludeField});
        CompositeField toolsCompositeField = new CompositeField("Tools", new Field[]{directoriesCompositeField, tinaCompositeField, seltCompositeField});
        this.erasePreviousResultField = new CheckboxField("Erase previous result while exploring");
        this.erasePreviousResultField.setTooltip("Only creates one tts directory for exploration.");
        CompositeField advancedCompositeField = new CompositeField("Advanced", 16, new Field[]{this.erasePreviousResultField});
        CompositeField cdlCompositeField = new CompositeField("CDL", new Field[]{advancedCompositeField});
        MultiTabField mainField = new MultiTabField("Configuration", 0);
        mainField.addTab((Field)toolsCompositeField, null, false);
        mainField.addTab((Field)cdlCompositeField, null, false);
        this.compositeField = new CompositeField(new Field[]{mainField});
        return this.compositeField;
    }

    public void refreshFields() {
        if (this.getSubject() == null) {
            this.compositeField.setEnable(false);
        } else {
            this.compositeField.setEnable(true);
            int index = 0;
            if (((OBPtConfiguration)this.getSubject()).getSeltOptions() != null) {
                index = seltDiagnosticOptions.indexOf(((OBPtConfiguration)this.getSubject()).getSeltOptions());
            }
            this.fracField.setValue(((OBPtConfiguration)this.getSubject()).getFracDirectory());
            this.tinaField.setValue(((OBPtConfiguration)this.getSubject()).getTinaDirectory());
            this.gccField.setValue(((OBPtConfiguration)this.getSubject()).getGcc());
            this.refreshTinaOptions();
            this.seltDiagnosticField.setValue((Object)seltDiagnosticNames.get(index));
            this.preludeField.setValue(((OBPtConfiguration)this.getSubject()).getPreludeFile());
            this.erasePreviousResultField.setValue(((OBPtConfiguration)this.getSubject()).isErasePreviousResult());
        }
    }

    private void refreshTinaOptions() {
        this.tinaExplorationModeField.setValue((Object)tinaExplorationModeNames.get(0));
        this.tinaStopConditionField.setValue((Object)tinaStopConditionNames.get(0));
        this.tinaStopConditionParameterField.setEnable(false);
        if (((OBPtConfiguration)this.getSubject()).getTinaOptions() != null) {
            String[] options = ((OBPtConfiguration)this.getSubject()).getTinaOptions().split(" ");
            for (int i = 0; i < options.length; ++i) {
                int index = tinaExplorationModeOptions.indexOf(options[i]);
                if (index > 0) {
                    this.tinaExplorationModeField.setValue((Object)tinaExplorationModeNames.get(index));
                    continue;
                }
                index = tinaStopConditionOptions.indexOf(options[i]);
                if (index <= 0 || i >= options.length - 1) continue;
                this.tinaStopConditionField.setValue((Object)tinaStopConditionNames.get(index));
                this.tinaStopConditionParameterField.setEnable(true);
                this.tinaStopConditionParameterField.setValue(options[++i]);
            }
        }
    }

    public boolean updateSubject(Field field) {
        if (field == this.fracField) {
            ((OBPtConfiguration)this.getSubject()).setFracDirectory(this.fracField.getValue());
            return true;
        }
        if (field == this.tinaField) {
            ((OBPtConfiguration)this.getSubject()).setTinaDirectory(this.tinaField.getValue());
            return true;
        }
        if (field == this.gccField) {
            ((OBPtConfiguration)this.getSubject()).setGcc(this.gccField.getValue());
            return true;
        }
        if (field == this.tinaExplorationModeField || field == this.tinaStopConditionField || field == this.tinaStopConditionParameterField) {
            this.updateTinaOptions();
            return true;
        }
        if (field == this.preludeField) {
            ((OBPtConfiguration)this.getSubject()).setPreludeFile(this.preludeField.getValue());
            return true;
        }
        if (field == this.seltDiagnosticField) {
            int index = seltDiagnosticNames.indexOf(this.seltDiagnosticField.getValue());
            ((OBPtConfiguration)this.getSubject()).setSeltOptions(seltDiagnosticOptions.get(index));
            return true;
        }
        if (field == this.erasePreviousResultField) {
            ((OBPtConfiguration)this.getSubject()).setErasePreviousResult(this.erasePreviousResultField.getValue());
            return true;
        }
        return super.updateSubject(field);
    }

    private void updateTinaOptions() {
        int stopIndex;
        StringBuilder newOptions = new StringBuilder();
        int explorationModelIndex = tinaExplorationModeNames.indexOf(this.tinaExplorationModeField.getValue());
        if (explorationModelIndex > 0) {
            newOptions.append(tinaExplorationModeOptions.get(explorationModelIndex));
        }
        if ((stopIndex = tinaStopConditionNames.indexOf(this.tinaStopConditionField.getValue())) > 0) {
            if (newOptions.length() > 0) {
                newOptions.append(" ");
            }
            newOptions.append(tinaStopConditionOptions.get(stopIndex));
            newOptions.append(" ");
            newOptions.append(this.tinaStopConditionParameterField.getIntValue());
        }
        ((OBPtConfiguration)this.getSubject()).setTinaOptions(newOptions.toString());
        this.refreshTinaOptions();
    }

    public static boolean isWindows() {
        return System.getProperty("os.name").contains("Windows");
    }
}

