/*
 * Decompiled with CFR 0.152.
 */
package obp.ui.cdl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import obp.cdl.CDLDeclaration;
import obp.cdl.CDLUnit;
import obp.cdl.PropertyDeclaration;
import obp.dot.Graph;
import obp.dot.util.DotUtil;
import obp.obs.Observer;
import obp.transfo.property.PropertyToObserver;
import obp.ui.cdl.Actions;
import obp.ui.cdl.CDLResources;
import obp.ui.cdl.Configuration;
import obp.ui.cdl.OpenedUnit;
import obp.ui.cdl.diagram.CDLDiagram;
import obp.ui.dot.diagram.GraphDiagram;
import obp.util.CDLUtil;
import obp.util.ObsUtil;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.xid.basics.error.Diagnostic;
import org.xid.basics.error.DiagnosticUtil;
import org.xid.basics.error.ErrorHandler;
import org.xid.basics.notification.Notification;
import org.xid.basics.notification.NotificationListener;
import org.xid.basics.serializer.BoostObject;
import org.xid.basics.serializer.JBoost;
import org.xid.basics.ui.action.Action;
import org.xid.basics.ui.action.ActionExecuter;
import org.xid.basics.ui.diagram.Diagram;
import org.xid.basics.ui.diagram.DiagramUtils;
import org.xid.basics.ui.dialog.FieldShellToolkit;
import org.xid.basics.ui.field.BorderField;
import org.xid.basics.ui.field.CompositeField;
import org.xid.basics.ui.field.DiagramField;
import org.xid.basics.ui.field.Field;
import org.xid.basics.ui.field.ListField;
import org.xid.basics.ui.field.MultiPageField;
import org.xid.basics.ui.field.TextField;
import org.xid.basics.ui.field.TreeField;

public class CDLViewer
implements ErrorHandler {
    private String version;
    private String date;
    private Display display;
    private CDLResources resources;
    private Configuration configuration;
    private boolean showErrors = false;
    private Actions actions;
    private final List<OpenedUnit> units = new ArrayList<OpenedUnit>();
    private TreeField<Object> cdlTree;
    private BorderField editorField;
    private ListField<Diagnostic> errorLogsField;
    private MultiPageField diagramsField;
    private DiagramField<CDLDeclaration> cdlDiagramField;
    private BorderField patternField;
    private TextField patternTextField;
    private DiagramField<Graph> patternGraphField;
    private final List<Diagnostic> errorLogs = new ArrayList<Diagnostic>();
    private ActionExecuter executer = new ActionExecuter.Stub(){

        public void error(Action action) {
            CDLViewer.this.setShowErrors(true);
        }
    };
    private Shell shell;

    private File getConfigurationFile() {
        return new File(System.getProperty("user.home"), ".CDLViewer.conf");
    }

    private JBoost createTinaConfigurationBoost() {
        return new JBoost("CDLViewerConf", 1);
    }

    private void loadConfiguration() {
        try {
            JBoost boost = this.createTinaConfigurationBoost();
            boost.initializeReading((InputStream)new FileInputStream(this.getConfigurationFile()));
            this.configuration = (Configuration)boost.readObject(Configuration.class);
            boost.close();
        }
        catch (Exception e) {
            this.configuration = new Configuration();
        }
    }

    private void saveConfiguration() {
        try {
            JBoost boost = this.createTinaConfigurationBoost();
            boost.initializeWriting((OutputStream)new FileOutputStream(this.getConfigurationFile()));
            boost.writeObject((BoostObject)this.configuration);
            boost.close();
        }
        catch (Exception e) {
            this.handleError(1, "Can't save configuration to file '" + this.getConfigurationFile().getAbsolutePath() + "'.");
        }
    }

    private void initVersion() {
        try {
            Properties properties = new Properties();
            properties.load(this.getClass().getResourceAsStream("version.properties"));
            this.version = properties.getProperty("version");
            this.date = properties.getProperty("date");
        }
        catch (Exception e) {
            this.handleError(1, DiagnosticUtil.createMessage((Throwable)e));
            this.version = "unknown";
            this.date = "unknown";
        }
    }

    public String getVersionString() {
        return "CDLViewer version " + this.version + " (" + this.date + ").\n";
    }

    private void init() {
        this.initVersion();
        this.loadConfiguration();
        this.display = new Display();
        this.resources = (CDLResources)CDLResources.getInstance(CDLResources.class);
        this.actions = new Actions(this);
        this.createFields();
        this.shell = FieldShellToolkit.createShell((String)"CDLViewer");
        BorderField mainBorderField = new BorderField(0, (Field)this.editorField);
        mainBorderField.setNorth(this.cdlTree, 20);
        FieldShellToolkit toolkit = new FieldShellToolkit(this.shell, this.getVersionString(), 1, (Field)mainBorderField);
        toolkit.setActionExecuter(this.executer);
        toolkit.setBannerImage(this.resources.getImage("obp100x66.png"));
        toolkit.setMenuActions(new Action[]{this.actions.createFileAction(), this.actions.createWindowAction()});
        toolkit.init();
        this.shell.setMinimumSize(500, 200);
        this.shell.setSize(800, 600);
        this.shell.addListener(26, new Listener(){

            public void handleEvent(Event event) {
                for (OpenedUnit opened : CDLViewer.this.units) {
                    if (opened == null || !opened.needReload()) continue;
                    int errorSize = CDLViewer.this.errorLogs.size();
                    CDLViewer.this.loadUnit(opened);
                    if (errorSize >= CDLViewer.this.errorLogs.size()) continue;
                    CDLViewer.this.setShowErrors(true);
                }
            }
        });
    }

    private void createFields() {
        this.cdlTree = new TreeField<Object>(null, 2){
            private final Map<Object, Object> parents;
            {
                this.parents = new HashMap<Object, Object>();
            }

            public String getText(Object element) {
                StringBuilder builder = new StringBuilder();
                if (element instanceof OpenedUnit) {
                    OpenedUnit openedUnit = (OpenedUnit)element;
                    builder.append(openedUnit.getUnit() == null ? "[Error] " : "[Unit] ");
                    builder.append(openedUnit.getFile().getPath());
                } else if (element instanceof CDLDeclaration) {
                    CDLDeclaration cdl = (CDLDeclaration)element;
                    builder.append("[C] ");
                    builder.append(cdl.getName());
                } else if (element instanceof PropertyDeclaration) {
                    PropertyDeclaration property = (PropertyDeclaration)element;
                    builder.append("[P] ");
                    builder.append(property.getName());
                } else {
                    builder.append("Unknown object");
                }
                return builder.toString();
            }

            public Object getParent(Object element) {
                return this.parents.get(element);
            }

            public List<Object> getChildren(Object element) {
                CDLUnit unit;
                ArrayList<Object> result = new ArrayList<Object>();
                if (element instanceof OpenedUnit && (unit = ((OpenedUnit)element).getUnit()) != null) {
                    result.addAll(CDLUtil.findAllDeclarations(unit, CDLDeclaration.class));
                    result.addAll(CDLUtil.findAllDeclarations(unit, PropertyDeclaration.class));
                }
                for (Object e : result) {
                    this.parents.put(e, element);
                }
                return result;
            }
        };
        this.cdlTree.setNbLines(3);
        this.cdlTree.setValue(this.units);
        this.errorLogsField = new ListField<Diagnostic>(null, 2){

            public String getText(Diagnostic element) {
                return element.getMessage();
            }

            public Image getImage(Diagnostic element) {
                return this.resources.getImage(4.getLevelImageName((int)element.getLevel()));
            }
        };
        this.createDiagramField();
        this.editorField = new BorderField(0, (Field)this.diagramsField);
        this.editorField.setSouth((Field)new CompositeField("Error logs", 16, new Field[]{this.errorLogsField}), 20);
        this.editorField.setMaximized((Field)(this.showErrors ? null : this.diagramsField));
        this.cdlTree.addListener(new NotificationListener(){

            public void notified(Notification notification) {
                if ("selection".equals(notification.name)) {
                    Object singleSelection = CDLViewer.this.cdlTree.getSingleSelection();
                    if (singleSelection instanceof OpenedUnit) {
                        CDLViewer.this.cdlDiagramField.setValue(null);
                        CDLViewer.this.patternTextField.setValue(null);
                        CDLViewer.this.patternGraphField.setValue(null);
                        CDLViewer.this.diagramsField.setSelected(0);
                    } else if (singleSelection instanceof CDLDeclaration) {
                        CDLDeclaration value = (CDLDeclaration)singleSelection;
                        CDLViewer.this.cdlDiagramField.setValue((Object)value);
                        CDLViewer.this.diagramsField.setSelected(0);
                    } else if (singleSelection instanceof PropertyDeclaration) {
                        PropertyDeclaration value = (PropertyDeclaration)singleSelection;
                        PropertyToObserver transformer = new PropertyToObserver(new PrintWriter(System.out));
                        Observer observer = transformer.toObserver(value);
                        try {
                            String dot = ObsUtil.toDot(observer);
                            Graph graph = DotUtil.layoutDot(dot);
                            CDLViewer.this.patternGraphField.setValue((Object)graph);
                        }
                        catch (Exception e) {
                            CDLViewer.this.handleError(2, DiagnosticUtil.createMessage((Throwable)e) + "/n");
                        }
                        CDLViewer.this.diagramsField.setSelected(1);
                    }
                }
            }
        });
        this.refreshCdls();
        this.cdlTree.setSingleSelection(null);
        this.cdlDiagramField.setValue(null);
    }

    private void createDiagramField() {
        this.cdlDiagramField = new DiagramField((Diagram)new CDLDiagram());
        this.cdlDiagramField.getController().setContainer((Object)this);
        this.cdlDiagramField.addAction(this.cdlDiagramField.getController().createIncreaseZoomAction());
        this.cdlDiagramField.addAction(this.cdlDiagramField.getController().createDecreaseZoomAction());
        this.patternTextField = new TextField(null, 3);
        this.patternTextField.setNbLines(2);
        this.patternGraphField = new DiagramField((Diagram)new GraphDiagram());
        this.patternField = new BorderField(2, this.patternGraphField);
        this.patternField.setNorth((Field)this.patternTextField, 30);
        this.diagramsField = new MultiPageField(new Field[]{this.cdlDiagramField, this.patternField});
    }

    public void open() {
        this.init();
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
        this.saveConfiguration();
        CDLResources.releaseInstance(CDLResources.class);
        this.display.dispose();
    }

    public boolean isShowErrors() {
        return this.showErrors;
    }

    public void setShowErrors(boolean showErrors) {
        this.showErrors = showErrors;
        if (this.editorField != null) {
            this.editorField.setMaximized((Field)(showErrors ? null : this.diagramsField));
        }
    }

    public void refreshErrorLogs() {
        this.errorLogsField.setValue(this.errorLogs);
    }

    public void handleError(Diagnostic diagnostic) {
        this.errorLogs.add(diagnostic);
        this.refreshErrorLogs();
    }

    public void handleError(int type, String message) {
        this.handleError((Diagnostic)new Diagnostic.Stub(type, message));
    }

    public String getLevelImageName(int level) {
        String imageName = "info_tsk.gif";
        if (level == 1) {
            imageName = "warn_tsk.gif";
        }
        if (level == 2) {
            imageName = "error_tsk.gif";
        }
        return imageName;
    }

    public void refreshCdls() {
        this.cdlTree.refresh();
    }

    public void loadUnit(File file) {
        OpenedUnit opened = new OpenedUnit(file);
        this.units.add(opened);
        this.loadUnit(opened);
    }

    private void loadUnit(OpenedUnit opened) {
        try {
            opened.load();
        }
        catch (Exception e) {
            this.handleError(2, "Can't load file '" + opened.getFile() + "': " + e.getMessage() + ".");
        }
        this.refreshCdls();
        this.cdlTree.setSingleSelection((Object)opened.getUnit());
    }

    public void closeUnit(OpenedUnit opened) {
        this.units.remove(opened);
        this.refreshCdls();
        if (!this.cdlTree.getValue().isEmpty()) {
            this.cdlTree.setSingleSelection(this.cdlTree.getValue().get(0));
        }
    }

    public void writeSelectedDiagramToPng(String file) throws Exception {
        Diagram diagram = null;
        switch (this.diagramsField.getSelected()) {
            case 0: {
                diagram = this.cdlDiagramField.getController().getDiagram();
                break;
            }
            case 1: {
                diagram = this.patternGraphField.getController().getDiagram();
            }
        }
        if (diagram != null) {
            DiagramUtils.exportToImage((Diagram)diagram, (String)file, (float)1.0f, (int)5);
        }
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public OpenedUnit getOpenedUnit(CDLDeclaration declaration) {
        return (OpenedUnit)this.cdlTree.getParent((Object)declaration);
    }

    public CDLResources getResources() {
        return this.resources;
    }

    public Shell getShell() {
        return this.shell;
    }

    public Object getSelection() {
        return this.cdlTree.getSingleSelection();
    }

    public void setSelection(Object newSelection) {
        this.cdlTree.setSingleSelection(newSelection);
    }

    public static void main(String[] args) throws Exception {
        new CDLViewer().open();
    }
}

