/*
 * Decompiled with CFR 0.152.
 */
package obp.fiacre.util;

import java.util.Map;
import obp.fiacre.model.Array;
import obp.fiacre.model.BasicType;
import obp.fiacre.model.BinExp;
import obp.fiacre.model.BoolType;
import obp.fiacre.model.ConstantRef;
import obp.fiacre.model.Exp;
import obp.fiacre.model.IntType;
import obp.fiacre.model.Interval;
import obp.fiacre.model.NatLiteral;
import obp.fiacre.model.NatType;
import obp.fiacre.model.Queue;
import obp.fiacre.model.Record;
import obp.fiacre.model.Type;
import obp.fiacre.model.TypeId;
import obp.fiacre.model.UnExp;
import obp.fiacre.model.Union;
import obp.fiacre.util.FiacrePrinter;
import org.xid.basics.generation.java.DependencyManager;

public class TypeUtil {
    public static String toJavaDeclaration(Type type, Map<Type, String> typeNames) {
        if (type instanceof BoolType) {
            return "boolean";
        }
        if (type instanceof IntType || type instanceof NatType || type instanceof Interval) {
            return "int";
        }
        if (type instanceof TypeId) {
            return TypeUtil.toJavaDeclaration(((TypeId)type).getDecl().getIs(), typeNames);
        }
        if (type instanceof Array) {
            Array arrayType = (Array)type;
            return TypeUtil.toJavaDeclaration(arrayType.getType(), typeNames) + "[]";
        }
        if (type instanceof Queue) {
            Queue queueType = (Queue)type;
            return TypeUtil.toJavaDeclaration(queueType.getType(), typeNames) + "[]";
        }
        return typeNames.get(type);
    }

    public static boolean isPrimitiveJavaType(Type type) {
        return (type = TypeUtil.referencedType(type)) instanceof BasicType || type instanceof Interval;
    }

    public static boolean isGeneratedClassType(Type type) {
        return (type = TypeUtil.referencedType(type)) instanceof Record || type instanceof Union;
    }

    public static boolean needDeepMethod(Type inner) {
        if (TypeUtil.arrayOrQueueDimension(inner = TypeUtil.referencedType(inner)) > 1) {
            return true;
        }
        return inner instanceof Queue || inner instanceof Array || inner instanceof Record || inner instanceof Union;
    }

    public static boolean isUnionType(Type type) {
        type = TypeUtil.referencedType(type);
        return type instanceof Union;
    }

    public static boolean isArrayType(Type type) {
        type = TypeUtil.referencedType(type);
        return type instanceof Array;
    }

    public static boolean isQueueType(Type type) {
        type = TypeUtil.referencedType(type);
        return type instanceof Queue;
    }

    public static boolean isIntegerType(Type type) {
        return (type = TypeUtil.referencedType(type)) instanceof IntType || type instanceof NatType || type instanceof Interval;
    }

    public static Type referencedType(Type type) {
        if (type instanceof TypeId) {
            return TypeUtil.referencedType(((TypeId)type).getDecl().getIs());
        }
        return type;
    }

    public static Type arrayOrQueueOf(Type inner) {
        if ((inner = TypeUtil.referencedType(inner)) instanceof Array) {
            return TypeUtil.arrayOrQueueOf(((Array)inner).getType());
        }
        if (inner instanceof Queue) {
            return TypeUtil.arrayOrQueueOf(((Queue)inner).getType());
        }
        return inner;
    }

    public static int arrayOrQueueDimension(Type inner) {
        if ((inner = TypeUtil.referencedType(inner)) instanceof Array) {
            return 1 + TypeUtil.arrayOrQueueDimension(((Array)inner).getType());
        }
        if (inner instanceof Queue) {
            return 1 + TypeUtil.arrayOrQueueDimension(((Queue)inner).getType());
        }
        return 1;
    }

    public static int computeArraySizeExpression(Exp exp) {
        if (exp instanceof NatLiteral) {
            return ((NatLiteral)exp).getValue();
        }
        if (exp instanceof UnExp) {
            UnExp un = (UnExp)exp;
            int child = TypeUtil.computeArraySizeExpression(un.getExp());
            switch (un.getUnop()) {
                case UMINUS: {
                    return -child;
                }
            }
            throw new IllegalArgumentException("Doesn't support expression '" + FiacrePrinter.toString(exp) + "' in array size declaration.");
        }
        if (exp instanceof BinExp) {
            BinExp bin = (BinExp)exp;
            int left = TypeUtil.computeArraySizeExpression(bin.getLeft());
            int right = TypeUtil.computeArraySizeExpression(bin.getRight());
            switch (bin.getBinOp()) {
                case BADD: {
                    return left + right;
                }
                case BMINUS: {
                    return left - right;
                }
                case BMUL: {
                    return left * right;
                }
                case BDIV: {
                    return left / right;
                }
                case BMOD: {
                    return left % right;
                }
            }
            throw new IllegalArgumentException("Doesn't support expression '" + FiacrePrinter.toString(exp) + "' in array size declaration.");
        }
        if (exp instanceof ConstantRef) {
            ConstantRef ref = (ConstantRef)exp;
            return TypeUtil.computeArraySizeExpression(ref.getDecl().getValue());
        }
        throw new IllegalArgumentException("Doesn't support expression '" + FiacrePrinter.toString(exp) + "' in array size declaration.");
    }

    public static String generateEqualsTest(String left, String right, Type type) {
        type = TypeUtil.referencedType(type);
        Type inner = null;
        if (type instanceof Array) {
            inner = ((Array)type).getType();
        } else if (type instanceof Queue) {
            inner = ((Queue)type).getType();
        }
        if (inner != null) {
            if (TypeUtil.needDeepMethod(inner)) {
                return "Arrays.deepEquals(" + left + ", " + right + ")";
            }
            return "Arrays.equals(" + left + ", " + right + ")";
        }
        if (TypeUtil.isGeneratedClassType(type)) {
            return left + ".equals(" + right + ")";
        }
        return left + " == " + right;
    }

    public static String generateToStringCode(String name, Type type, DependencyManager dependencyManager) {
        if ((type = TypeUtil.referencedType(type)) instanceof Array) {
            Array array = (Array)type;
            dependencyManager.getShortName("java.util.Arrays");
            if (TypeUtil.needDeepMethod(array.getType())) {
                return "Arrays.deepToString(" + name + ")";
            }
            return "Arrays.toString(" + name + ")";
        }
        if (type instanceof Queue) {
            Queue queue = (Queue)type;
            dependencyManager.getShortName("java.util.Arrays");
            if (TypeUtil.needDeepMethod(queue.getType())) {
                return "Arrays.deepToString(" + name + ")";
            }
            return "Arrays.toString(" + name + ")";
        }
        if (TypeUtil.isIntegerType(type)) {
            return "Integer.toString(" + name + ")";
        }
        if (type instanceof BoolType) {
            return "Boolean.toString(" + name + ")";
        }
        return name + ".toString()";
    }
}

