/*
 * Decompiled with CFR 0.152.
 */
package obp.explorer.runtime.fiacre;

import obp.cc.ConcreteContext;
import obp.explorer.runtime.EnvFactory;
import obp.explorer.runtime.ExplorationContext;
import obp.explorer.runtime.ProcessBehavior;
import obp.explorer.runtime.SymbolsTable;
import obp.explorer.runtime.evaluator.Evaluator;
import obp.explorer.runtime.evaluator.Tester;
import obp.explorer.runtime.fiacre.ConcreteContextBehavior;
import obp.explorer.runtime.fiacre.PredicateToEvaluator;
import obp.explorer.runtime.obs.ObsBehavior;

public class ConcreteContextEnvFactory
implements EnvFactory {
    public static final ConcreteContextEnvFactory empty = new ConcreteContextEnvFactory(null);
    private final ConcreteContext cc;

    public ConcreteContextEnvFactory(ConcreteContext cc) {
        this.cc = cc;
    }

    @Override
    public ProcessBehavior createEnv(ExplorationContext context, SymbolsTable symbols) {
        try {
            return new ConcreteContextBehavior(this.cc, symbols);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ObsBehavior[] createObservers(ExplorationContext context, SymbolsTable symbols) {
        int obsCount = this.cc == null ? 0 : this.cc.getObserverCount();
        ObsBehavior[] obsBehaviors = new ObsBehavior[obsCount];
        for (int i = 0; i < this.cc.getObserverCount(); ++i) {
            obsBehaviors[i] = new ObsBehavior(this.cc.getObserver(i), symbols);
        }
        return obsBehaviors;
    }

    @Override
    public Tester[] createAsserts(ExplorationContext context, SymbolsTable symbols) {
        Tester[] testers = new Tester[this.cc.getAssertCount()];
        for (int i = 0; i < testers.length; ++i) {
            Evaluator matcher = PredicateToEvaluator.toEvaluator(this.cc.getAssert(i), context, symbols);
            testers[i] = new Tester(matcher);
        }
        return testers;
    }
}

