/*
 * Decompiled with CFR 0.152.
 */
package org.xid.basics.generation.java;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class DependencyManager {
    protected final Set<String> imports = new TreeSet<String>();
    protected final Map<String, String> shortNameImport = new HashMap<String, String>();

    public DependencyManager() {
        this.initialize();
    }

    protected void initialize() {
        this.getShortName("java.lang.String");
        this.getShortName("java.lang.Integer");
    }

    public void clear() {
        this.imports.clear();
        this.shortNameImport.clear();
        this.initialize();
    }

    public String getShortName(String qualifiedName) {
        if (!this.shortNameImport.containsKey(qualifiedName)) {
            int dotIndex = (qualifiedName = qualifiedName.replace("$", ".")).lastIndexOf(46);
            if (dotIndex < 0) {
                this.shortNameImport.put(qualifiedName, qualifiedName);
            } else {
                String shortName = qualifiedName.substring(dotIndex + 1);
                if (this.shortNameImport.containsValue(shortName)) {
                    this.shortNameImport.put(qualifiedName, qualifiedName);
                } else {
                    if (!qualifiedName.startsWith("java.lang")) {
                        this.imports.add(qualifiedName);
                    }
                    this.shortNameImport.put(qualifiedName, shortName);
                }
            }
        }
        return this.shortNameImport.get(qualifiedName);
    }

    public String getSpaceSeparedImports() {
        StringBuffer buffer = new StringBuffer();
        for (String qualifiedName : this.imports) {
            buffer.append(qualifiedName + " ");
        }
        return buffer.toString();
    }

    public String[] getJavaImports() {
        String[] result = new String[this.imports.size()];
        return this.imports.toArray(result);
    }
}

