/*
 * Decompiled with CFR 0.152.
 */
package tlc2.value;

import java.util.List;
import java.util.Random;
import tlc2.TLCGlobals;
import tlc2.tool.FingerprintException;
import tlc2.tool.ModelChecker;
import tlc2.tool.TLCState;
import tlc2.util.IdThread;
import tlc2.value.Enumerable;
import tlc2.value.SetEnumValue;
import tlc2.value.Value;
import tlc2.value.ValueConstants;
import tlc2.value.ValueEnumeration;

public abstract class EnumerableValue
extends Value
implements Enumerable,
ValueConstants {
    private static long randomSeed;
    private static final ThreadLocal<Random> RANDOMS;

    @Override
    public Value isSubsetEq(Value other) {
        try {
            Value elem;
            ValueEnumeration Enum2 = this.elements();
            while ((elem = Enum2.nextElement()) != null) {
                if (other.member(elem)) continue;
                return ValFalse;
            }
            return ValTrue;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public EnumerableValue getRandomSubset(int kOutOfN) {
        return SetEnumValue.convert(this).getRandomSubset(kOutOfN);
    }

    @Override
    public ValueEnumeration elements(int k) {
        final List<Value> values = this.elements().all();
        return new SubsetEnumerator(k){

            @Override
            public Value nextElement() {
                if (!this.hasNext()) {
                    return null;
                }
                return (Value)values.get(this.nextIndex());
            }
        };
    }

    public static long getRandomSeed() {
        return randomSeed;
    }

    public static void setRandom(long seed) {
        randomSeed = seed;
        EnumerableValue.resetRandom();
    }

    public static void resetRandom() {
        RANDOMS.remove();
    }

    public static Random getRandom() {
        return RANDOMS.get();
    }

    static {
        RANDOMS = new ThreadLocal<Random>(){

            @Override
            protected Random initialValue() {
                if (TLCGlobals.mainChecker != null && ModelChecker.class.equals(TLCGlobals.mainChecker.getClass())) {
                    return new TLCStateRandom(randomSeed);
                }
                return new DefaultRandom(randomSeed);
            }

            @Override
            public Random get() {
                return ((EnumerableValueRandom)super.get()).initialize();
            }
        };
    }

    abstract class SubsetEnumerator
    implements ValueEnumeration {
        protected final long x;
        protected final int a;
        protected final int n;
        protected final int k;
        protected int i;

        public SubsetEnumerator(int k) {
            this(k, this$0.size());
        }

        public SubsetEnumerator(int k, int n) {
            this.n = n;
            assert (n < Integer.MAX_VALUE);
            long l = this.x = n < 191 ? 191L : Integer.MAX_VALUE;
            if (n > 0) {
                this.k = k;
                this.a = EnumerableValue.getRandom().nextInt(n);
            } else {
                this.k = 0;
                this.a = 0;
            }
        }

        @Override
        public void reset() {
            this.i = 0;
        }

        public boolean hasNext() {
            return this.i < this.k;
        }

        public int nextIndex() {
            if (this.n <= 0) {
                ++this.i;
                return 0;
            }
            int index = (int)((this.x * (long)this.i++ + (long)this.a) % (long)this.n);
            assert (0 <= index && index < this.n);
            return index;
        }

        @Override
        public abstract Value nextElement();
    }

    private static final class TLCStateRandom
    extends Random
    implements EnumerableValueRandom {
        private TLCState state;

        public TLCStateRandom(long randomSeed) {
            super(randomSeed);
        }

        private void initializedFor(TLCState state) {
            long seed = state.fingerPrint() ^ randomSeed;
            this.setSeed(seed);
            this.state = state;
        }

        private boolean isInitializedFor(TLCState another) {
            return this.state == another;
        }

        @Override
        public Random initialize() {
            TLCState state = IdThread.getCurrentState();
            if (state != null && !this.isInitializedFor(state)) {
                this.initializedFor(state);
            }
            return this;
        }
    }

    private static final class DefaultRandom
    extends Random
    implements EnumerableValueRandom {
        public DefaultRandom(long randomSeed) {
            super(randomSeed);
        }

        @Override
        public final Random initialize() {
            return this;
        }
    }

    private static interface EnumerableValueRandom {
        public Random initialize();
    }
}

