/*
 * Decompiled with CFR 0.152.
 */
package obp.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import obp.cdl.CDLUnit;
import obp.cdl.Declaration;
import obp.cdl.ProcessId;
import obp.cdl.parser.CDLLexer;
import obp.cdl.parser.CDLParser;
import obp.cdl.parser.CDLReferenceResolver;
import org.xid.basics.error.Diagnostic;

public class CDLUtil {
    public static final String TO_CONTEXT = "toContext";
    public static final String ENV_NAME = "env";
    public static final List<String> BUILT_IN_TYPES = Arrays.asList("boolean", "integer", "string");

    public static CDLUnit readCDLAndResolveReferences(File file) throws Exception {
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
        return CDLUtil.readCDLAndResolveReferences(in);
    }

    public static CDLUnit readCDLAndResolveReferences(String contents) throws Exception {
        BufferedInputStream in = new BufferedInputStream(new ByteArrayInputStream(contents.getBytes("UTF-8")));
        return CDLUtil.readCDLAndResolveReferences(in);
    }

    public static CDLUnit readCDLAndResolveReferences(InputStream in) throws Exception {
        CDLUnit unit = CDLUtil.readCDL(in);
        CDLUtil.resolveReferences(unit);
        return unit;
    }

    public static CDLUnit readCDL(String contents) throws Exception {
        BufferedInputStream in = new BufferedInputStream(new ByteArrayInputStream(contents.getBytes("UTF-8")));
        return CDLUtil.readCDL(in);
    }

    public static CDLUnit readCDL(InputStream in) throws Exception {
        CDLLexer lexer = new CDLLexer(in);
        CDLParser parser = new CDLParser();
        CDLUnit unit = null;
        try {
            unit = (CDLUnit)parser.parse(lexer);
        }
        catch (RuntimeException e) {
            throw new Exception(e.getMessage());
        }
        in.close();
        return unit;
    }

    public static <T extends Declaration> T findDeclaration(CDLUnit unit, String name, Class<T> type) {
        for (Declaration declaration : unit.getDeclarationList()) {
            if (!name.equals(declaration.getName()) || !type.isInstance(declaration)) continue;
            return (T)((Declaration)type.cast(declaration));
        }
        return null;
    }

    public static <T extends Declaration> List<T> findAllDeclarations(CDLUnit unit, Class<T> type) {
        ArrayList<T> result = new ArrayList<T>();
        for (Declaration declaration : unit.getDeclarationList()) {
            if (!type.isInstance(declaration)) continue;
            result.add(type.cast(declaration));
        }
        return result;
    }

    public static String toString(ProcessId pid) {
        if (pid == null) {
            return "{" + CDLUtil.envName() + "}" + 1;
        }
        StringBuilder result = new StringBuilder();
        result.append("{");
        result.append(pid.getName());
        result.append("}");
        result.append(pid.getId());
        return result.toString();
    }

    public static String envName() {
        return ENV_NAME;
    }

    public static String toQueueName(ProcessId pid) {
        return pid.getName() + "_" + pid.getId();
    }

    public static void resolveReferences(CDLUnit unit) {
        CDLReferenceResolver resolver = new CDLReferenceResolver(unit);
        unit.accept(resolver);
        if (resolver.getErrors().size() > 0) {
            StringBuilder message = new StringBuilder();
            for (Diagnostic diagnostic : resolver.getErrors()) {
                if (message.length() > 0) {
                    message.append("\n");
                }
                message.append(diagnostic.getMessage());
            }
            throw new RuntimeException(message.toString());
        }
    }
}

