/*
 * Decompiled with CFR 0.152.
 */
package obp.ui.ifx;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import obp.ifx.IFxConfiguration;
import obp.ifx.IFxController;
import obp.ui.ifx.ActionField;
import obp.ui.ifx.Actions;
import obp.ui.ifx.Resources;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.xid.basics.error.Diagnostic;
import org.xid.basics.error.DiagnosticUtil;
import org.xid.basics.error.ErrorHandler;
import org.xid.basics.notification.Notification;
import org.xid.basics.notification.NotificationListener;
import org.xid.basics.progress.ActionMonitor;
import org.xid.basics.serializer.BoostObject;
import org.xid.basics.serializer.JBoost;
import org.xid.basics.ui.PlatformUtil;
import org.xid.basics.ui.action.Action;
import org.xid.basics.ui.action.ActionExecuter;
import org.xid.basics.ui.dialog.FieldShellToolkit;
import org.xid.basics.ui.field.BorderField;
import org.xid.basics.ui.field.CompositeField;
import org.xid.basics.ui.field.ConsoleField;
import org.xid.basics.ui.field.Field;
import org.xid.basics.ui.field.ListField;
import org.xid.basics.ui.field.MultiTabField;
import org.xid.basics.ui.field.TextField;

public class IFxUI {
    private String version;
    private String date;
    private Display display;
    private Shell shell;
    private FieldShellToolkit toolkit;
    private Actions actions;
    private Resources resources;
    private BorderField shellField;
    private MultiTabField centerField;
    private TextField systemFileField;
    private TextField systemSourceField;
    private ListField<File> observerFileListField;
    private TextField observerFileField;
    private TextField observerSourceField;
    private MultiTabField southField;
    private ConsoleField consoleField;
    private CompositeField consoleCompositeField;
    private IFxConfiguration ifxConfiguration = null;
    private IFxController ifxController = null;
    private boolean explored = false;
    private boolean working = false;
    private ActionExecuter executer = new ActionExecuter(){

        public void executeAction(Action action) {
            action.run(ActionMonitor.empty);
            if (!IFxUI.this.shell.isDisposed()) {
                IFxUI.this.display.asyncExec(IFxUI.this.refreshRunnable);
            }
        }
    };
    private Runnable refreshRunnable = new Runnable(){

        @Override
        public void run() {
            IFxUI.this.refreshFields();
            IFxUI.this.consoleField.scrollToTheEnd();
        }
    };
    private ErrorHandler errorHandler = new ErrorHandler(){

        public void handleError(int type, String message) {
            this.handleError((Diagnostic)new Diagnostic.Stub(type, message));
        }

        public void handleError(Diagnostic diagnostic) {
            switch (diagnostic.getLevel()) {
                case 0: {
                    IFxUI.this.log(diagnostic.getMessage());
                    break;
                }
                case 1: {
                    IFxUI.this.warning(diagnostic.getMessage());
                    break;
                }
                case 2: {
                    IFxUI.this.error(diagnostic.getMessage());
                }
            }
        }
    };
    private File systemFile;
    private long systemFileModifiedDate = -1L;
    private String systemSource;
    private List<File> observerFiles = new ArrayList<File>();
    private List<Long> observerFileModifiedDates = new ArrayList<Long>();
    private List<String> observerSources = new ArrayList<String>();

    public File getSystemFile() {
        return this.systemFile;
    }

    public void setSystemFile(File systemFile) {
        this.systemFile = systemFile;
        this.explored = false;
        if (systemFile != null) {
            this.systemFileModifiedDate = systemFile.lastModified();
            this.systemSource = Actions.loadContents(systemFile);
        }
    }

    public String getSystemSource() {
        return this.systemSource;
    }

    public List<File> getObserverFiles() {
        return this.observerFiles;
    }

    public void addObserverFile(File file) {
        if (!this.observerFiles.contains(file)) {
            this.explored = false;
            this.observerFiles.add(file);
            this.observerFileModifiedDates.add(file.lastModified());
            this.observerSources.add(Actions.loadContents(file));
        }
    }

    public void removeObserverFile(File file) {
        int index = this.observerFiles.indexOf(file);
        if (index >= 0) {
            this.explored = false;
            this.observerFiles.remove(index);
            this.observerFileModifiedDates.remove(index);
            this.observerSources.remove(index);
        }
    }

    public File getSelectedObserver() {
        return (File)this.observerFileListField.getSingleSelection();
    }

    public void selectObserver(File file) {
        this.observerFileListField.setSingleSelection((Object)file);
    }

    public String getObserverSource(File file) {
        return this.observerSources.get(this.observerFiles.indexOf(file));
    }

    public Shell getShell() {
        return this.shell;
    }

    public Resources getResources() {
        return this.resources;
    }

    public IFxConfiguration getIfxConfiguration() {
        return this.ifxConfiguration;
    }

    private File getConfigurationFile() {
        return new File(System.getProperty("user.home"), ".IFxUI.conf");
    }

    private JBoost createConfigurationBoost() {
        return new JBoost("IFxConf", 2);
    }

    private void saveConfiguration() {
        try {
            JBoost boost = this.createConfigurationBoost();
            boost.initializeWriting((OutputStream)new FileOutputStream(this.getConfigurationFile()));
            boost.writeObject((BoostObject)this.ifxConfiguration);
            boost.close();
        }
        catch (Exception e) {
            this.log("Can't save configuration to file '" + this.getConfigurationFile().getAbsolutePath() + "'.");
        }
    }

    private void initVersion() {
        try {
            Properties properties = new Properties();
            properties.load(this.getClass().getResourceAsStream("version.properties"));
            this.version = properties.getProperty("version");
            this.date = properties.getProperty("date");
        }
        catch (Exception e) {
            this.warning(DiagnosticUtil.createMessage((Throwable)e));
            this.version = "unknown";
            this.date = "unknown";
        }
        this.printVersion();
    }

    private void initIFx() {
        try {
            JBoost boost = this.createConfigurationBoost();
            boost.initializeReading((InputStream)new FileInputStream(this.getConfigurationFile()));
            this.ifxConfiguration = (IFxConfiguration)boost.readObject(IFxConfiguration.class);
            boost.close();
        }
        catch (Exception e) {
            this.ifxConfiguration = new IFxConfiguration();
        }
        this.ifxController = new IFxController(this.ifxConfiguration, this.consoleField.createPrintWriter(2, 0), this.consoleField.createPrintWriter(4, 1));
        this.ifxController.setErrorHandler(this.errorHandler);
    }

    public void open() {
        this.display = new Display();
        this.resources = (Resources)Resources.getInstance(Resources.class);
        this.actions = new Actions(this);
        this.shell = FieldShellToolkit.createShell((Display)this.display, (String)"OBP: IFx");
        this.toolkit = new FieldShellToolkit(this.shell, "OBP: IFx", 1, this.createFields());
        this.toolkit.setBannerImage(this.resources.getImage("obp60x40.png"));
        this.toolkit.setActionExecuter(this.executer);
        this.toolkit.setMenuActions(this.actions.getMenuAction().getActions());
        this.toolkit.init();
        PlatformUtil.registerCocoaNameAboutAndPreference((String)"IFxUI", (Action)new Action.Stub(), (Action)this.actions.getPreferencesAction());
        this.initVersion();
        this.initIFx();
        this.refreshFields();
        this.toolkit.validateAll();
        this.installActivateListener();
        this.shell.setSize(800, 600);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
        this.dispose();
    }

    public void installActivateListener() {
        this.shell.addListener(26, new Listener(){

            public void handleEvent(Event event) {
                if (IFxUI.this.systemFile != null && IFxUI.this.systemFile.lastModified() > IFxUI.this.systemFileModifiedDate) {
                    IFxUI.this.setSystemFile(IFxUI.this.systemFile);
                    IFxUI.this.explored = false;
                    IFxUI.this.log("System file '" + IFxUI.this.systemFile.getName() + "' reloaded.\n");
                    IFxUI.this.refreshSystemFields();
                }
                for (int i = 0; i < IFxUI.this.observerFiles.size(); ++i) {
                    File observerFile = (File)IFxUI.this.observerFiles.get(i);
                    long lastModified = observerFile.lastModified();
                    if (lastModified <= (Long)IFxUI.this.observerFileModifiedDates.get(i)) continue;
                    IFxUI.this.explored = false;
                    IFxUI.this.observerFileModifiedDates.set(i, lastModified);
                    IFxUI.this.observerSources.set(i, Actions.loadContents(observerFile));
                    IFxUI.this.log("Observer file '" + observerFile.getName() + "' reloaded.\n");
                    IFxUI.this.refreshObserverFields();
                }
            }
        });
    }

    private Field createFields() {
        this.centerField = new MultiTabField(null, 64);
        this.systemFileField = new TextField("System File", 3);
        this.systemFileField.addAction(this.actions.getOpenSystemAction());
        this.systemSourceField = new TextField(null, 3);
        this.systemSourceField.setNbLines(10);
        CompositeField systemCompositeField = new CompositeField("System", new Field[]{this.systemFileField, this.systemSourceField});
        this.centerField.addTab((Field)systemCompositeField, null, false);
        this.observerFileListField = new ListField<File>(null, 2){

            public String getText(File element) {
                return element.getName();
            }
        };
        this.observerFileListField.addListener(new NotificationListener(){

            public void notified(Notification notification) {
                if ("selection".equals(notification.name)) {
                    IFxUI.this.refreshObserverInfo();
                }
            }
        });
        ActionField observersActionField = new ActionField();
        observersActionField.addAction(this.actions.getOpenObserverAction());
        observersActionField.addAction(this.actions.getRemoveObserverAction());
        CompositeField observersListComposite = new CompositeField(new Field[]{observersActionField, this.observerFileListField});
        this.observerFileField = new TextField("Observer File", 3);
        this.observerSourceField = new TextField(null, 3);
        this.observerSourceField.setNbLines(10);
        CompositeField observerCompositeField = new CompositeField(new Field[]{this.observerFileField, this.observerSourceField});
        BorderField observersCompositeField = new BorderField("Observers", 2, (Field)observerCompositeField);
        observersCompositeField.setWest((Field)observersListComposite, 30);
        this.centerField.addTab((Field)observersCompositeField, null, false);
        this.centerField.addAction(this.actions.getExploreSystemAction());
        this.centerField.addAction(this.actions.getCleanAction());
        this.centerField.addAction(this.actions.getStopAction());
        this.southField = new MultiTabField(null, 64);
        this.consoleField = new ConsoleField();
        this.consoleCompositeField = new CompositeField("Console", new Field[]{this.consoleField});
        this.southField.addTab((Field)this.consoleCompositeField, this.resources.getImage("eclipse/console_view.gif"), false);
        this.shellField = new BorderField(2, (Field)this.centerField);
        this.shellField.setSouth((Field)this.southField, 30);
        this.shellField.setActionExecuter(this.executer);
        return this.shellField;
    }

    public void refreshFields() {
        this.refreshMessage();
        this.refreshSystemFields();
        this.refreshObserverFields();
    }

    public void refreshMessage() {
    }

    public void refreshSystemFields() {
        if (this.systemFile != null) {
            this.systemFileField.setValue(this.systemFile.getAbsolutePath());
        } else {
            this.systemFileField.setValue("No system loaded.");
        }
        this.systemSourceField.setValue(this.systemSource);
    }

    public void refreshObserverFields() {
        this.observerFileListField.setValue(this.observerFiles);
    }

    public void refreshObserverInfo() {
        File observerFile = (File)this.observerFileListField.getSingleSelection();
        if (observerFile != null) {
            this.observerFileField.setValue(observerFile.getAbsolutePath());
            this.observerSourceField.setValue(this.getObserverSource(observerFile));
        } else {
            this.observerFileField.setValue(null);
            this.observerSourceField.setValue(null);
        }
    }

    private void dispose() {
        Resources.releaseInstance(Resources.class);
        this.ifxController.stop();
        this.saveConfiguration();
    }

    public boolean isWorking() {
        return this.working;
    }

    public boolean isExplored() {
        return this.explored;
    }

    public boolean hasError() {
        return this.shellField.getDiagnostic() != null;
    }

    public boolean canExplore() {
        return !this.hasError() && !this.working && this.systemFile != null;
    }

    public boolean canShowExploration() {
        return !this.hasError() && this.isExplored();
    }

    public boolean canClean() {
        return !this.hasError() && this.isExplored();
    }

    public void explore() {
        if (!this.canExplore()) {
            return;
        }
        this.working = true;
        this.explored = false;
        this.ifxController.exploreIF(this.systemFile, this.observerFiles, (ActionMonitor)new ActionMonitor.Stub(){

            public void done() {
                IFxUI.this.working = false;
                IFxUI.this.explored = true;
                IFxUI.this.display.asyncExec(IFxUI.this.refreshRunnable);
            }

            public void canceled() {
                IFxUI.this.working = false;
                IFxUI.this.display.asyncExec(IFxUI.this.refreshRunnable);
            }
        });
    }

    public void clean() {
        if (!this.canClean()) {
            return;
        }
        this.working = true;
        this.ifxController.clean((ActionMonitor)new ActionMonitor.Stub(){

            public void done() {
                IFxUI.this.working = false;
                IFxUI.this.explored = false;
                IFxUI.this.display.asyncExec(IFxUI.this.refreshRunnable);
            }

            public void canceled() {
                IFxUI.this.working = false;
                IFxUI.this.explored = false;
                IFxUI.this.display.asyncExec(IFxUI.this.refreshRunnable);
            }
        });
    }

    public void stopCurrentAction() {
        if (!this.isWorking()) {
            return;
        }
        this.ifxController.interrupt();
        this.working = false;
    }

    public void printVersion() {
        this.log("IFxUI version " + this.version + " (" + this.date + ").\n");
    }

    public void log(final String message) {
        this.display.asyncExec(new Runnable(){

            @Override
            public void run() {
                IFxUI.this.consoleField.log(message);
            }
        });
    }

    public void warning(final String message) {
        this.display.asyncExec(new Runnable(){

            @Override
            public void run() {
                IFxUI.this.consoleField.log(message, 8, 2);
                IFxUI.this.southField.setSelected((Field)IFxUI.this.consoleCompositeField);
            }
        });
    }

    public void error(final String message) {
        this.display.asyncExec(new Runnable(){

            @Override
            public void run() {
                IFxUI.this.consoleField.log(message, 4, 1);
                IFxUI.this.southField.setSelected((Field)IFxUI.this.consoleCompositeField);
            }
        });
    }

    public void clearConsole() {
        this.display.asyncExec(new Runnable(){

            @Override
            public void run() {
                IFxUI.this.consoleField.clear();
            }
        });
    }

    public static void main(String[] args) {
        new IFxUI().open();
    }
}

