/*
 * Decompiled with CFR 0.152.
 */
package obp.transfo.ltl;

import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Stack;
import obp.LTL.model.Atom;
import obp.LTL.model.AtomReference;
import obp.LTL.model.Conjunction;
import obp.LTL.model.Disjunction;
import obp.LTL.model.Equivalence;
import obp.LTL.model.Eventually;
import obp.LTL.model.Expression;
import obp.LTL.model.FormulaDeclaration;
import obp.LTL.model.FormulaReference;
import obp.LTL.model.Globally;
import obp.LTL.model.Implication;
import obp.LTL.model.ModelVisitor;
import obp.LTL.model.Negation;
import obp.LTL.model.Next;
import obp.LTL.model.Release;
import obp.LTL.model.Until;

public class LTL2AbstractText
implements ModelVisitor {
    Stack<String> stack = new Stack();
    Map<Atom, String> atom2id = new IdentityHashMap<Atom, String>();
    int atomID = 0;

    void push(String s) {
        this.stack.push(s);
    }

    String pop() {
        return this.stack.pop();
    }

    String toString(FormulaDeclaration formula) {
        formula.accept(this);
        return this.pop();
    }

    @Override
    public void visitAtom(Atom toVisit) {
        if (toVisit.getName() == null) {
            toVisit.setName("atom" + this.atomID++);
        }
    }

    @Override
    public void visitExpression(Expression toVisit) {
    }

    @Override
    public void visitAtomReference(AtomReference toVisit) {
        this.push(toVisit.getAtom().getName());
    }

    @Override
    public void visitRelease(Release toVisit) {
        toVisit.getLhs().accept(this);
        String lhs = this.pop();
        toVisit.getRhs().accept(this);
        String rhs = this.pop();
        this.push("(" + lhs + " R " + rhs + ")");
    }

    @Override
    public void visitUntil(Until toVisit) {
        toVisit.getLhs().accept(this);
        String lhs = this.pop();
        toVisit.getRhs().accept(this);
        String rhs = this.pop();
        this.push("(" + lhs + " U " + rhs + ")");
    }

    @Override
    public void visitConjunction(Conjunction toVisit) {
        toVisit.getLhs().accept(this);
        String lhs = this.pop();
        toVisit.getRhs().accept(this);
        String rhs = this.pop();
        this.push("(" + lhs + " && " + rhs + ")");
    }

    @Override
    public void visitDisjunction(Disjunction toVisit) {
        toVisit.getLhs().accept(this);
        String lhs = this.pop();
        toVisit.getRhs().accept(this);
        String rhs = this.pop();
        this.push("(" + lhs + " || " + rhs + ")");
    }

    @Override
    public void visitImplication(Implication toVisit) {
        toVisit.getLhs().accept(this);
        String lhs = this.pop();
        toVisit.getRhs().accept(this);
        String rhs = this.pop();
        this.push("(" + lhs + " -> " + rhs + ")");
    }

    @Override
    public void visitEquivalence(Equivalence toVisit) {
        toVisit.getLhs().accept(this);
        String lhs = this.pop();
        toVisit.getRhs().accept(this);
        String rhs = this.pop();
        this.push("(" + lhs + " <-> " + rhs + ")");
    }

    @Override
    public void visitNegation(Negation toVisit) {
        toVisit.getOperand().accept(this);
        String operand = this.pop();
        this.push("(! " + operand + ")");
    }

    @Override
    public void visitEventually(Eventually toVisit) {
        toVisit.getOperand().accept(this);
        String operand = this.pop();
        this.push("(<> " + operand + ")");
    }

    @Override
    public void visitGlobally(Globally toVisit) {
        toVisit.getOperand().accept(this);
        String operand = this.pop();
        this.push("([] " + operand + ")");
    }

    @Override
    public void visitNext(Next toVisit) {
        toVisit.getOperand().accept(this);
        String operand = this.pop();
        this.push("(X " + operand + ")");
    }

    @Override
    public void visitFormulaDeclaration(FormulaDeclaration toVisit) {
        for (Atom atom : toVisit.getAtomsList()) {
            atom.accept(this);
        }
        toVisit.getExpression().accept(this);
    }

    @Override
    public void visitFormulaReference(FormulaReference toVisit) {
    }
}

