/*
 * Decompiled with CFR 0.152.
 */
package obp.fiacre.transfo;

import java.util.HashMap;
import java.util.Map;
import obp.fiacre.model.ArgumentVariable;
import obp.fiacre.model.Array;
import obp.fiacre.model.ArrayElem;
import obp.fiacre.model.ArrayPattern;
import obp.fiacre.model.BinExp;
import obp.fiacre.model.BoolLiteral;
import obp.fiacre.model.CaseStmt;
import obp.fiacre.model.ChannelDecl;
import obp.fiacre.model.ComponentDecl;
import obp.fiacre.model.CondExp;
import obp.fiacre.model.ConstantDecl;
import obp.fiacre.model.Constr;
import obp.fiacre.model.ConstrExp;
import obp.fiacre.model.ConstrPattern;
import obp.fiacre.model.Declaration;
import obp.fiacre.model.DeterministicAssignment;
import obp.fiacre.model.Emission;
import obp.fiacre.model.Field;
import obp.fiacre.model.FieldPattern;
import obp.fiacre.model.Foreach;
import obp.fiacre.model.IfStmt;
import obp.fiacre.model.InlineArray;
import obp.fiacre.model.InlineRecord;
import obp.fiacre.model.Instance;
import obp.fiacre.model.InterfacedComp;
import obp.fiacre.model.LocalPortDecl;
import obp.fiacre.model.LocalVariable;
import obp.fiacre.model.ModelVisitor;
import obp.fiacre.model.NatLiteral;
import obp.fiacre.model.NonDeterministicAssignment;
import obp.fiacre.model.NullStmt;
import obp.fiacre.model.Par;
import obp.fiacre.model.ParamPortDecl;
import obp.fiacre.model.ProcessDecl;
import obp.fiacre.model.Profile;
import obp.fiacre.model.Program;
import obp.fiacre.model.Queue;
import obp.fiacre.model.Reception;
import obp.fiacre.model.Record;
import obp.fiacre.model.RecordElem;
import obp.fiacre.model.Rule;
import obp.fiacre.model.Select;
import obp.fiacre.model.Seq;
import obp.fiacre.model.SingleAssignment;
import obp.fiacre.model.State;
import obp.fiacre.model.To;
import obp.fiacre.model.Transition;
import obp.fiacre.model.TypeDecl;
import obp.fiacre.model.UnExp;
import obp.fiacre.model.Union;
import obp.fiacre.model.ValuedField;
import obp.fiacre.model.VarRef;
import obp.fiacre.model.Wait;
import obp.fiacre.model.WhileStmt;

public class FiacreScrambler
extends ModelVisitor.Stub {
    private static final String componentName = "comp";
    private static final String processName = "proc";
    private static final String typeName = "t";
    private static final String fieldName = "fe";
    private static final String constrName = "co";
    private static final String variableName = "v";
    private static final String constantName = "c";
    private static final String channelName = "ch";
    private static final String portName = "p";
    private static final String stateName = "s";
    private int seed = 0;
    private Map<String, String> fieldNames = new HashMap<String, String>();
    private Map<String, String> constrNames = new HashMap<String, String>();

    public static void scramble(Program program) {
        program.accept(new FiacreScrambler());
    }

    private FiacreScrambler() {
    }

    private String newName(String prefix) {
        return prefix + this.seed++;
    }

    private String newFieldName(String original) {
        if (this.fieldNames.containsKey(original)) {
            return this.fieldNames.get(original);
        }
        String name = fieldName + this.seed++;
        this.fieldNames.put(original, name);
        return name;
    }

    private String newConstrName(String original) {
        if (this.constrNames.containsKey(original)) {
            return this.constrNames.get(original);
        }
        String name = constrName + this.seed++;
        this.constrNames.put(original, name);
        return name;
    }

    @Override
    public void visitProgram(Program toVisit) {
        for (Declaration decl : toVisit.getDeclarationList()) {
            decl.accept(this);
        }
    }

    @Override
    public void visitTypeDecl(TypeDecl toVisit) {
        toVisit.setName(this.newName(typeName));
        toVisit.getIs().accept(this);
    }

    @Override
    public void visitChannelDecl(ChannelDecl toVisit) {
        toVisit.setName(this.newName(channelName));
        toVisit.getIs().accept(this);
    }

    @Override
    public void visitConstantDecl(ConstantDecl toVisit) {
        toVisit.setName(this.newName(constantName));
        toVisit.getValue().accept(this);
    }

    @Override
    public void visitComponentDecl(ComponentDecl toVisit) {
        int i;
        toVisit.setName(this.newName(componentName));
        if (toVisit.getPortCount() > 0) {
            for (i = 0; i < toVisit.getPortCount(); ++i) {
                toVisit.getPort(i).accept(this);
            }
        }
        if (toVisit.getArgCount() > 0) {
            for (i = 0; i < toVisit.getArgCount(); ++i) {
                toVisit.getArg(i).accept(this);
            }
        }
        if (toVisit.getVarCount() > 0) {
            for (i = 0; i < toVisit.getVarCount(); ++i) {
                toVisit.getVar(i).accept(this);
            }
        }
        if (toVisit.getLocalPortCount() > 0) {
            for (i = 0; i < toVisit.getLocalPortCount(); ++i) {
                toVisit.getLocalPort(i).accept(this);
            }
        }
        if (toVisit.getInitAction() != null) {
            toVisit.getInitAction().accept(this);
        }
        toVisit.getBody().accept(this);
    }

    @Override
    public void visitProcessDecl(ProcessDecl toVisit) {
        int i;
        toVisit.setName(this.newName(processName));
        for (i = 0; i < toVisit.getPortCount(); ++i) {
            toVisit.getPort(i).accept(this);
        }
        for (i = 0; i < toVisit.getArgCount(); ++i) {
            toVisit.getArg(i).accept(this);
        }
        for (i = 0; i < toVisit.getStateCount(); ++i) {
            toVisit.getState(i).accept(this);
        }
        for (i = 0; i < toVisit.getVarCount(); ++i) {
            toVisit.getVar(i).accept(this);
        }
        if (toVisit.getInitAction() != null) {
            toVisit.getInitAction().accept(this);
        }
        for (i = 0; i < toVisit.getTransitionCount(); ++i) {
            toVisit.getTransition(i).accept(this);
        }
    }

    @Override
    public void visitLocalVariable(LocalVariable toVisit) {
        toVisit.setName(this.newName(variableName));
    }

    @Override
    public void visitArgumentVariable(ArgumentVariable toVisit) {
        toVisit.setName(this.newName(variableName));
    }

    @Override
    public void visitParamPortDecl(ParamPortDecl toVisit) {
        toVisit.setName(this.newName(portName));
        toVisit.getChannel().accept(this);
    }

    @Override
    public void visitLocalPortDecl(LocalPortDecl toVisit) {
        toVisit.setName(this.newName(portName));
        toVisit.getChannel().accept(this);
    }

    @Override
    public void visitState(State toVisit) {
        toVisit.setName(this.newName(stateName));
    }

    @Override
    public void visitPar(Par toVisit) {
        for (int i = 0; i < toVisit.getArgCount(); ++i) {
            toVisit.getArg(i).accept(this);
        }
    }

    @Override
    public void visitInstance(Instance toVisit) {
        if (toVisit.getArgCount() > 0) {
            for (int i = 0; i < toVisit.getArgCount(); ++i) {
                toVisit.getArg(i).accept(this);
            }
        }
    }

    @Override
    public void visitInterfacedComp(InterfacedComp toVisit) {
        toVisit.getComposition().accept(this);
    }

    @Override
    public void visitTransition(Transition toVisit) {
        toVisit.getAction().accept(this);
    }

    @Override
    public void visitNullStmt(NullStmt toVisit) {
    }

    @Override
    public void visitWhileStmt(WhileStmt toVisit) {
        toVisit.getCondition().accept(this);
        toVisit.getBody().accept(this);
    }

    @Override
    public void visitIfStmt(IfStmt toVisit) {
        toVisit.getCondition().accept(this);
        toVisit.getThen().accept(this);
        if (toVisit.getElse() != null) {
            toVisit.getElse().accept(this);
        }
    }

    @Override
    public void visitSelect(Select toVisit) {
        for (int i = 0; i < toVisit.getStatementCount(); ++i) {
            toVisit.getStatement(i).accept(this);
        }
    }

    @Override
    public void visitTo(To toVisit) {
    }

    @Override
    public void visitWait(Wait toVisit) {
    }

    @Override
    public void visitDeterministicAssignment(DeterministicAssignment toVisit) {
        for (int i = 0; i < toVisit.getAssignmentCount(); ++i) {
            toVisit.getAssignment(i).accept(this);
        }
    }

    @Override
    public void visitNonDeterministicAssignment(NonDeterministicAssignment toVisit) {
        for (int i = 0; i < toVisit.getLhsCount(); ++i) {
            toVisit.getLhs(i).accept(this);
        }
        if (toVisit.getCondition() != null) {
            toVisit.getCondition().accept(this);
        }
    }

    @Override
    public void visitSingleAssignment(SingleAssignment toVisit) {
        toVisit.getLhs().accept(this);
        toVisit.getRhs().accept(this);
    }

    @Override
    public void visitUnExp(UnExp toVisit) {
        toVisit.getExp().accept(this);
    }

    @Override
    public void visitBinExp(BinExp toVisit) {
        toVisit.getLeft().accept(this);
        toVisit.getRight().accept(this);
    }

    @Override
    public void visitNatLiteral(NatLiteral toVisit) {
    }

    @Override
    public void visitBoolLiteral(BoolLiteral toVisit) {
    }

    @Override
    public void visitVarRef(VarRef toVisit) {
    }

    @Override
    public void visitArrayElem(ArrayElem toVisit) {
        toVisit.getArray().accept(this);
        toVisit.getIndex().accept(this);
    }

    @Override
    public void visitRecordElem(RecordElem toVisit) {
        toVisit.getRecord().accept(this);
        toVisit.setField(this.fieldNames.get(toVisit.getField()));
    }

    @Override
    public void visitRecord(Record toVisit) {
        for (int i = 0; i < toVisit.getFieldCount(); ++i) {
            toVisit.getField(i).accept(this);
        }
    }

    @Override
    public void visitField(Field toVisit) {
        toVisit.getType().accept(this);
        toVisit.setName(this.newFieldName(toVisit.getName()));
    }

    @Override
    public void visitArray(Array toVisit) {
        toVisit.getSize().accept(this);
        toVisit.getType().accept(this);
    }

    @Override
    public void visitQueue(Queue toVisit) {
        toVisit.getSize().accept(this);
        toVisit.getType().accept(this);
    }

    @Override
    public void visitProfile(Profile toVisit) {
        for (int i = 0; i < toVisit.getTypeCount(); ++i) {
            toVisit.getType(i).accept(this);
        }
    }

    @Override
    public void visitInlineArray(InlineArray toVisit) {
        for (int i = 0; i < toVisit.getElemCount(); ++i) {
            toVisit.getElem(i).accept(this);
        }
    }

    @Override
    public void visitInlineRecord(InlineRecord toVisit) {
        for (int i = 0; i < toVisit.getValueCount(); ++i) {
            toVisit.getValue(i).accept(this);
        }
    }

    @Override
    public void visitValuedField(ValuedField toVisit) {
        toVisit.setField(this.fieldNames.get(toVisit.getField()));
        toVisit.getValue().accept(this);
    }

    @Override
    public void visitReception(Reception toVisit) {
        for (int i = 0; i < toVisit.getPatternCount(); ++i) {
            toVisit.getPattern(i).accept(this);
        }
        if (toVisit.getWhere() != null) {
            toVisit.getWhere().accept(this);
        }
    }

    @Override
    public void visitEmission(Emission toVisit) {
        for (int i = 0; i < toVisit.getArgCount(); ++i) {
            toVisit.getArg(i).accept(this);
        }
    }

    @Override
    public void visitSeq(Seq toVisit) {
        for (int i = 0; i < toVisit.getStatementCount(); ++i) {
            toVisit.getStatement(i).accept(this);
        }
    }

    @Override
    public void visitConstrExp(ConstrExp toVisit) {
        toVisit.setName(this.constrNames.get(toVisit.getName()));
        if (toVisit.getArg() != null) {
            toVisit.getArg().accept(this);
        }
    }

    @Override
    public void visitUnion(Union toVisit) {
        for (int i = 0; i < toVisit.getConstrCount(); ++i) {
            toVisit.getConstr(i).accept(this);
        }
    }

    @Override
    public void visitConstrPattern(ConstrPattern toVisit) {
        toVisit.setName(this.constrNames.get(toVisit.getName()));
        if (toVisit.getArg() != null) {
            toVisit.getArg().accept(this);
        }
    }

    @Override
    public void visitArrayPattern(ArrayPattern toVisit) {
        toVisit.getArray().accept(this);
        toVisit.getIndex().accept(this);
    }

    @Override
    public void visitFieldPattern(FieldPattern toVisit) {
        toVisit.setField(this.fieldNames.get(toVisit.getField()));
        toVisit.getRecord().accept(this);
    }

    @Override
    public void visitCaseStmt(CaseStmt toVisit) {
        toVisit.getExp().accept(this);
        for (int i = 0; i < toVisit.getRuleCount(); ++i) {
            toVisit.getRule(i).accept(this);
        }
    }

    @Override
    public void visitRule(Rule toVisit) {
        toVisit.getLhs().accept(this);
        toVisit.getAction().accept(this);
    }

    @Override
    public void visitConstr(Constr toVisit) {
        toVisit.setName(this.newConstrName(toVisit.getName()));
        if (toVisit.getType() != null) {
            toVisit.getType().accept(this);
        }
    }

    @Override
    public void visitCondExp(CondExp toVisit) {
        toVisit.getCond().accept(this);
        toVisit.getIft().accept(this);
        toVisit.getIff().accept(this);
    }

    @Override
    public void visitForeach(Foreach toVisit) {
        toVisit.getBody().accept(this);
    }
}

