/*
 * Decompiled with CFR 0.152.
 */
package obp.fiacre.ffi;

import c.model.ArrayType;
import c.model.BooleanType;
import c.model.IntegerLiteral;
import c.model.IntegerType;
import c.model.ModelFactory;
import c.model.StructureType;
import c.model.Type;
import c.model.TypeDeclaration;
import c.model.TypefDeclaration;
import java.math.BigInteger;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Stack;
import obp.fiacre.model.Array;
import obp.fiacre.model.ArrayedType;
import obp.fiacre.model.BoolType;
import obp.fiacre.model.ExternalArgument;
import obp.fiacre.model.ExternalFunctionDecl;
import obp.fiacre.model.Field;
import obp.fiacre.model.IntType;
import obp.fiacre.model.Interval;
import obp.fiacre.model.ModelVisitor;
import obp.fiacre.model.NatLiteral;
import obp.fiacre.model.NatType;
import obp.fiacre.model.Queue;
import obp.fiacre.model.Record;
import obp.fiacre.model.TypeDecl;
import obp.fiacre.model.TypeId;
import obp.fiacre.model.Union;
import obp.fiacre.transfo.FiacreStaticEvaluator;

public class ExtractCTypes {
    int uid = 0;
    final ModelFactory cFactory = ModelFactory.eINSTANCE;
    Map<Object, Type> resultTypeMap = new LinkedHashMap<Object, Type>();
    public LinkedHashSet<TypeDeclaration> typeDeclarations = new LinkedHashSet();
    FiacreStaticEvaluator fEval = new FiacreStaticEvaluator();
    ModelVisitor extractor = new ModelVisitor.Stub(){
        Stack<TypeDeclaration> typeDeclContext = new Stack();
        Map<Object, Type> typeMap = new LinkedHashMap<Object, Type>();

        @Override
        public void visitBoolType(BoolType toVisit) {
            Type type = this.typeMap.get(toVisit);
            if (type != null) {
                return;
            }
            BooleanType boolT = ExtractCTypes.this.cFactory.createBooleanType();
            this.typeMap.put(toVisit, boolT);
            ExtractCTypes.this.resultTypeMap.put(toVisit, boolT);
        }

        @Override
        public void visitIntType(IntType toVisit) {
            Type type = this.typeMap.get(toVisit);
            if (type != null) {
                return;
            }
            IntegerType intT = ExtractCTypes.this.cFactory.createIntegerType();
            this.typeMap.put(toVisit, intT);
            ExtractCTypes.this.resultTypeMap.put(toVisit, intT);
        }

        @Override
        public void visitNatType(NatType toVisit) {
            Type type = this.typeMap.get(toVisit);
            if (type != null) {
                return;
            }
            IntegerType intT = ExtractCTypes.this.cFactory.createIntegerType();
            this.typeMap.put(toVisit, intT);
            ExtractCTypes.this.resultTypeMap.put(toVisit, intT);
        }

        @Override
        public void visitInterval(Interval toVisit) {
            Type type = this.typeMap.get(toVisit);
            if (type != null) {
                return;
            }
            IntegerType intT = ExtractCTypes.this.cFactory.createIntegerType();
            this.typeMap.put(toVisit, intT);
            ExtractCTypes.this.resultTypeMap.put(toVisit, intT);
        }

        @Override
        public void visitRecord(Record toVisit) {
            Type type = this.typeMap.get(toVisit);
            if (type != null) {
                return;
            }
            StructureType struct = ExtractCTypes.this.cFactory.createStructureType();
            Map<String, c.model.Field> cFields = struct.getFields();
            int i = 0;
            for (Field field : toVisit.getFieldList()) {
                c.model.Field cFi = ExtractCTypes.this.cFactory.createField();
                cFi.setName(field.getName());
                field.getType().accept(this);
                cFi.setType(this.typeMap.get(field.getType()));
                cFi.setPosition(BigInteger.valueOf(i));
                ++i;
                cFields.put(cFi.getName(), cFi);
            }
            this.typeMap.put(toVisit, struct);
            ExtractCTypes.this.resultTypeMap.put(toVisit, this.typeDeclContext.peek());
        }

        private void visitArrayedType(ArrayedType toVisit) {
            Type type = this.typeMap.get(toVisit);
            if (type != null) {
                return;
            }
            ArrayType array = ExtractCTypes.this.cFactory.createArrayType();
            toVisit.getType().accept(this);
            array.setElementType(this.typeMap.get(toVisit.getType()));
            int size = ((NatLiteral)ExtractCTypes.this.fEval.eval(toVisit.getSize())).getValue();
            IntegerLiteral sizeLiteral = ExtractCTypes.this.cFactory.createIntegerLiteral();
            sizeLiteral.setValue(BigInteger.valueOf(size));
            array.setSize(sizeLiteral);
            this.typeMap.put(toVisit, array);
            ExtractCTypes.this.resultTypeMap.put(toVisit, this.typeDeclContext.peek());
        }

        @Override
        public void visitArray(Array toVisit) {
            this.visitArrayedType(toVisit);
        }

        @Override
        public void visitQueue(Queue toVisit) {
            this.visitArrayedType(toVisit);
        }

        @Override
        public void visitUnion(Union toVisit) {
            System.err.println("FFI Bindings do not support unions for now");
        }

        @Override
        public void visitTypeId(TypeId toVisit) {
            Type type = this.typeMap.get(toVisit);
            if (type != null) {
                return;
            }
            toVisit.getDecl().accept(this);
            this.typeMap.put(toVisit, this.typeMap.get(toVisit.getDecl()));
            ExtractCTypes.this.resultTypeMap.put(toVisit, this.typeMap.get(toVisit.getDecl()));
        }

        @Override
        public void visitTypeDecl(TypeDecl toVisit) {
            Type type = this.typeMap.get(toVisit);
            if (type != null) {
                return;
            }
            TypefDeclaration tDecl = ExtractCTypes.this.cFactory.createTypefDeclaration();
            tDecl.setName(toVisit.getName());
            this.typeDeclContext.push(tDecl);
            toVisit.getIs().accept(this);
            this.typeDeclContext.pop();
            tDecl.setType(this.typeMap.get(toVisit.getIs()));
            this.typeMap.put(toVisit, tDecl);
            ExtractCTypes.this.typeDeclarations.add(tDecl);
        }
    };

    public Map<Object, Type> extractTypes(ExternalFunctionDecl fct, int idx) {
        this.uid = idx;
        fct.getReturnType().accept(this.extractor);
        for (ExternalArgument eArg : fct.getArgList()) {
            eArg.getType().accept(this.extractor);
        }
        return this.resultTypeMap;
    }

    public Map<Object, Type> extractTypes(TypeDecl td, int idx) {
        this.uid = idx;
        td.accept(this.extractor);
        return this.resultTypeMap;
    }
}

