/*
 * Decompiled with CFR 0.152.
 */
package obp.explorer;

import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.List;
import obp.explorer.ExplorerResult;
import obp.result.ExplorationResultInfo;

public class ExplorerResultUtil {
    protected static final NumberFormat integerFormat = DecimalFormat.getIntegerInstance();
    protected static final NumberFormat decimalFormat = DecimalFormat.getNumberInstance();

    public static String toDescription(String header, List<ExplorerResult> explorerResults) {
        if (explorerResults == null || explorerResults.isEmpty()) {
            return null;
        }
        if (explorerResults.size() == 1) {
            StringBuilder description = new StringBuilder();
            description.append(header);
            description.append("\n");
            description.append(explorerResults.get(0).toString());
            return description.toString();
        }
        BigInteger stateCountAll = BigInteger.ZERO;
        BigInteger transitionCountAll = BigInteger.ZERO;
        double durationAll = 0.0;
        BigInteger stateCountEfficient = BigInteger.ZERO;
        BigInteger transitionCountEfficient = BigInteger.ZERO;
        double durationEfficient = 0.0;
        String[] observerDescriptions = explorerResults.get(0).getObserverDescriptions();
        int observersCount = observerDescriptions == null ? 0 : observerDescriptions.length;
        String[] observersInReject = new String[observersCount];
        String[] observersInSuccess = new String[observersCount];
        boolean[] observersMovement = new boolean[observersCount];
        String[] assertDescriptions = explorerResults.get(0).getAssertDescriptions();
        int assertsCount = assertDescriptions == null ? 0 : assertDescriptions.length;
        String[] assertsDefect = new String[assertsCount];
        long efficient = 0L;
        for (ExplorerResult result : explorerResults) {
            if (result.getConfigurationCount() != null) {
                stateCountAll = stateCountAll.add(result.getConfigurationCount());
            }
            if (result.getActionCount() != null) {
                transitionCountAll = transitionCountAll.add(result.getActionCount());
            }
            durationAll += result.getDuration();
            if (result.isComplete()) {
                ++efficient;
                if (result.getConfigurationCount() != null) {
                    stateCountEfficient = stateCountEfficient.add(result.getConfigurationCount());
                }
                if (result.getActionCount() != null) {
                    transitionCountEfficient = transitionCountEfficient.add(result.getActionCount());
                }
                durationEfficient += result.getDuration();
            }
            if (observersCount > 0) {
                int[] localObserversInReject = result.getObserverRejectReachedFirstConfiguration();
                int[] localObserversInSuccess = result.getObserverSuccessReachedFirstConfiguration();
                boolean[] localObserversMovement = result.getObserverMovement();
                for (int i = 0; i < observersCount; ++i) {
                    if (observersInReject[i] == null && localObserversInReject[i] >= 0) {
                        observersInReject[i] = result.getContext().getName();
                    }
                    if (observersInSuccess[i] == null && localObserversInSuccess[i] >= 0) {
                        observersInSuccess[i] = result.getContext().getName();
                    }
                    int n = i;
                    observersMovement[n] = observersMovement[n] | localObserversMovement[i];
                }
            }
            if (assertsCount <= 0) continue;
            int[] localAssertsDefect = result.getAssertsViolatedFirstConfiguration();
            for (int i = 0; i < assertsCount; ++i) {
                if (assertsDefect[i] != null || localAssertsDefect[i] < 0) continue;
                assertsDefect[i] = result.getContext().getName();
            }
        }
        StringBuilder description = new StringBuilder();
        description.append(header);
        description.append("\n");
        description.append("--------------------Synthesis---------------------");
        description.append("\n");
        description.append("-> With split contexts:\n");
        description.append("Explored ");
        description.append(integerFormat.format(stateCountAll));
        description.append(" states and ");
        description.append(integerFormat.format(transitionCountAll));
        description.append(" transitions in ");
        description.append(decimalFormat.format(durationAll));
        description.append(" seconds.");
        description.append("\n\n");
        description.append("-> Only efficient contexts:\n");
        description.append("Explored ");
        description.append(integerFormat.format(stateCountEfficient));
        description.append(" states and ");
        description.append(integerFormat.format(transitionCountEfficient));
        description.append(" transitions in ");
        description.append(decimalFormat.format(durationEfficient));
        description.append(" seconds.");
        description.append("\n\n");
        description.append("Total number of contexts: ");
        description.append(integerFormat.format(explorerResults.size()));
        description.append("\n");
        description.append("Number of efficient contexts: ");
        description.append(integerFormat.format(efficient));
        description.append("\n");
        description.append("Number of split contexts: ");
        description.append(integerFormat.format((long)explorerResults.size() - efficient));
        description.append(".");
        description.append("\n");
        description.append("\n");
        description.append("--------------------Verification---------------------");
        description.append("\n");
        if (observersCount > 0) {
            int i;
            boolean oneRejectReached = false;
            boolean oneSuccessReached = false;
            for (i = 0; i < observersCount; ++i) {
                oneRejectReached |= observersInReject[i] != null;
                oneSuccessReached |= observersInSuccess[i] != null;
            }
            if (oneRejectReached || oneSuccessReached) {
                description.append("Properties:\n");
                for (i = 0; i < observersCount; ++i) {
                    if (observersInReject[i] == null && observersInSuccess[i] == null) continue;
                    description.append("-'");
                    description.append(observerDescriptions[i]);
                    description.append("': ");
                    int length = description.length();
                    if (observersInReject[i] != null) {
                        description.append(" reached reject the first time in context '");
                        description.append(observersInReject[i]);
                        description.append("'");
                    }
                    if (observersInSuccess[i] != null) {
                        if (length < description.length()) {
                            description.append(" and");
                        }
                        description.append(" reached success the first time in context '");
                        description.append(observersInSuccess[i]);
                        description.append("'");
                    }
                    description.append(".\n");
                }
                description.append("\n");
            }
        }
        if (assertsCount > 0) {
            int i;
            boolean oneViolated = false;
            for (i = 0; i < assertsCount; ++i) {
                oneViolated |= assertsDefect[i] != null;
            }
            if (oneViolated) {
                description.append("Violated asserts:\n");
                for (i = 0; i < assertsCount; ++i) {
                    if (assertsDefect[i] == null) continue;
                    StringBuilder message = new StringBuilder();
                    message.append("- '");
                    message.append(assertDescriptions[i]);
                    message.append("' the first time in context '");
                    message.append(assertsDefect[i]);
                    message.append("'.\n");
                    description.append((CharSequence)message);
                }
            } else {
                description.append("No assert violated.\n");
            }
            description.append("\n");
        }
        description.append("--------------------Contexts---------------------");
        description.append("\n");
        for (int i = 0; i < explorerResults.size(); ++i) {
            ExplorationResultInfo result = explorerResults.get(i);
            description.append("- ");
            if (!result.isComplete()) {
                description.append("[split] ");
            }
            description.append(result.getContext().getName());
            description.append("(");
            description.append(integerFormat.format(result.getContext().getStateCount()));
            description.append(" states and ");
            description.append(integerFormat.format(result.getContext().getTransitionCount()));
            description.append(" transitions) Explored in ");
            description.append(decimalFormat.format(result.getDuration()));
            description.append(" seconds: ");
            if (result.getConfigurationCount() != null) {
                description.append(integerFormat.format(result.getConfigurationCount()));
            } else {
                description.append("??");
            }
            description.append(" states and ");
            if (result.getActionCount() != null) {
                description.append(integerFormat.format(result.getActionCount()));
            } else {
                description.append("??");
            }
            description.append(" transitions.\n");
        }
        return description.toString();
    }
}

