/*
 * Decompiled with CFR 0.152.
 */
package obp.ui.dot.diagram;

import java.io.File;
import java.util.List;
import obp.dot.Edge;
import obp.dot.Graph;
import obp.dot.Node;
import obp.dot.util.DotUtil;
import obp.ui.dot.diagram.EdgeElement;
import obp.ui.dot.diagram.NodeElement;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.xid.basics.progress.ActionMonitor;
import org.xid.basics.ui.action.Action;
import org.xid.basics.ui.diagram.Diagram;
import org.xid.basics.ui.diagram.DiagramContext;
import org.xid.basics.ui.diagram.DiagramUtils;
import org.xid.basics.ui.diagram.Element;
import org.xid.basics.ui.dialog.FieldDialog;
import org.xid.basics.ui.field.DiagramField;
import org.xid.basics.ui.field.Field;

public class GraphDiagram
extends Diagram<Graph> {
    public static final RGB defaultBackGroundRgb = new RGB(255, 251, 246);

    public GraphDiagram() {
    }

    public GraphDiagram(Graph aut) {
        this.setModel(this.model);
    }

    public void build() {
        this.clearElements();
        if (this.model != null) {
            for (Node node : ((Graph)this.model).getNodeList()) {
                this.addElement(new NodeElement(node));
            }
            for (Edge edge : ((Graph)this.model).getEdgeList()) {
                this.addElement((Element)new EdgeElement(edge));
            }
        }
        this.invalidateBounds();
    }

    public void computeActions(List<Action> result, final DiagramContext context) {
        result.add((Action)new Action.Stub("Export to PNG\u2026", 8){

            public int run(ActionMonitor monitor) {
                FileDialog dialog = new FileDialog(context.getControl().getShell(), 8192);
                dialog.setFilterExtensions(new String[]{"*.png"});
                dialog.setFilterNames(new String[]{"PNG image"});
                String filename = dialog.open();
                if (filename == null) {
                    return 2;
                }
                if (!filename.endsWith(".png")) {
                    filename = filename + ".png";
                }
                DiagramUtils.exportToImage((Diagram)GraphDiagram.this, (String)filename, (float)1.0f, (int)5);
                return 1;
            }
        });
    }

    public static void main(String[] args) throws Exception {
        FileDialog fileDialog = new FileDialog(new Shell(), 4096);
        fileDialog.setFilterExtensions(new String[]{"*.dot"});
        fileDialog.setFilterNames(new String[]{"DOT file"});
        String filename = fileDialog.open();
        if (filename == null) {
            return;
        }
        Graph graph = DotUtil.loadDot(new File(filename));
        DiagramField diagramField = new DiagramField((Diagram)new GraphDiagram());
        diagramField.setValue((Object)graph);
        FieldDialog dialog = new FieldDialog("Dot", "", 0, (Field)diagramField);
        dialog.open();
    }
}

