/*
 * Decompiled with CFR 0.152.
 */
package obp.fiacre.ffi.try2;

import c.builder.CBuilder;
import c.model.ArrayType;
import c.model.AssignmentStmt;
import c.model.BinaryExpression;
import c.model.CastExpression;
import c.model.Expression;
import c.model.ExternalType;
import c.model.ForStmt;
import c.model.FunctionCall;
import c.model.Statement;
import c.model.StatementGroup;
import c.model.StructureDereference;
import c.model.Type;
import c.model.UnaryExpression;
import c.model.VariableDeclaration;
import c.model.VariableReference;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import obp.explorer.runtime.util.NameUtil;
import obp.fiacre.ffi.try2.FFIBindingGenerator;
import obp.fiacre.model.Array;
import obp.fiacre.model.ArrayedType;
import obp.fiacre.model.BoolType;
import obp.fiacre.model.Field;
import obp.fiacre.model.IntType;
import obp.fiacre.model.Interval;
import obp.fiacre.model.ModelVisitor;
import obp.fiacre.model.NatLiteral;
import obp.fiacre.model.NatType;
import obp.fiacre.model.Queue;
import obp.fiacre.model.Record;
import obp.fiacre.model.TypeDecl;
import obp.fiacre.model.TypeId;
import obp.fiacre.model.Union;
import obp.fiacre.transfo.FiacreStaticEvaluator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

class TFiacre2CMarshaller
extends ModelVisitor.Stub {
    FFIBindingGenerator client;
    CBuilder cB;
    StatementGroup marshallStmts;
    Stack<Object> fcrContext = new Stack();
    Stack<VariableDeclaration> jniObjectContext = new Stack();
    Stack<VariableDeclaration> jniClassContext = new Stack();
    Stack<VariableDeclaration> jniFieldIdContext = new Stack();
    Stack<Integer> jniIndexContext = new Stack();
    Stack<Integer> arraySizeContext = new Stack();
    Map<Object, VariableDeclaration> valueMap = new HashMap<Object, VariableDeclaration>();
    Map<Object, VariableDeclaration> objectMap = new HashMap<Object, VariableDeclaration>();
    Map<Object, VariableDeclaration> indexMap = new HashMap<Object, VariableDeclaration>();
    Map<Object, String> jniTypeSignature = new HashMap<Object, String>();
    private Object root;
    Stack<StatementGroup> marshallStack = new Stack();

    public TFiacre2CMarshaller(Object root, FFIBindingGenerator ffiBindingGenerator, StatementGroup marshallStmts) {
        this.client = ffiBindingGenerator;
        this.root = root;
        this.marshallStmts = marshallStmts;
        this.cB = ffiBindingGenerator.cBuilder;
    }

    private String newName() {
        return "tmp" + this.client.currentIdx++;
    }

    FunctionCall createJniCall(String memberName) {
        UnaryExpression envP = this.cB.dereference(this.client.referenceTo("env", this.marshallStmts));
        StructureDereference fctMember = this.cB.dereference(envP, memberName);
        FunctionCall fCall = this.cB.functionCall(fctMember);
        fCall.getArguments().add(this.client.referenceTo("env", this.marshallStmts));
        return fCall;
    }

    void addTo(Statement stmt, StatementGroup group) {
        group.getStatements().add(stmt);
    }

    void marshallAdd(Statement stmt) {
        this.addTo(stmt, this.marshallStmts);
    }

    private void marshallPrimitiveType(obp.fiacre.model.Type toVisit, String typeName) {
        VariableDeclaration var = this.cB.variable(this.newName());
        String TypeName = typeName.substring(0, 1).toUpperCase() + typeName.substring(1);
        ExternalType baseType = this.cB.externalType("j" + typeName);
        if (this.inArrayContext() != null) {
            var.setType(this.cB.pointerType(baseType));
            FunctionCall fCall = this.createJniCall("Get" + TypeName + "ArrayElements");
            VariableReference vRef = this.cB.reference(this.jniObjectContext.peek());
            UnaryExpression dRef = this.cB.address(vRef);
            CastExpression cExp = this.cB.cast(this.cB.pointerType(this.cB.externalType("j" + typeName + "Array")), dRef);
            UnaryExpression dRefArray = this.cB.dereference(cExp);
            fCall.getArguments().add(dRefArray);
            fCall.getArguments().add(this.cB.nullLiteral());
            VariableDeclaration javaVar = this.cB.variable("java" + var.getName(), this.cB.pointerType(baseType), fCall);
            this.marshallAdd(javaVar);
            BinaryExpression sizeExp = this.cB.mult(this.cB.literal(this.arraySizeContext.peek()), this.cB.sizeOf(baseType));
            FunctionCall malloc = this.cB.functionCall("malloc");
            malloc.getArguments().add(sizeExp);
            var.setInitialValue(malloc);
            this.marshallAdd(var);
            FunctionCall memcpy = this.cB.functionCall("memcpy");
            memcpy.getArguments().add(this.cB.reference(var));
            memcpy.getArguments().add(this.cB.reference(javaVar));
            memcpy.getArguments().add((Expression)EcoreUtil.copy((EObject)sizeExp));
            this.marshallAdd(memcpy);
            FunctionCall releaseArrayCall = this.createJniCall("Release" + TypeName + "ArrayElements");
            releaseArrayCall.getArguments().add((Expression)EcoreUtil.copy((EObject)dRefArray));
            releaseArrayCall.getArguments().add(this.cB.reference(javaVar));
            releaseArrayCall.getArguments().add(this.cB.literal(0));
            this.marshallAdd(releaseArrayCall);
        } else {
            var.setType(baseType);
            FunctionCall fCall = this.createJniCall("Get" + TypeName + "Field");
            var.setInitialValue(fCall);
            fCall.getArguments().add(this.cB.reference(this.jniObjectContext.peek()));
            fCall.getArguments().add(this.cB.reference(this.jniFieldIdContext.peek()));
            this.marshallStmts.getStatements().add(var);
        }
        this.valueMap.put(toVisit, var);
        this.jniTypeSignature.put(toVisit, typeName.equals("boolean") ? "Z" : "I");
    }

    @Override
    public void visitBoolType(BoolType toVisit) {
        this.marshallPrimitiveType(toVisit, "boolean");
    }

    private void marshalInt(obp.fiacre.model.Type toVisit) {
        this.marshallPrimitiveType(toVisit, "int");
    }

    @Override
    public void visitIntType(IntType toVisit) {
        this.marshalInt(toVisit);
    }

    @Override
    public void visitNatType(NatType toVisit) {
        this.marshalInt(toVisit);
    }

    @Override
    public void visitInterval(Interval toVisit) {
        this.marshalInt(toVisit);
    }

    @Override
    public void visitField(Field toVisit) {
        FunctionCall gfiCall = this.createJniCall("GetFieldID");
        VariableDeclaration fidxVar = this.cB.variable(this.jniObjectContext.peek().getName() + this.jniIndexContext.peek(), this.cB.externalType("jfieldID"), gfiCall);
        gfiCall.getArguments().add(this.cB.reference(this.jniClassContext.peek()));
        gfiCall.getArguments().add(this.cB.literal(toVisit.getName()));
        this.marshallStmts.getStatements().add(fidxVar);
        this.jniFieldIdContext.push(fidxVar);
        toVisit.getType().accept(this);
        this.jniFieldIdContext.pop();
        gfiCall.getArguments().add(this.cB.literal(this.jniTypeSignature.get(toVisit.getType())));
        this.valueMap.put(toVisit, this.valueMap.get(toVisit.getType()));
        this.indexMap.put(toVisit, fidxVar);
    }

    @Override
    public void visitRecord(Record toVisit) {
        String myName = this.newName();
        VariableDeclaration objVar = this.cB.variable(myName + "_o", this.cB.externalType("jobject"));
        if (this.root != null && this.root != toVisit) {
            FunctionCall fCall = null;
            fCall = this.inArrayContext() == null ? this.createJniCall("GetObjectField") : this.createJniCall("GetObjectArrayElement");
            objVar.setInitialValue(fCall);
            fCall.getArguments().add(this.cB.reference(this.jniObjectContext.peek()));
            fCall.getArguments().add(this.cB.reference(this.jniFieldIdContext.peek()));
        } else {
            objVar.setInitialValue(this.client.referenceTo("obj", this.marshallStmts));
        }
        this.marshallStmts.getStatements().add(objVar);
        FunctionCall gocCall = this.createJniCall("GetObjectClass");
        VariableDeclaration classVar = this.cB.variable(myName + "_t", this.cB.externalType("jclass"), gocCall);
        gocCall.getArguments().add(this.cB.reference(objVar));
        this.marshallStmts.getStatements().add(classVar);
        String basePackage = this.client.caller.basePackage == null ? "" : this.client.caller.basePackage.replaceAll("\\.", "/") + "/";
        String typeName = NameUtil.capName(((TypeDecl)this.fcrContext.peek()).getName());
        this.jniTypeSignature.put(toVisit, "L" + basePackage + this.client.caller.packageName + "/" + typeName + ";");
        this.fcrContext.push(toVisit);
        this.jniObjectContext.push(objVar);
        this.jniClassContext.push(classVar);
        int fieldIdx = 0;
        for (Field field : toVisit.getFieldList()) {
            this.jniIndexContext.push(fieldIdx);
            field.accept(this);
            this.jniIndexContext.pop();
            ++fieldIdx;
        }
        this.fcrContext.pop();
        this.jniObjectContext.pop();
        this.jniClassContext.pop();
        if (this.root != null && this.root != toVisit) {
            VariableDeclaration rVar = this.cB.variable(myName, this.client.typeMap.get(toVisit));
            this.marshallStmts.getStatements().add(rVar);
            for (Field field : toVisit.getFieldList()) {
                this.marshallStmts.getStatements().add(this.cB.assign(this.cB.reference(this.cB.reference(rVar), field.getName()), this.cB.reference(this.valueMap.get(field))));
            }
            this.valueMap.put(toVisit, rVar);
        }
        this.objectMap.put(toVisit, objVar);
    }

    private void marshalArrayedType(ArrayedType toVisit) {
        this.client.hasArray = true;
        String myName = this.newName();
        FunctionCall gofCall = null;
        gofCall = this.inArrayContext() == null ? this.createJniCall("GetObjectField") : this.createJniCall("GetObjectArrayElement");
        VariableDeclaration objVar = this.cB.variable(myName + "_o", this.cB.externalType("jobject"), gofCall);
        gofCall.getComment().add("in array");
        gofCall.getArguments().add(this.cB.reference(this.jniObjectContext.peek()));
        gofCall.getArguments().add(this.cB.reference(this.jniFieldIdContext.peek()));
        this.marshallStmts.getStatements().add(objVar);
        int sizeArray = ((NatLiteral)FiacreStaticEvaluator.evaluate(toVisit.getSize())).getValue();
        this.arraySizeContext.push(sizeArray);
        if (!this.isPrimitiveType(toVisit.getType())) {
            FunctionCall malloc = this.cB.functionCall("malloc");
            malloc.getArguments().add(this.cB.mult(this.cB.literal(sizeArray), this.cB.sizeOf(this.cB.voidPointerType())));
            VariableDeclaration valueHolder = this.cB.variable(myName + "_cvalue", this.getCType(toVisit, this.client.typeMap), malloc);
            this.marshallStmts.getStatements().add(valueHolder);
            VariableDeclaration sizeA = this.cB.variable(myName + "_size", this.cB.integerType(), this.cB.literal(sizeArray));
            this.marshallStmts.getStatements().add(sizeA);
            VariableDeclaration fID = this.cB.variable(myName + "_idx", this.cB.integerType(), this.cB.literal(0));
            ForStmt forS = this.cB.forStmt(fID, this.cB.lt(this.cB.reference(fID), this.cB.reference(sizeA)), this.cB.assign(this.cB.reference(fID), this.cB.inc(this.cB.reference(fID))));
            this.marshallStack.push(this.marshallStmts);
            this.marshallStmts = this.cB.statementGroup(this.marshallStack.peek().getOwner());
            forS.getBody().add(this.marshallStmts);
            this.jniFieldIdContext.push(fID);
            this.fcrContext.push(toVisit);
            this.jniObjectContext.push(objVar);
            toVisit.getType().accept(this);
            this.jniFieldIdContext.pop();
            VariableReference vRef = this.cB.reference(valueHolder);
            AssignmentStmt idAssign = this.cB.assign(this.cB.indexed(vRef, this.cB.reference(fID)), this.cB.reference(this.valueMap.get(toVisit.getType())));
            this.marshallStmts.getStatements().add(idAssign);
            this.valueMap.put(toVisit, valueHolder);
            this.marshallStmts = this.marshallStack.pop();
            this.marshallStmts.getStatements().add(forS);
        } else {
            this.fcrContext.push(toVisit);
            this.jniObjectContext.push(objVar);
            toVisit.getType().accept(this);
            this.valueMap.put(toVisit, this.valueMap.get(toVisit.getType()));
        }
        this.arraySizeContext.pop();
        this.fcrContext.pop();
        this.jniObjectContext.pop();
        this.jniTypeSignature.put(toVisit, "[" + this.jniTypeSignature.get(toVisit.getType()));
    }

    @Override
    public void visitArray(Array toVisit) {
        this.marshalArrayedType(toVisit);
    }

    @Override
    public void visitUnion(Union toVisit) {
    }

    @Override
    public void visitQueue(Queue toVisit) {
        this.marshalArrayedType(toVisit);
    }

    @Override
    public void visitTypeId(TypeId toVisit) {
        this.fcrContext.push(toVisit);
        toVisit.getDecl().accept(this);
        this.jniTypeSignature.put(toVisit, this.jniTypeSignature.get(toVisit.getDecl()));
        this.fcrContext.pop();
        this.valueMap.put(toVisit, this.valueMap.get(toVisit.getDecl()));
        this.objectMap.put(toVisit, this.objectMap.get(toVisit.getDecl()));
    }

    @Override
    public void visitTypeDecl(TypeDecl toVisit) {
        this.fcrContext.push(toVisit);
        if (this.root == toVisit) {
            this.root = toVisit.getIs();
        }
        toVisit.getIs().accept(this);
        this.jniTypeSignature.put(toVisit, this.jniTypeSignature.get(toVisit.getIs()));
        this.fcrContext.pop();
        this.valueMap.put(toVisit, this.valueMap.get(toVisit.getIs()));
        this.objectMap.put(toVisit, this.objectMap.get(toVisit.getIs()));
    }

    public ArrayedType inArrayContext() {
        if (this.fcrContext.size() < 1) {
            return null;
        }
        if (this.fcrContext.peek() instanceof ArrayedType) {
            return (ArrayedType)this.fcrContext.peek();
        }
        if (this.fcrContext.size() < 3) {
            return null;
        }
        if (this.fcrContext.peek() instanceof TypeDecl && this.fcrContext.get(this.fcrContext.size() - 3) instanceof ArrayedType) {
            return (ArrayedType)this.fcrContext.get(this.fcrContext.size() - 3);
        }
        return null;
    }

    public boolean isPrimitiveType(obp.fiacre.model.Type type) {
        if (type instanceof BoolType || type instanceof IntType || type instanceof NatType || type instanceof Interval) {
            return true;
        }
        if (type instanceof TypeId) {
            return this.isPrimitiveType(((TypeId)type).getDecl().getIs());
        }
        return false;
    }

    public Type getCType(obp.fiacre.model.Type type, Map<Object, Type> typeMap) {
        if (type instanceof BoolType) {
            return this.cB.booleanType();
        }
        if (type instanceof IntType || type instanceof NatType || type instanceof Interval) {
            return this.cB.integerType();
        }
        if (type instanceof ArrayedType) {
            ArrayType arr = this.cB.arrayType(this.getCType(((ArrayedType)type).getType(), typeMap));
            return arr;
        }
        if (type instanceof TypeId) {
            return this.getCType(((TypeId)type).getDecl().getIs(), typeMap);
        }
        if (type instanceof Union) {
            return null;
        }
        return this.client.typeMap.get(type);
    }

    public Type getCArrayElementType(obp.fiacre.model.Type type, Map<Object, Type> typeMap) {
        if (type instanceof BoolType) {
            return this.cB.booleanType();
        }
        if (type instanceof IntType || type instanceof NatType || type instanceof Interval) {
            return this.cB.integerType();
        }
        if (type instanceof ArrayedType) {
            return this.getCArrayElementType(((ArrayedType)type).getType(), typeMap);
        }
        if (type instanceof TypeId) {
            return this.getCArrayElementType(((TypeId)type).getDecl().getIs(), typeMap);
        }
        if (type instanceof Union) {
            return null;
        }
        return this.client.typeMap.get(type);
    }

    public Expression getCArraySize(obp.fiacre.model.Type type, Map<Object, Type> typeMap, boolean fullSize) {
        if (type instanceof BoolType) {
            return this.cB.sizeOf(this.cB.booleanType());
        }
        if (type instanceof IntType || type instanceof NatType || type instanceof Interval) {
            return this.cB.sizeOf(this.cB.integerType());
        }
        if (type instanceof ArrayedType) {
            if (!fullSize && this.isPrimitiveType(((ArrayedType)type).getType())) {
                return this.cB.sizeOf(this.cB.voidPointerType());
            }
            return this.cB.mult(this.cB.literal(((NatLiteral)FiacreStaticEvaluator.evaluate(((ArrayedType)type).getSize())).getValue()), this.getCArraySize(((ArrayedType)type).getType(), typeMap, fullSize));
        }
        if (type instanceof TypeId) {
            return this.getCArraySize(((TypeId)type).getDecl().getIs(), typeMap, fullSize);
        }
        if (type instanceof Union) {
            return null;
        }
        return this.cB.sizeOf(this.client.typeMap.get(type));
    }
}

