/*
 * Decompiled with CFR 0.152.
 */
package obp.ui.tina;

import java.io.File;
import java.math.BigInteger;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import obp.cc.ConcreteContext;
import obp.cdl.CDLDeclaration;
import obp.cdl.CDLUnit;
import obp.fiacre.model.Program;
import obp.fiacre.transfo.FiacreScrambler;
import obp.fiacre.transfo.FiacreTransitionLabeller;
import obp.fiacre.util.FiacrePrinter;
import obp.fiacre.util.FiacreUtil;
import obp.result.ExplorationResultInfo;
import obp.tina.SeltResult;
import obp.tina.TinaController;
import obp.transfo.cdl.CDLToConcreteContext;
import obp.ui.tina.OBPt;
import obp.util.CDLUtil;
import obp.util.ConcreteContextUtil;
import obp.util.FileUtil;
import org.xid.basics.error.DiagnosticUtil;
import org.xid.basics.generation.MergerUtil;
import org.xid.basics.progress.ActionMonitor;

public class TinaModel {
    private final NumberFormat integerFormat = DecimalFormat.getIntegerInstance();
    private final NumberFormat decimalFormat = DecimalFormat.getNumberInstance();
    private final OBPt ui;
    private File cdlFile;
    private long cdlFileModifiedDate = -1L;
    private CDLUnit cdlUnit;
    private CDLDeclaration cdl;
    private boolean autoPartition = false;
    private int initialStep = 1;
    private int splitStep = 1;
    private Thread cdlInformationThread;
    private boolean computingCdlInformation = false;
    private boolean cdlInformationUptodate = false;
    private ConcreteContext concreteContext;
    private BigInteger contextPathCount = null;
    private File completeProgramFile;
    private final List<File> programFileList = new ArrayList<File>();
    private final List<Long> programFileModifiedDate = new ArrayList<Long>();
    private String programSource;
    private File formulasFile;
    private long formulasFileModifiedDate = -1L;
    private String formulas;
    private boolean explorationComplete;
    private List<ExplorationResultInfo> tinaResults;
    private String resultDescription;
    private List<SeltResult> seltResults;

    public TinaModel(OBPt ui) {
        this.ui = ui;
    }

    private void initCdlAttributes() {
        this.cdlInformationUptodate = false;
        this.cdlUnit = null;
        this.cdl = null;
        this.concreteContext = null;
    }

    public CDLDeclaration getCdl() {
        return this.cdl;
    }

    public void setCdl(CDLDeclaration cdl) {
        this.cdl = cdl;
        this.concreteContext = cdl != null ? CDLToConcreteContext.toConcreteContext(this.cdlUnit, cdl) : null;
    }

    public CDLUnit getCdlUnit() {
        return this.cdlUnit;
    }

    public List<CDLDeclaration> getCdlList() {
        if (this.cdlUnit == null) {
            return Collections.emptyList();
        }
        return CDLUtil.findAllDeclarations(this.cdlUnit, CDLDeclaration.class);
    }

    public File getCdlFile() {
        return this.cdlFile;
    }

    public void setCdlFile(File cdlFile) {
        this.cdlFile = cdlFile;
        String oldCdlName = this.cdl == null ? null : this.cdl.getName();
        this.initCdlAttributes();
        if (cdlFile != null) {
            this.cdlFileModifiedDate = cdlFile.lastModified();
            try {
                this.cdlUnit = CDLUtil.readCDLAndResolveReferences(cdlFile);
                CDLDeclaration newCdl = null;
                if (oldCdlName != null) {
                    newCdl = CDLUtil.findDeclaration(this.cdlUnit, oldCdlName, CDLDeclaration.class);
                }
                List<CDLDeclaration> cdls = this.getCdlList();
                if (newCdl == null && cdls.size() > 0) {
                    newCdl = cdls.get(0);
                }
                this.setCdl(newCdl);
            }
            catch (Exception e) {
                this.ui.error(DiagnosticUtil.createMessage((Throwable)e) + "\n");
            }
        }
    }

    public boolean isAutoPartition() {
        return this.autoPartition;
    }

    public void setAutoPartition(boolean autoPartition) {
        this.autoPartition = autoPartition;
    }

    public int getInitialStep() {
        return this.initialStep;
    }

    public void setInitialStep(int initialStep) {
        this.initialStep = initialStep;
    }

    public int getSplitStep() {
        return this.splitStep;
    }

    public void setSplitStep(int splitStep) {
        this.splitStep = splitStep;
    }

    public List<File> getProgramFileList() {
        return Collections.unmodifiableList(this.programFileList);
    }

    public void addProgramFile(File programFile) {
        this.programFileList.add(programFile);
        this.refreshProgramSource();
    }

    public void removeProgramFile(File programFile) {
        int index = this.programFileList.indexOf(programFile);
        if (index >= 0) {
            this.programFileList.remove(index);
            this.refreshProgramSource();
        }
    }

    public boolean canUpProgramFile(File programFile) {
        if (programFile == null) {
            return false;
        }
        int index = this.programFileList.indexOf(programFile);
        return index > 0;
    }

    public void upProgramFile(File programFile) {
        int index = this.programFileList.indexOf(programFile);
        this.programFileList.remove(index);
        this.programFileList.add(index - 1, programFile);
        this.refreshProgramSource();
    }

    public boolean canDownProgramFile(File programFile) {
        if (programFile == null) {
            return false;
        }
        int index = this.programFileList.indexOf(programFile);
        return index < this.programFileList.size() - 1;
    }

    public void downProgramFile(File programFile) {
        int index = this.programFileList.indexOf(programFile);
        this.programFileList.remove(index);
        this.programFileList.add(index + 1, programFile);
        this.refreshProgramSource();
    }

    public void clearsProgramFileList() {
        this.programFileList.clear();
        this.refreshProgramSource();
    }

    public void exportScrambledProgram() throws Exception {
        File explorableProgramFile = this.getExplorableProgramFile();
        String explorableName = explorableProgramFile.getName();
        String name = explorableName.substring(0, explorableName.length() - 4) + "_scrambled.fcr";
        File scrambled = new File(explorableProgramFile.getParentFile(), name);
        Program program = FiacreUtil.loadProgram(this.programSource);
        FiacreScrambler.scramble(program);
        MergerUtil.writeFile((File)scrambled, (String)FiacrePrinter.toString(program), (String)"UTF-8");
        this.refreshProgramSource();
    }

    public void exportLabelledProgram() throws Exception {
        File explorableProgramFile = this.getExplorableProgramFile();
        String explorableName = explorableProgramFile.getName();
        String name = explorableName.substring(0, explorableName.length() - 4) + "_labelled.fcr";
        File scrambled = new File(explorableProgramFile.getParentFile(), name);
        Program program = FiacreUtil.loadProgram(this.programSource);
        FiacreTransitionLabeller.label(program);
        MergerUtil.writeFile((File)scrambled, (String)FiacrePrinter.toString(program), (String)"UTF-8");
        this.refreshProgramSource();
    }

    private void refreshProgramSource() {
        this.ui.setExplored(false);
        this.programSource = null;
        this.completeProgramFile = null;
        if (this.programFileList.size() > 1) {
            File parent = this.programFileList.get(0).getParentFile();
            this.completeProgramFile = new File(parent, "OBPt_Complete.fcr");
        }
        if (this.programFileList.size() > 0) {
            StringBuilder source = new StringBuilder();
            for (File programFile : this.programFileList) {
                source.append(FileUtil.loadContents(programFile));
                source.append(System.getProperty("line.separator"));
            }
            this.programSource = source.toString();
            if (this.completeProgramFile != null) {
                try {
                    MergerUtil.writeFile((File)this.completeProgramFile, (String)this.programSource, (String)"UTF-8");
                }
                catch (Exception e) {
                    this.ui.error("Can't create file '" + this.completeProgramFile + "'\n.");
                    return;
                }
                this.ui.log("Generated file " + this.completeProgramFile + "'.\n");
            }
        }
        this.programFileModifiedDate.clear();
        for (File programFile : this.programFileList) {
            this.programFileModifiedDate.add(programFile.lastModified());
        }
    }

    public File getExplorableProgramFile() {
        if (this.programFileList.isEmpty()) {
            return null;
        }
        if (this.completeProgramFile == null) {
            return this.programFileList.get(0);
        }
        return this.completeProgramFile;
    }

    public String getProgramSource() {
        return this.programSource;
    }

    public File getFormulasFile() {
        return this.formulasFile;
    }

    public void setFormulasFile(File formulasFile) {
        this.formulasFile = formulasFile;
        if (formulasFile != null) {
            this.formulasFileModifiedDate = formulasFile.lastModified();
            this.formulas = FileUtil.loadContents(formulasFile);
        } else {
            this.formulas = null;
        }
    }

    public String getFormulas() {
        return this.formulas;
    }

    public List<ExplorationResultInfo> getTinaResults() {
        return this.tinaResults;
    }

    public List<SeltResult> getSeltResults() {
        return this.seltResults;
    }

    public void reloadFilesIfNeeded() {
        if (this.cdlFile != null && this.cdlFile.lastModified() > this.cdlFileModifiedDate) {
            this.setCdlFile(this.cdlFile);
            this.ui.log("CDL file reloaded.\n");
            this.ui.refreshFilesFields();
            this.ui.refreshCdlFields();
        }
        boolean modified = false;
        for (int i = 0; i < this.programFileList.size(); ++i) {
            File programFile = this.programFileList.get(i);
            long date = this.programFileModifiedDate.get(i);
            if (programFile.lastModified() <= date) continue;
            modified = true;
        }
        if (modified) {
            this.refreshProgramSource();
            this.ui.log("Program files reloaded.\n");
            this.ui.refreshProgramFields();
        }
        if (this.formulasFile != null && this.formulasFile.lastModified() > this.formulasFileModifiedDate) {
            this.setFormulasFile(this.formulasFile);
            this.ui.log("Formulas file reloaded.\n");
            this.ui.refreshFormulasFields();
        }
    }

    public boolean explore(final TinaController controller, final ActionMonitor monitor) {
        this.explorationComplete = false;
        this.tinaResults = new ArrayList<ExplorationResultInfo>();
        this.resultDescription = null;
        ActionMonitor.Sub sub = new ActionMonitor.Sub(monitor, -1, -1){

            public void done() {
                TinaModel.this.explorationComplete = true;
                while (controller.hasResult()) {
                    TinaModel.this.tinaResults.add(controller.popResult(ExplorationResultInfo.class));
                }
                monitor.done();
            }

            public void canceled() {
                while (controller.hasResult() && controller.isResult(ExplorationResultInfo.class)) {
                    TinaModel.this.tinaResults.add(controller.popResult(ExplorationResultInfo.class));
                }
                monitor.canceled();
            }
        };
        if (this.concreteContext != null) {
            if (this.isAutoPartition()) {
                controller.exploreFiacreAutoSplit(this.getExplorableProgramFile(), this.concreteContext, this.initialStep, this.splitStep, (ActionMonitor)sub);
            } else {
                controller.exploreFiacre(this.getExplorableProgramFile(), this.concreteContext, (ActionMonitor)sub);
            }
        } else {
            controller.exploreFiacre(this.getExplorableProgramFile(), (ActionMonitor)sub);
        }
        return true;
    }

    public void check(final TinaController controller, final ActionMonitor monitor) {
        controller.check(this.formulasFile, this.ui.isUseDescription(), (ActionMonitor)new ActionMonitor.Sub(monitor, -1, -1){

            public void done() {
                TinaModel.this.seltResults = controller.popResult(List.class);
                monitor.done();
            }
        });
    }

    public boolean isComputingCdlInformation() {
        return this.computingCdlInformation;
    }

    public void stopComputingCdlInformation() {
        if (this.computingCdlInformation && this.cdlInformationThread != null) {
            this.cdlInformationThread.interrupt();
        }
    }

    public void computeCdlInfo(final ActionMonitor monitor) {
        if (this.cdl != null && this.concreteContext != null) {
            this.cdlInformationUptodate = false;
            this.computingCdlInformation = true;
            final long startDate = System.nanoTime();
            this.cdlInformationThread = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        TinaModel.this.contextPathCount = ConcreteContextUtil.countPaths(TinaModel.this.concreteContext);
                        TinaModel.this.cdlInformationUptodate = true;
                        long endDate = System.nanoTime();
                        float delay = (float)(endDate - startDate) / 1000000.0f;
                        TinaModel.this.ui.log("Computed CDL informations in " + TinaModel.this.integerFormat.format(delay) + " ms.\n");
                        monitor.done();
                    }
                    catch (Throwable e) {
                        TinaModel.this.cdlInformationUptodate = false;
                        TinaModel.this.ui.error(DiagnosticUtil.createMessage((Throwable)e) + "\n");
                        monitor.canceled();
                    }
                    finally {
                        TinaModel.this.computingCdlInformation = false;
                        TinaModel.this.cdlInformationThread = null;
                    }
                }
            });
            this.cdlInformationThread.start();
        } else {
            monitor.done();
        }
    }

    public String getCdlInfoDescription() {
        StringBuilder info = new StringBuilder();
        if (this.cdl == null || this.concreteContext == null) {
            info.append("No CDL loaded");
        } else {
            info.append("Complete concrete context contains ");
            info.append(this.integerFormat.format(this.concreteContext.getStateCount()));
            info.append(" st. and ");
            info.append(this.integerFormat.format(this.concreteContext.getTransitionCount()));
            info.append(" tr.\n");
            if (this.cdlInformationUptodate) {
                info.append("Counted ");
                info.append(this.integerFormat.format(this.contextPathCount));
                info.append(" paths in context.");
            } else {
                info.append("Click on 'refresh' to count paths.");
            }
        }
        return info.toString();
    }

    public boolean hasResults() {
        return this.tinaResults != null && this.tinaResults.size() > 0;
    }

    public String getResultDescription() {
        if (this.resultDescription == null) {
            if (this.tinaResults == null || this.tinaResults.isEmpty()) {
                return "No result";
            }
            if (this.tinaResults.size() == 1) {
                ExplorationResultInfo result = this.tinaResults.get(0);
                StringBuilder description = new StringBuilder();
                this.resultDescriptionHeader(description);
                description.append("Explored ");
                if (result.getConfigurationCount() != null) {
                    description.append(this.integerFormat.format(result.getConfigurationCount()));
                } else {
                    description.append("??");
                }
                description.append(" states and ");
                if (result.getActionCount() != null) {
                    description.append(this.integerFormat.format(result.getActionCount()));
                } else {
                    description.append("??");
                }
                description.append(" transitions in ");
                description.append(this.decimalFormat.format(result.getDuration()));
                description.append(" seconds.");
                description.append("\n");
                if (!result.isComplete()) {
                    description.append("Exploration is INCOMPLETE.\n");
                }
                if (result.getContext() != null) {
                    description.append("Context '");
                    description.append(result.getContext().getName());
                    description.append("' contained ");
                    if (this.contextPathCount != null) {
                        description.append(this.integerFormat.format(this.contextPathCount));
                        description.append(" paths, ");
                    }
                    description.append(this.integerFormat.format(result.getContext().getStateCount()));
                    description.append(" states, and ");
                    description.append(this.integerFormat.format(result.getContext().getTransitionCount()));
                    description.append(" transitions.");
                    description.append("\n");
                }
                this.resultDescription = description.toString();
            } else {
                BigInteger stateCountAll = BigInteger.ZERO;
                BigInteger transitionCountAll = BigInteger.ZERO;
                double durationAll = 0.0;
                BigInteger stateCountEfficient = BigInteger.ZERO;
                BigInteger transitionCountEfficient = BigInteger.ZERO;
                double durationEfficient = 0.0;
                long efficient = 0L;
                for (ExplorationResultInfo result : this.tinaResults) {
                    if (result.getConfigurationCount() != null) {
                        stateCountAll = stateCountAll.add(result.getConfigurationCount());
                    }
                    if (result.getActionCount() != null) {
                        transitionCountAll = transitionCountAll.add(result.getActionCount());
                    }
                    durationAll += result.getDuration();
                    if (!result.isComplete()) continue;
                    ++efficient;
                    if (result.getConfigurationCount() != null) {
                        stateCountEfficient = stateCountEfficient.add(result.getConfigurationCount());
                    }
                    if (result.getActionCount() != null) {
                        transitionCountEfficient = transitionCountEfficient.add(result.getActionCount());
                    }
                    durationEfficient += result.getDuration();
                }
                StringBuilder description = new StringBuilder();
                this.resultDescriptionHeader(description);
                if (!this.explorationComplete) {
                    description.append("Exploration is INCOMPLETE.\n");
                }
                description.append("-> With split contexts:\n");
                description.append("Explored ");
                description.append(this.integerFormat.format(stateCountAll));
                description.append(" states and ");
                description.append(this.integerFormat.format(transitionCountAll));
                description.append(" transitions in ");
                description.append(this.decimalFormat.format(durationAll));
                description.append(" seconds.");
                description.append("\n\n");
                description.append("-> Only efficient contexts:\n");
                description.append("Explored ");
                description.append(this.integerFormat.format(stateCountEfficient));
                description.append(" states and ");
                description.append(this.integerFormat.format(transitionCountEfficient));
                description.append(" transitions in ");
                description.append(this.decimalFormat.format(durationEfficient));
                description.append(" seconds.");
                description.append("\n\n");
                description.append("Total number of contexts: ");
                description.append(this.integerFormat.format(this.tinaResults.size()));
                description.append("\n");
                description.append("Number of efficient contexts: ");
                description.append(this.integerFormat.format(efficient));
                description.append("\n");
                description.append("Number of split contexts: ");
                description.append(this.integerFormat.format((long)this.tinaResults.size() - efficient));
                description.append("\n\n");
                for (int i = this.tinaResults.size() - 1; i >= 0; --i) {
                    ExplorationResultInfo result = this.tinaResults.get(i);
                    description.append("- ");
                    if (!result.isComplete()) {
                        description.append("[split] ");
                    }
                    description.append(result.getContext().getName());
                    description.append("(");
                    description.append(this.integerFormat.format(result.getContext().getStateCount()));
                    description.append(" states and ");
                    description.append(this.integerFormat.format(result.getContext().getTransitionCount()));
                    description.append(" transitions) Explored in ");
                    description.append(this.decimalFormat.format(result.getDuration()));
                    description.append(" seconds: ");
                    if (result.getConfigurationCount() != null) {
                        description.append(this.integerFormat.format(result.getConfigurationCount()));
                    } else {
                        description.append("??");
                    }
                    description.append(" states and ");
                    if (result.getActionCount() != null) {
                        description.append(this.integerFormat.format(result.getActionCount()));
                    } else {
                        description.append("??");
                    }
                    description.append(" transitions.\n");
                }
                this.resultDescription = description.toString();
            }
        }
        return this.resultDescription;
    }

    private void resultDescriptionHeader(StringBuilder description) {
        description.append("--------------------Informations------------------");
        description.append("\n");
        description.append("Exploration: ");
        DateFormat format = SimpleDateFormat.getDateTimeInstance();
        description.append(format.format(new Date()));
        description.append("\n");
        if (this.getCdlFile() != null) {
            description.append("CDL '");
            description.append(this.cdl.getName());
            description.append("' ");
            description.append("in file: ");
            description.append(this.getCdlFile().getPath());
            description.append(".\n");
        }
        if (this.isAutoPartition()) {
            description.append("CDL has been split (initial: ");
            description.append(this.getInitialStep());
            description.append(", step: ");
            description.append(this.getSplitStep());
            description.append(").\n");
            description.append("\n");
        }
        description.append("Fiacre file names: \n");
        for (File file : this.getProgramFileList()) {
            description.append("- ");
            description.append(file.getPath());
            description.append(".\n");
        }
        description.append(this.ui.getVersionString());
        description.append("\n");
        description.append("--------------------Synthesis---------------------");
        description.append("\n");
    }
}

