/*
 * Decompiled with CFR 0.152.
 */
package obp.ui.sequence;

import obp.ui.sequence.HorizontalLine;
import obp.ui.sequence.HorizontalLineElement;
import obp.ui.sequence.LifeLine;
import obp.ui.sequence.LifeLineElement;
import obp.ui.sequence.Message;
import obp.ui.sequence.MessageElement;
import obp.ui.sequence.Sequence;
import obp.ui.sequence.SequenceItem;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.xid.basics.ui.diagram.Diagram;
import org.xid.basics.ui.diagram.DiagramContext;
import org.xid.basics.ui.diagram.Element;

public class SequenceDiagram
extends Diagram<Sequence> {
    public static final RGB defaultBackGroundRgb = new RGB(255, 251, 246);

    public SequenceDiagram() {
    }

    public SequenceDiagram(Sequence model) {
        this.setModel(model);
    }

    public void build() {
        this.clearElements();
        if (this.model != null) {
            boolean hasLines = ((Sequence)this.model).getLineCount() > 0;
            float minX = hasLines ? Float.MAX_VALUE : 20.0f;
            float maxX = hasLines ? Float.MIN_VALUE : 300.0f;
            for (LifeLine line : ((Sequence)this.model).getLifeLineList()) {
                if (!line.isVisible()) continue;
                float x = line.getX();
                if (x > maxX) {
                    maxX = x;
                }
                if (!(x < minX)) continue;
                minX = x;
            }
            float initial = 100.0f;
            float delta = 20.0f;
            int maxOrder = 0;
            for (SequenceItem item : ((Sequence)this.model).getItemList()) {
                if (item instanceof Message) {
                    Message message = (Message)item;
                    if (!this.isVisible(message)) continue;
                    float[] sourcePoint = null;
                    if (message.getSource() != null) {
                        sourcePoint = new float[]{message.getSource().getX(), initial + (float)message.getSourceOrder() * delta};
                    }
                    float[] targetPoint = null;
                    if (message.getTarget() != null) {
                        targetPoint = new float[]{message.getTarget().getX(), initial + (float)message.getTargetOrder() * delta};
                    }
                    maxOrder = Math.max(message.getSourceOrder(), maxOrder);
                    maxOrder = Math.max(message.getTargetOrder(), maxOrder);
                    MessageElement element = new MessageElement(message, sourcePoint, targetPoint);
                    this.addElement((Element)element);
                    continue;
                }
                if (!(item instanceof HorizontalLine)) continue;
                HorizontalLine horizontalLine = (HorizontalLine)item;
                float y = initial + (float)horizontalLine.getOrder() * delta;
                float[] sourcePoint = new float[]{minX - 50.0f, y};
                float[] targetPoint = new float[]{maxX + 50.0f, y};
                maxOrder = Math.max(horizontalLine.getOrder(), maxOrder);
                HorizontalLineElement element = new HorizontalLineElement(horizontalLine, sourcePoint, targetPoint);
                this.addElement((Element)element);
            }
            for (LifeLine line : ((Sequence)this.model).getLifeLineList()) {
                float height = line.isVisible() ? initial + delta * (float)(maxOrder + 1) : 0.0f;
                LifeLineElement element = new LifeLineElement(line, new float[]{line.getX(), 50.0f}, 100.0f, height);
                this.addElement(0, (Element)element);
            }
        }
        this.invalidateBounds();
    }

    private boolean isVisible(Message message) {
        LifeLine source = message.getSource();
        LifeLine target = message.getTarget();
        if (target == null) {
            return source.isVisible();
        }
        if (source == null) {
            return target.isVisible();
        }
        return source.isVisible() && target.isVisible();
    }

    public void updateAll(DiagramContext context) {
        boolean hasLines = ((Sequence)this.model).getLineCount() > 0;
        float minX = hasLines ? Float.MAX_VALUE : 20.0f;
        float maxX = hasLines ? Float.MIN_VALUE : 300.0f;
        for (LifeLine line : ((Sequence)this.model).getLifeLineList()) {
            if (!line.isVisible()) continue;
            LifeLineElement element = (LifeLineElement)((Object)this.findElement(LifeLineElement.class, line));
            float x = element.getX();
            if (x > maxX) {
                maxX = x;
            }
            if (!(x < minX)) continue;
            minX = x;
        }
        for (Element element : this.getElements()) {
            if (element.getClass() == MessageElement.class) {
                ((MessageElement)element).update(context);
            }
            if (element.getClass() != HorizontalLineElement.class) continue;
            ((HorizontalLineElement)element).update(context, minX, maxX);
        }
    }

    public Color getBackground(DiagramContext context) {
        return context.getResources().getColor(defaultBackGroundRgb);
    }
}

