/*
 * Decompiled with CFR 0.152.
 */
package tlc2.value;

import tlc2.tool.FingerprintException;
import tlc2.util.FP64;
import tlc2.value.Enumerable;
import tlc2.value.EnumerableValue;
import tlc2.value.IntValue;
import tlc2.value.MVPerm;
import tlc2.value.ModelValue;
import tlc2.value.Reducible;
import tlc2.value.SetCupValue;
import tlc2.value.SetEnumValue;
import tlc2.value.Value;
import tlc2.value.ValueEnumeration;
import tlc2.value.ValueExcept;
import tlc2.value.ValueVec;
import util.Assert;

public class IntervalValue
extends EnumerableValue
implements Enumerable,
Reducible {
    public int low;
    public int high;

    public IntervalValue(int low, int high) {
        this.low = low;
        this.high = high;
    }

    @Override
    public final byte getKind() {
        return 23;
    }

    @Override
    public final int compareTo(Object obj) {
        try {
            if (obj instanceof IntervalValue) {
                IntervalValue intv = (IntervalValue)obj;
                int cmp = this.size() - intv.size();
                if (cmp != 0) {
                    return cmp;
                }
                if (this.size() == 0) {
                    return 0;
                }
                return this.low - intv.low;
            }
            return SetEnumValue.convert(this).compareTo(obj);
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    public final boolean equals(Object obj) {
        try {
            if (obj instanceof IntervalValue) {
                IntervalValue intv = (IntervalValue)obj;
                if (this.size() == 0) {
                    return intv.size() == 0;
                }
                return this.low == intv.low && this.high == intv.high;
            }
            return SetEnumValue.convert(this).equals(obj);
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final boolean member(Value elem) {
        try {
            if (elem instanceof IntValue) {
                int x = ((IntValue)elem).val;
                return x >= this.low && x <= this.high;
            }
            if (!(this.low > this.high || elem instanceof ModelValue && ((ModelValue)elem).type == '\u0000')) {
                Assert.fail("Attempted to check if the value:\n" + IntervalValue.ppr(elem.toString()) + "\nis in the integer interval " + IntervalValue.ppr(this.toString()));
            }
            return false;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public Value isSubsetEq(Value other) {
        try {
            if (other instanceof IntervalValue) {
                IntervalValue iv = (IntervalValue)other;
                if (iv.low <= this.low && iv.high >= this.high) {
                    return ValTrue;
                }
            }
            return super.isSubsetEq(other);
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final boolean isFinite() {
        return true;
    }

    @Override
    public final int size() {
        try {
            if (this.high < this.low) {
                return 0;
            }
            return this.high - this.low + 1;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    final Value[] asValues() {
        Value[] values = new Value[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            values[i] = IntValue.gen(this.low + i);
        }
        return values;
    }

    @Override
    public final Value diff(Value val) {
        try {
            ValueVec diffElems = new ValueVec();
            for (int i = this.low; i <= this.high; ++i) {
                IntValue elem = IntValue.gen(i);
                if (val.member(elem)) continue;
                diffElems.addElement(elem);
            }
            return new SetEnumValue(diffElems, true);
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final Value cap(Value val) {
        try {
            ValueVec capElems = new ValueVec();
            for (int i = this.low; i <= this.high; ++i) {
                IntValue elem = IntValue.gen(i);
                if (!val.member(elem)) continue;
                capElems.addElement(elem);
            }
            return new SetEnumValue(capElems, true);
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final Value cup(Value set) {
        try {
            if (this.size() == 0) {
                return set;
            }
            if (set instanceof Reducible) {
                Value elem;
                ValueVec cupElems = new ValueVec();
                for (int i = this.low; i <= this.high; ++i) {
                    cupElems.addElement(IntValue.gen(i));
                }
                ValueEnumeration Enum2 = ((Enumerable)((Object)set)).elements();
                while ((elem = Enum2.nextElement()) != null) {
                    if (this.member(elem)) continue;
                    cupElems.addElement(elem);
                }
                return new SetEnumValue(cupElems, false);
            }
            return new SetCupValue(this, set);
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final Value takeExcept(ValueExcept ex) {
        try {
            if (ex.idx < ex.path.length) {
                Assert.fail("Attempted to apply EXCEPT construct to the interval value " + IntervalValue.ppr(this.toString()) + ".");
            }
            return ex.value;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final Value takeExcept(ValueExcept[] exs) {
        try {
            if (exs.length != 0) {
                Assert.fail("Attempted to apply EXCEPT construct to the interval value " + IntervalValue.ppr(this.toString()) + ".");
            }
            return this;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final boolean isNormalized() {
        return true;
    }

    @Override
    public final Value normalize() {
        return this;
    }

    @Override
    public final boolean isDefined() {
        return true;
    }

    @Override
    public final Value deepCopy() {
        return this;
    }

    @Override
    public final boolean assignable(Value val) {
        try {
            return val instanceof IntervalValue && this.high == ((IntervalValue)val).high && this.low == ((IntervalValue)val).low;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final long fingerPrint(long fp) {
        try {
            fp = FP64.Extend(fp, (byte)5);
            fp = FP64.Extend(fp, this.size());
            for (int i = this.low; i <= this.high; ++i) {
                fp = FP64.Extend(fp, (byte)1);
                fp = FP64.Extend(fp, i);
            }
            return fp;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final Value permute(MVPerm perm) {
        return this;
    }

    @Override
    public final StringBuffer toString(StringBuffer sb, int offset) {
        try {
            if (this.low <= this.high) {
                return sb.append(this.low).append("..").append(this.high);
            }
            return sb.append("{").append("}");
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public EnumerableValue getRandomSubset(int kOutOfN) {
        ValueVec vec = new ValueVec(kOutOfN);
        ValueEnumeration ve = this.elements(kOutOfN);
        Value v = null;
        while ((v = ve.nextElement()) != null) {
            vec.addElement(v);
        }
        return new SetEnumValue(vec, false);
    }

    public Value elementAt(int idx) {
        if (0 <= idx && idx < this.size()) {
            return IntValue.gen(this.low + idx);
        }
        Assert.fail("Attempted to retrieve out-of-bounds element from the interval value " + IntervalValue.ppr(this.toString()) + ".");
        return null;
    }

    @Override
    public final ValueEnumeration elements() {
        try {
            return new Enumerator();
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public ValueEnumeration elements(int kOutOfN) {
        return new EnumerableValue.SubsetEnumerator(kOutOfN){

            @Override
            public Value nextElement() {
                if (!this.hasNext()) {
                    return null;
                }
                return IntValue.gen(IntervalValue.this.low + this.nextIndex());
            }
        };
    }

    final class Enumerator
    implements ValueEnumeration {
        int index;

        Enumerator() {
            this.index = IntervalValue.this.low;
        }

        @Override
        public final void reset() {
            this.index = IntervalValue.this.low;
        }

        @Override
        public final Value nextElement() {
            if (this.index <= IntervalValue.this.high) {
                return IntValue.gen(this.index++);
            }
            return null;
        }
    }
}

