/*
 * Decompiled with CFR 0.152.
 */
package org.xid.basics.sexp;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.xid.basics.sexp.SAtom;
import org.xid.basics.sexp.SExp;
import org.xid.basics.sexp.SExpParser;
import org.xid.basics.sexp.SList;
import org.xid.basics.sexp.SVariable;

public class S {
    public static SAtom snullatom() {
        return new SAtom("null");
    }

    public static SAtom satom(String value) {
        return new SAtom(value);
    }

    public static SList slist(SExp ... children) {
        return new SList(children);
    }

    public static SList slist(List<SExp> children) {
        return new SList(children);
    }

    public static SVariable svariable(String name) {
        return new SVariable(name);
    }

    public static String quote(String toQuote) {
        if (toQuote == null) {
            return "''";
        }
        StringBuilder quoted = new StringBuilder();
        quoted.append('\'');
        for (int i = 0; i < toQuote.length(); ++i) {
            char c = toQuote.charAt(i);
            if (c == '\'') {
                quoted.append("\\'");
                continue;
            }
            quoted.append(c);
        }
        quoted.append('\'');
        return quoted.toString();
    }

    public static String unquote(String value) {
        if (S.isQuoted(value)) {
            int length = value.length();
            String result = value.substring(1, length - 1);
            result = result.replaceAll("\\\\'", "'");
            return result;
        }
        return value;
    }

    public static boolean isQuoted(String value) {
        int length = value.length();
        if (value == null || length < 2) {
            return false;
        }
        if (value.charAt(0) != '\'' || value.charAt(length - 1) != '\'') {
            return true;
        }
        return true;
    }

    public static void addChildIfNotNull(SList container, SExp child) {
        if (!child.isNull()) {
            container.addChild(child);
        }
    }

    public SExp parse(String contents) {
        if (contents == null) {
            return null;
        }
        ByteArrayInputStream stream = null;
        try {
            SExpParser parser = new SExpParser();
            stream = new ByteArrayInputStream(contents.getBytes());
            return parser.parse(stream);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static SExp enumToSExp(String name, Enum<?> value) {
        SList sexp = S.slist(S.satom(name));
        if (value != null) {
            sexp.addChild(S.satom(value.name()));
        } else {
            sexp.addChild(S.snullatom());
        }
        return sexp;
    }

    public static <T extends Enum<T>> T sexpToEnum(Class<T> type, SExp sexp) {
        if (sexp.getChildCount() == 2 && sexp.getChild(1).isNull()) {
            return null;
        }
        return Enum.valueOf(type, sexp.getChild(1).getValue());
    }

    public static SExp stringToSExp(String name, String value) {
        SList sexp = S.slist(S.satom(name));
        if (value != null) {
            sexp.addChild(S.satom(S.quote(value)));
        } else {
            sexp.addChild(S.snullatom());
        }
        return sexp;
    }

    public static String sexpToString(SExp sexp) {
        if (sexp.getChildCount() == 2 && sexp.getChild(1).isNull()) {
            return null;
        }
        return S.unquote(sexp.getChild(1).getValue());
    }

    public static SExp stringCollectionToSExp(String name, Collection<String> value) {
        SList sexp = new SList();
        sexp.addChild(S.satom(name));
        if (value != null) {
            for (String oneValue : value) {
                sexp.addChild(S.satom(S.quote(oneValue)));
            }
        } else {
            sexp.addChild(S.snullatom());
        }
        return sexp;
    }

    public static Collection<String> sexpToStringCollection(SExp sexp) {
        if (sexp.getChildCount() == 2 && sexp.getChild(1).isNull()) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 1; i < sexp.getChildCount(); ++i) {
            result.add(S.unquote(sexp.getChild(i).getValue()));
        }
        return result;
    }

    public static SExp fileToSExp(String name, File value) {
        SList result = S.slist(S.satom(name));
        if (value != null) {
            String path = value.getPath();
            path = path.replace('\\', '/');
            String verbatim = S.quote(path);
            result.addChild(S.satom(verbatim));
        } else {
            result.addChild(S.snullatom());
        }
        return result;
    }

    public static File sexpToFile(SExp sexp) {
        if (sexp.getChildCount() == 2 && sexp.getChild(1).isNull()) {
            return null;
        }
        String path = S.unquote(sexp.getChild(1).getValue());
        path = path.replace('\\', '/');
        return new File(path);
    }

    public static SExp fileCollectionToSExp(String name, Collection<File> value) {
        SList sexp = new SList();
        sexp.addChild(S.satom(name));
        if (value != null) {
            for (File oneValue : value) {
                String path = oneValue.getPath();
                path = path.replace('\\', '/');
                sexp.addChild(S.satom(S.quote(path)));
            }
        } else {
            sexp.addChild(S.snullatom());
        }
        return sexp;
    }

    public static Collection<File> sexpToFileCollection(SExp sexp) {
        if (sexp.getChildCount() == 2 && sexp.getChild(1).isNull()) {
            return null;
        }
        ArrayList<File> result = new ArrayList<File>();
        for (int i = 1; i < sexp.getChildCount(); ++i) {
            String path = S.unquote(sexp.getChild(i).getValue());
            path = path.replace('\\', '/');
            result.add(new File(path));
        }
        return result;
    }

    public static SExp intToSExp(String name, int value) {
        SList sexp = new SList();
        sexp.addChild(S.satom(name));
        sexp.addChild(S.satom(Integer.toString(value)));
        return sexp;
    }

    public static int sexpToInt(SExp sexp) {
        return Integer.parseInt(sexp.getChild(1).getValue());
    }

    public static SExp intArrayToSExp(String name, int[] value) {
        SList sexp = new SList();
        sexp.addChild(S.satom(name));
        if (value != null) {
            for (int oneValue : value) {
                sexp.addChild(S.satom(Integer.toString(oneValue)));
            }
        } else {
            sexp.addChild(S.snullatom());
        }
        return sexp;
    }

    public static int[] sexpToIntArray(SExp sexp) {
        if (sexp.getChildCount() == 2 && sexp.getChild(1).isNull()) {
            return null;
        }
        int[] result = new int[sexp.getChildCount() - 1];
        for (int i = 1; i < sexp.getChildCount(); ++i) {
            result[i - 1] = Integer.parseInt(sexp.getChild(i).getValue());
        }
        return result;
    }

    public static SExp longToSExp(String name, long value) {
        SList sexp = new SList();
        sexp.addChild(S.satom(name));
        sexp.addChild(S.satom(Long.toString(value)));
        return sexp;
    }

    public static long sexpToLong(SExp sexp) {
        return Long.parseLong(sexp.getChild(1).getValue());
    }

    public static SExp longArrayToSExp(String name, long[] value) {
        SList sexp = new SList();
        sexp.addChild(S.satom(name));
        if (value != null) {
            for (long oneValue : value) {
                sexp.addChild(S.satom(Long.toString(oneValue)));
            }
        } else {
            sexp.addChild(S.snullatom());
        }
        return sexp;
    }

    public static long[] sexpToLongArray(SExp sexp) {
        if (sexp.getChildCount() == 2 && sexp.getChild(1).isNull()) {
            return null;
        }
        long[] result = new long[sexp.getChildCount() - 1];
        for (int i = 1; i < sexp.getChildCount(); ++i) {
            result[i - 1] = Long.parseLong(sexp.getChild(i).getValue());
        }
        return result;
    }

    public static SExp integerObjectToSExp(String name, Integer value) {
        SList sexp = new SList();
        sexp.addChild(S.satom(name));
        sexp.addChild(S.satom(value.toString()));
        return sexp;
    }

    public static Integer sexpToIntegerObject(SExp sexp) {
        return new Integer(sexp.getChild(1).getValue());
    }

    public static SExp integerObjectCollectionToSExp(String name, Collection<Integer> value) {
        SList sexp = new SList();
        sexp.addChild(S.satom(name));
        if (value != null) {
            for (Integer oneValue : value) {
                sexp.addChild(S.satom(oneValue.toString()));
            }
        } else {
            sexp.addChild(S.snullatom());
        }
        return sexp;
    }

    public static Collection<Integer> sexpToIntegerObjectCollection(SExp sexp) {
        if (sexp.getChildCount() == 2 && sexp.getChild(1).isNull()) {
            return null;
        }
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (int i = 1; i < sexp.getChildCount(); ++i) {
            result.add(new Integer(sexp.getChild(i).getValue()));
        }
        return result;
    }

    public static BigDecimal sexpToBigDecimal(SExp sexp) {
        SExp child = sexp.getChild(1);
        if (child.isNull()) {
            return null;
        }
        return new BigDecimal(child.getValue());
    }

    public static SExp bigDecimalToSExp(String name, BigDecimal value) {
        SList sexp = new SList();
        sexp.addChild(S.satom(name));
        sexp.addChild(value == null ? S.snullatom() : S.satom(value.toString()));
        return sexp;
    }

    public static boolean sexpToBoolean(SExp sexp) {
        return Boolean.parseBoolean(sexp.getChild(1).getValue());
    }

    public static SExp booleanToSExp(String name, boolean value) {
        SList sexp = new SList();
        sexp.addChild(S.satom(name));
        sexp.addChild(S.satom(Boolean.toString(value)));
        return sexp;
    }

    public static SExp booleanArrayToSExp(String name, boolean[] value) {
        SList sexp = new SList();
        sexp.addChild(S.satom(name));
        if (value != null) {
            for (boolean oneValue : value) {
                sexp.addChild(S.satom(Boolean.toString(oneValue)));
            }
        } else {
            sexp.addChild(S.snullatom());
        }
        return sexp;
    }

    public static boolean[] sexpToBooleanArray(SExp sexp) {
        if (sexp.getChildCount() == 2 && sexp.getChild(1).isNull()) {
            return null;
        }
        boolean[] result = new boolean[sexp.getChildCount() - 1];
        for (int i = 1; i < sexp.getChildCount(); ++i) {
            result[i - 1] = Boolean.parseBoolean(sexp.getChild(i).getValue());
        }
        return result;
    }

    public static SExp floatToSExp(String name, float value) {
        SList sexp = new SList();
        sexp.addChild(S.satom(name));
        sexp.addChild(S.satom(Float.toString(value)));
        return sexp;
    }

    public static float sexpToFloat(SExp sexp) {
        return Float.parseFloat(sexp.getChild(1).getValue());
    }

    public static SExp floatArrayToSExp(String name, float[] value) {
        SList sexp = new SList();
        sexp.addChild(S.satom(name));
        if (value != null) {
            for (float oneValue : value) {
                sexp.addChild(S.satom(Float.toString(oneValue)));
            }
        } else {
            sexp.addChild(S.snullatom());
        }
        return sexp;
    }

    public static float[] sexpToFloatArray(SExp sexp) {
        if (sexp.getChildCount() == 2 && sexp.getChild(1).isNull()) {
            return null;
        }
        float[] result = new float[sexp.getChildCount() - 1];
        for (int i = 1; i < sexp.getChildCount(); ++i) {
            result[i - 1] = Float.parseFloat(sexp.getChild(i).getValue());
        }
        return result;
    }
}

