/*
 * Decompiled with CFR 0.152.
 */
package properties.PropositionalLogic.interpreter.atom;

import java.util.Map;
import properties.PropositionalLogic.interpreter.IAtomEvaluator;
import properties.PropositionalLogic.parser.SymbolResolver;

public class AtomConstantMapEvaluator
implements IAtomEvaluator {
    Map<String, Boolean> constantMap;

    public AtomConstantMapEvaluator(Map<String, Boolean> constantMap) {
        this.constantMap = constantMap;
    }

    @Override
    public Object parse(String code) {
        Boolean value = this.constantMap.get(code);
        if (value == null) {
            throw new SymbolResolver.SymbolMissingException("'" + code + "' is not present in the constant map");
        }
        return code;
    }

    @Override
    public boolean evaluate(Object atomicBooleanExpression) {
        Boolean value = this.constantMap.get((String)atomicBooleanExpression);
        if (value == null) {
            throw new SymbolResolver.SymbolMissingException("'" + (String)atomicBooleanExpression + "' is not present in the constant map");
        }
        return value;
    }
}

