/*
 * Decompiled with CFR 0.152.
 */
package obp2.runtime.core;

import java.util.Iterator;
import java.util.function.Predicate;
import obp2.runtime.core.IAtomicPropositionsEvaluator;
import obp2.runtime.core.IAtomicPropositionsProvider;
import obp2.runtime.core.IMarshaller;
import obp2.runtime.core.ISimpleTransitionRelationIterator;
import obp2.runtime.core.ITransitionRelation;
import obp2.runtime.core.ITreeProjector;
import obp2.runtime.core.STR2TR;

public interface ILanguageModule<C, A, O>
extends AutoCloseable {
    public ITransitionRelation<C, A, O> getTransitionRelation();

    public IAtomicPropositionsEvaluator<C, A, O> getAtomicPropositionEvaluator();

    public IAtomicPropositionsProvider<C, A, O> getAtomicPropositionsProvider();

    public ITreeProjector<C, A, O> getTreeProjector();

    public IMarshaller<C, A, O> getMarshaller();

    public Predicate<C> isAcceptingPredicate();

    default public ISimpleTransitionRelationIterator<byte[]> getSimpleByteArrayTransitionRelation() {
        final STR2TR simpleTR = new STR2TR(this.getTransitionRelation());
        return new ISimpleTransitionRelationIterator<byte[]>(){
            ISimpleTransitionRelationIterator<C> operand;
            {
                this.operand = simpleTR;
            }

            @Override
            public Iterator<byte[]> initialIterator() {
                final Iterator iterator = this.operand.initialIterator();
                return new Iterator<byte[]>(){

                    @Override
                    public boolean hasNext() {
                        return iterator.hasNext();
                    }

                    @Override
                    public byte[] next() {
                        return ILanguageModule.this.getMarshaller().serializeConfiguration(iterator.next());
                    }
                };
            }

            @Override
            public Iterator<byte[]> nextIterator(byte[] source) {
                Object src = ILanguageModule.this.getMarshaller().deserializeConfiguration(source);
                final Iterator iterator = this.operand.nextIterator(src);
                return new Iterator<byte[]>(){

                    @Override
                    public boolean hasNext() {
                        return iterator.hasNext();
                    }

                    @Override
                    public byte[] next() {
                        return ILanguageModule.this.getMarshaller().serializeConfiguration(iterator.next());
                    }
                };
            }

            @Override
            public boolean isAccepting(byte[] configuration) {
                return this.operand.isAccepting(ILanguageModule.this.getMarshaller().deserializeConfiguration(configuration));
            }
        };
    }
}

