/*
 * Decompiled with CFR 0.152.
 */
package obp.fiacre.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import obp.fiacre.model.Communication;
import obp.fiacre.model.Exp;
import obp.fiacre.model.ModelVisitor;
import obp.fiacre.model.Pattern;
import org.xid.basics.serializer.Boost;
import org.xid.basics.serializer.BoostObject;
import org.xid.basics.serializer.BoostUtil;

public class Reception
extends Communication
implements BoostObject {
    private final List<Pattern> patternList = new ArrayList<Pattern>();
    private Exp where;

    public Reception() {
    }

    protected Reception(Boost boost) {
        super(boost);
        for (Pattern oneChild : BoostUtil.readObjectList((Boost)boost, Pattern.class)) {
            this.patternList.add(oneChild);
        }
        this.where = (Exp)boost.readObject(Exp.class);
    }

    public List<Pattern> getPatternList() {
        return Collections.unmodifiableList(this.patternList);
    }

    public int getPatternCount() {
        return this.patternList.size();
    }

    public Pattern getPattern(int index) {
        if (index < 0 || index >= this.getPatternCount()) {
            return null;
        }
        return this.patternList.get(index);
    }

    public void addPattern(Pattern newValue) {
        this.addPattern(this.getPatternCount(), newValue);
    }

    public void addPattern(int index, Pattern newValue) {
        this.patternList.add(index, newValue);
    }

    public Pattern setPattern(int index, Pattern newValue) {
        return this.patternList.set(index, newValue);
    }

    public void addAllPattern(Collection<Pattern> toAddList) {
        for (Pattern newValue : toAddList) {
            this.addPattern(this.getPatternCount(), newValue);
        }
    }

    public void removePattern(Pattern value) {
        int index = this.patternList.indexOf(value);
        if (index >= 0) {
            this.removePattern(index);
        }
    }

    public void removePattern(int index) {
        this.patternList.remove(index);
    }

    public Exp getWhere() {
        return this.where;
    }

    public void setWhere(Exp newValue) {
        if (this.where == null ? newValue != null : !this.where.equals(newValue)) {
            this.where = newValue;
        }
    }

    @Override
    public void writeToBoost(Boost boost) {
        super.writeToBoost(boost);
        BoostUtil.writeObjectCollection((Boost)boost, this.patternList);
        boost.writeObject((BoostObject)this.where);
    }

    @Override
    public void accept(ModelVisitor visitor) {
        visitor.visitReception(this);
    }
}

