/*
 * Decompiled with CFR 0.152.
 */
package obp.dot.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import obp.dot.Graph;
import obp.dot.parser.DotParser;
import org.xid.basics.error.ErrorHandler;

public class DotUtil {
    public static String dotExecutable = null;

    public static Graph loadDot(File dotfile) throws Exception {
        BufferedReader reader = new BufferedReader(new FileReader(dotfile));
        DotParser parser = new DotParser(reader, ErrorHandler.simple);
        parser.parse();
        return parser.getGraph();
    }

    public static Graph layoutDot(String dotDescription) throws Exception {
        File dotExecutableFile;
        if (dotExecutable != null && (dotExecutableFile = new File(dotExecutable)).exists() && dotExecutableFile.isFile() && dotExecutableFile.canExecute()) {
            Process process = null;
            try {
                process = Runtime.getRuntime().exec(new String[]{dotExecutable, "-Tdot"});
                final OutputStream outputStream = process.getOutputStream();
                final InputStream inputStream = process.getInputStream();
                final byte[] toWrite = dotDescription.getBytes();
                Thread pumperWrite = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            int size;
                            BufferedOutputStream output = new BufferedOutputStream(outputStream);
                            for (int offset = 0; offset < toWrite.length; offset += size) {
                                size = Math.min(toWrite.length - offset, 1024);
                                output.write(toWrite, offset, size);
                            }
                            output.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                });
                pumperWrite.start();
                final StringBuilder layouted = new StringBuilder();
                Thread pumperRead = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            BufferedInputStream input = new BufferedInputStream(inputStream);
                            byte[] buffer = new byte[1024];
                            int read = input.read(buffer);
                            while (read > -1) {
                                layouted.append(new String(buffer, 0, read));
                                read = input.read(buffer);
                            }
                            input.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                });
                pumperRead.start();
                pumperWrite.join();
                process.waitFor();
                pumperRead.join();
                dotDescription = layouted.toString();
            }
            catch (InterruptedException e) {
                if (process != null) {
                    process.destroy();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        StringReader reader = new StringReader(dotDescription);
        DotParser parser = new DotParser(reader, ErrorHandler.simple);
        parser.parse();
        reader.close();
        return parser.getGraph();
    }
}

