/*
 * Decompiled with CFR 0.152.
 */
package obp2.explorer;

import java.util.PriorityQueue;
import java.util.Queue;
import java.util.function.Function;
import obp2.algorithms.reachability.AbstractExplorer;
import obp2.core.IConfiguration;
import obp2.core.IStateSpaceManager;
import obp2.core.execution.IExecutionController;
import obp2.events.CloseConfigurationEvent;
import obp2.runtime.core.ITransitionRelation;
import obp2.statespace.PastFreezeStateSpaceManager;

public class PastFreezeExplorer<C extends IConfiguration, A>
extends AbstractExplorer<C, A> {
    protected final Function<C, Integer> clusterIndexGetter;
    protected final Queue<C> toSee = new PriorityQueue<C>(50, this::compareConfigurations);
    protected int currentClusterID = 0;
    protected int zappedConfigurations = 0;

    public PastFreezeExplorer(ITransitionRelation runtime, IStateSpaceManager stateSpaceManager, Function<C, Integer> clusterIndexGetter) {
        super(runtime, stateSpaceManager);
        this.clusterIndexGetter = clusterIndexGetter;
    }

    public boolean atEnd() {
        return this.toSee.isEmpty();
    }

    public C nextConfiguration() {
        return (C)((IConfiguration)this.toSee.remove());
    }

    public void schedule(C conf) {
        this.toSee.add(conf);
    }

    public void explorationStep() {
        C source = this.nextConfiguration();
        int clusterID = this.clusterIndexGetter.apply(source);
        if (this.currentClusterID != clusterID) {
            this.zappedConfigurations = (int)((long)this.zappedConfigurations + ((PastFreezeStateSpaceManager)this.stateSpaceManager).size(this.currentClusterID));
            ((PastFreezeStateSpaceManager)this.stateSpaceManager).clear(this.currentClusterID);
            this.currentClusterID = clusterID;
        }
        this.fire((IConfiguration)source);
        this.announcer.announce((Object)new CloseConfigurationEvent((IExecutionController)this, source));
    }

    int compareConfigurations(C o1, C o2) {
        return this.clusterIndexGetter.apply(o1) - this.clusterIndexGetter.apply(o2);
    }
}

