/*
 * Decompiled with CFR 0.152.
 */
package obp.transfo.cc;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Stack;
import obp.cc.ConcreteContext;
import obp.cc.State;
import obp.cc.Transition;
import obp.transfo.cc.ConcreteContextCache;

public class ConcreteContextTopological {
    List<State> order;
    ConcreteContextCache cache;
    public static final boolean DISPLAY_STATS = false;

    public static ConcreteContext orderCC(ConcreteContext cc) {
        ConcreteContextTopological ccT = new ConcreteContextTopological();
        return ccT.runOn(cc);
    }

    public ConcreteContext runOn(ConcreteContext cc) {
        this.order = new ArrayList<State>(cc.getStateCount());
        this.cache = new ConcreteContextCache(cc);
        this.bfs(cc.getStartState());
        ConcreteContext topologicalCC = new ConcreteContext();
        topologicalCC.setName(cc.getName());
        topologicalCC.setStartState(cc.getStartState());
        topologicalCC.setStopState(cc.getStopState());
        for (int i = 0; i < this.order.size(); ++i) {
            topologicalCC.addState(this.order.get(i));
        }
        topologicalCC.addAllTransition(cc.getTransitionList());
        topologicalCC.addAllObserver(cc.getObserverList());
        topologicalCC.addAllAssert(cc.getAssertList());
        topologicalCC.addAllBuchi(cc.getBuchiList());
        topologicalCC.setFoldingPredicate(cc.getFoldingPredicate());
        return topologicalCC;
    }

    public void bfs(State startState) {
        IdentityHashMap<State, StackMarker> closed = new IdentityHashMap<State, StackMarker>();
        PriorityQueue<StackMarker> open = new PriorityQueue<StackMarker>(11, new Comparator<StackMarker>(){

            @Override
            public int compare(StackMarker o1, StackMarker o2) {
                return o1.inIndex - o2.inIndex;
            }
        });
        StackMarker startSM = new StackMarker(startState, this.cache.getOutTransitions(startState).size(), this.cache.getInTransitions(startState).size());
        closed.put(startState, startSM);
        open.add(startSM);
        while (!open.isEmpty()) {
            StackMarker u = open.peek();
            assert (u.inIndex == 0);
            if (u.index <= 0) {
                open.poll();
                this.order.add(u.state);
                continue;
            }
            State v = this.cache.getOutTransitions(u.state).get(--u.index).getTarget();
            StackMarker vSM = (StackMarker)closed.get(v);
            if (vSM == null) {
                vSM = new StackMarker(v, this.cache.getOutTransitions(v).size(), this.cache.getInTransitions(v).size() - 1);
                closed.put(v, vSM);
                open.add(vSM);
                continue;
            }
            open.remove(vSM);
            --vSM.inIndex;
            open.add(vSM);
        }
    }

    public void dfs(State startState) {
        IdentityHashMap<State, Boolean> closed = new IdentityHashMap<State, Boolean>();
        Stack<StackMarker> open = new Stack<StackMarker>();
        closed.put(startState, true);
        open.push(new StackMarker(startState, this.cache.getOutTransitions(startState).size()));
        while (!open.isEmpty()) {
            StackMarker u = (StackMarker)open.peek();
            if (u.index <= 0) {
                open.pop();
                this.order.add(u.state);
                continue;
            }
            State v = this.cache.getOutTransitions(u.state).get(--u.index).getTarget();
            if (closed.get(v) != null) continue;
            closed.put(v, true);
            open.push(new StackMarker(v, this.cache.getOutTransitions(v).size()));
        }
    }

    @Deprecated
    public void recursiveDfs(State v, Map<State, StateColors> known) {
        if (known.get(v) == null) {
            known.put(v, StateColors.GRAY);
            for (Transition t : this.cache.getOutTransitions(v)) {
                this.recursiveDfs(t.getTarget(), known);
            }
            known.put(v, StateColors.BLACK);
            this.order.add(v);
        }
    }

    private static enum StateColors {
        GRAY,
        RED,
        BLACK;

    }

    private class StackMarker {
        public State state;
        public int inIndex;
        public int index;

        public StackMarker(State state, int index) {
            this.state = state;
            this.index = index;
        }

        public StackMarker(State state, int index, int inIndex) {
            this(state, index);
            this.inIndex = inIndex;
        }

        public String toString() {
            return this.state.toString() + "[" + this.inIndex + ", " + this.index + "]";
        }
    }
}

