/*
 * Decompiled with CFR 0.152.
 */
package obp.simulation.component;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextPane;
import obp.explorer.runtime.core.Transition;
import obp.simulation.listener.ListMouseListener;
import obp.simulation.listener.TransitionSelectionListener;
import obp.simulation.model.TransitionRenderer;
import obp.simulation.observer.TransitionObserver;

public class TransitionPanel
extends JPanel
implements TransitionObserver {
    private static final long serialVersionUID = 1821942553827744107L;
    private DefaultListModel<Transition> transitionListModel;
    private JList<Transition> transitionList;
    private JTextPane detail;

    public TransitionPanel() {
        this.setLayout(new BorderLayout());
        this.initMessagePanel();
    }

    public void initMessagePanel() {
        JPanel message = new JPanel();
        message.setLayout(new BorderLayout());
        message.setBorder(BorderFactory.createTitledBorder("< Transitions >"));
        this.transitionListModel = new DefaultListModel();
        this.transitionList = new JList<Transition>(this.transitionListModel);
        this.transitionList.setSelectionMode(0);
        message.add((Component)new JScrollPane(this.transitionList), "Center");
        JPanel detailPanel = new JPanel();
        detailPanel.setLayout(new BorderLayout());
        detailPanel.setBorder(BorderFactory.createTitledBorder("< Detail >"));
        this.detail = new JTextPane();
        this.detail.setEditable(false);
        detailPanel.add(new JScrollPane(this.detail));
        JSplitPane splitPane = new JSplitPane(0, message, detailPanel);
        splitPane.setAutoscrolls(true);
        splitPane.setDividerLocation(300);
        splitPane.setDividerSize(3);
        this.add(splitPane);
    }

    public String synchronisationType(short type) {
        switch (type) {
            case 1: {
                return "Input";
            }
            case 2: {
                return "Output";
            }
        }
        return "Unknow";
    }

    public String synchronisationChannel(short channel) {
        switch (channel) {
            case -1: {
                return "NoChannel";
            }
            case 0: {
                return "None";
            }
        }
        return Short.toString(channel);
    }

    public JList<Transition> getTransitionList() {
        return this.transitionList;
    }

    public void addListMouseListener(ListMouseListener ml) {
        this.transitionList.addMouseListener(ml);
    }

    public void addCellRenderer(TransitionRenderer cellRenderer) {
        this.transitionList.setCellRenderer(cellRenderer);
    }

    public void setDetail(String detail) {
        this.detail.setText(detail);
    }

    @Override
    public void update(List<Transition> newTransitions) {
        this.transitionListModel.removeAllElements();
        for (Transition trans : newTransitions) {
            this.transitionListModel.addElement(trans);
        }
    }

    public void addListSelectionListenner(TransitionSelectionListener transitionSelectionListener) {
        this.transitionList.addListSelectionListener(transitionSelectionListener);
    }
}

