/*
 * Decompiled with CFR 0.152.
 */
package obp.fiacre.util;

import obp.fiacre.model.AnyPattern;
import obp.fiacre.model.ArgumentVariable;
import obp.fiacre.model.Array;
import obp.fiacre.model.ArrayElem;
import obp.fiacre.model.ArrayPattern;
import obp.fiacre.model.BinExp;
import obp.fiacre.model.BoolLiteral;
import obp.fiacre.model.BoolType;
import obp.fiacre.model.CaseStmt;
import obp.fiacre.model.ChannelDecl;
import obp.fiacre.model.Commented;
import obp.fiacre.model.ComponentDecl;
import obp.fiacre.model.CondExp;
import obp.fiacre.model.ConstantDecl;
import obp.fiacre.model.ConstantRef;
import obp.fiacre.model.Constr;
import obp.fiacre.model.ConstrExp;
import obp.fiacre.model.ConstrPattern;
import obp.fiacre.model.Declaration;
import obp.fiacre.model.DeterministicAssignment;
import obp.fiacre.model.Emission;
import obp.fiacre.model.Exp;
import obp.fiacre.model.ExternalArgument;
import obp.fiacre.model.ExternalFunctionDecl;
import obp.fiacre.model.ExternalFunctionRef;
import obp.fiacre.model.Field;
import obp.fiacre.model.FieldPattern;
import obp.fiacre.model.FiniteBound;
import obp.fiacre.model.Foreach;
import obp.fiacre.model.FunctionDecl;
import obp.fiacre.model.FunctionRef;
import obp.fiacre.model.IfStmt;
import obp.fiacre.model.InfiniteBound;
import obp.fiacre.model.InlineArray;
import obp.fiacre.model.InlineQueue;
import obp.fiacre.model.InlineRecord;
import obp.fiacre.model.Instance;
import obp.fiacre.model.IntType;
import obp.fiacre.model.InterfacedComp;
import obp.fiacre.model.Interval;
import obp.fiacre.model.LocalPortDecl;
import obp.fiacre.model.LocalVariable;
import obp.fiacre.model.MaxBound;
import obp.fiacre.model.MinBound;
import obp.fiacre.model.ModelVisitor;
import obp.fiacre.model.NatLiteral;
import obp.fiacre.model.NatType;
import obp.fiacre.model.NonDeterministicAssignment;
import obp.fiacre.model.NullStmt;
import obp.fiacre.model.Par;
import obp.fiacre.model.ParamPortDecl;
import obp.fiacre.model.Pattern;
import obp.fiacre.model.PatternExp;
import obp.fiacre.model.PatternStmt;
import obp.fiacre.model.Priority;
import obp.fiacre.model.ProcessDecl;
import obp.fiacre.model.Profile;
import obp.fiacre.model.Program;
import obp.fiacre.model.Queue;
import obp.fiacre.model.Reception;
import obp.fiacre.model.Record;
import obp.fiacre.model.RecordElem;
import obp.fiacre.model.RefArg;
import obp.fiacre.model.ReturnStmt;
import obp.fiacre.model.Rule;
import obp.fiacre.model.Select;
import obp.fiacre.model.Seq;
import obp.fiacre.model.SingleAssignment;
import obp.fiacre.model.State;
import obp.fiacre.model.Statement;
import obp.fiacre.model.Synchronization;
import obp.fiacre.model.To;
import obp.fiacre.model.Transition;
import obp.fiacre.model.Type;
import obp.fiacre.model.TypeDecl;
import obp.fiacre.model.TypeId;
import obp.fiacre.model.UnExp;
import obp.fiacre.model.Union;
import obp.fiacre.model.ValuedField;
import obp.fiacre.model.VarRef;
import obp.fiacre.model.Wait;
import obp.fiacre.model.WhileStmt;

public class FiacrePrinter
implements ModelVisitor {
    private String separator = "\n";
    private String tabulation = "\t";
    private int currentLevel = 0;
    private StringBuilder program = null;

    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
        if (!separator.contains("\n")) {
            this.currentLevel = -1;
        }
    }

    public String getTabulation() {
        return this.tabulation;
    }

    public void setTabulation(String tabulation) {
        this.tabulation = tabulation;
    }

    public String print(Program toPrint) {
        this.program = new StringBuilder();
        if (toPrint != null) {
            toPrint.accept(this);
        }
        return this.program.toString();
    }

    public String print(ProcessDecl toPrint) {
        this.program = new StringBuilder();
        if (toPrint != null) {
            toPrint.accept(this);
        }
        return this.program.toString();
    }

    public String print(Declaration toPrint) {
        this.program = new StringBuilder();
        if (toPrint != null) {
            toPrint.accept(this);
        }
        return this.program.toString();
    }

    public String print(Exp toPrint) {
        this.program = new StringBuilder();
        if (toPrint != null) {
            toPrint.accept(this);
        }
        return this.program.toString();
    }

    public String print(Pattern toPrint) {
        this.program = new StringBuilder();
        if (toPrint != null) {
            toPrint.accept(this);
        }
        return this.program.toString();
    }

    public String print(Statement toPrint) {
        this.program = new StringBuilder();
        if (toPrint != null) {
            toPrint.accept(this);
        }
        return this.program.toString();
    }

    public String print(Type toPrint) {
        this.program = new StringBuilder();
        if (toPrint != null) {
            toPrint.accept(this);
        }
        return this.program.toString();
    }

    private void printComment(Commented statement) {
        for (String comment : statement.getCommentList()) {
            this.program.append("/*");
            this.program.append(comment);
            this.program.append("*/");
            this.printSeparator();
        }
    }

    private void printSeparator() {
        this.program.append(this.separator);
        for (int i = 0; i < this.currentLevel; ++i) {
            this.program.append(this.tabulation);
        }
    }

    private void levelUp() {
        if (this.currentLevel >= 0) {
            ++this.currentLevel;
        }
    }

    private void levelDown() {
        if (this.currentLevel > 0) {
            --this.currentLevel;
        }
    }

    @Override
    public void visitProgram(Program toVisit) {
        for (Declaration decl : toVisit.getDeclarationList()) {
            decl.accept(this);
            this.printSeparator();
        }
        if (toVisit.getRoot() != null) {
            this.printSeparator();
            this.program.append(toVisit.getRoot().getName());
            this.printSeparator();
        }
    }

    @Override
    public void visitTypeDecl(TypeDecl toVisit) {
        this.program.append("type ");
        this.program.append(toVisit.getName());
        this.program.append(" is ");
        toVisit.getIs().accept(this);
        this.printSeparator();
    }

    @Override
    public void visitChannelDecl(ChannelDecl toVisit) {
        this.program.append("chanel ");
        this.program.append(toVisit.getName());
        this.program.append(" is ");
        toVisit.getIs().accept(this);
        this.printSeparator();
    }

    @Override
    public void visitComponentDecl(ComponentDecl toVisit) {
        int i;
        this.program.append("component ");
        this.program.append(toVisit.getName());
        this.program.append(" ");
        if (toVisit.getPortCount() > 0) {
            this.program.append("[");
            for (i = 0; i < toVisit.getPortCount(); ++i) {
                if (i > 0) {
                    this.program.append(", ");
                }
                toVisit.getPort(i).accept(this);
            }
            this.program.append("] ");
        }
        if (toVisit.getArgCount() > 0) {
            this.program.append("(");
            for (i = 0; i < toVisit.getArgCount(); ++i) {
                if (i > 0) {
                    this.program.append(", ");
                }
                toVisit.getArg(i).accept(this);
            }
            this.program.append(") ");
        }
        this.program.append("is");
        if (toVisit.getVarCount() > 0) {
            this.printSeparator();
            this.program.append("var ");
            this.levelUp();
            for (i = 0; i < toVisit.getVarCount(); ++i) {
                if (i > 0) {
                    this.program.append(", ");
                }
                this.printSeparator();
                toVisit.getVar(i).accept(this);
            }
            this.levelDown();
            this.printSeparator();
        }
        if (toVisit.getLocalPortCount() > 0) {
            this.printSeparator();
            this.program.append("port ");
            this.levelUp();
            for (i = 0; i < toVisit.getLocalPortCount(); ++i) {
                if (i > 0) {
                    this.program.append(", ");
                }
                this.printSeparator();
                toVisit.getLocalPort(i).accept(this);
            }
            this.levelDown();
            this.printSeparator();
        }
        if (toVisit.getPriorityCount() > 0) {
            this.printSeparator();
            this.program.append("priority ");
            for (i = 0; i < toVisit.getPriorityCount(); ++i) {
                if (i > 0) {
                    this.program.append(", ");
                }
                toVisit.getPriority(i).accept(this);
            }
            this.program.append(" ");
        }
        if (toVisit.getInitAction() != null) {
            this.printSeparator();
            this.program.append("init ");
            toVisit.getInitAction().accept(this);
        }
        this.printSeparator();
        toVisit.getBody().accept(this);
        this.printSeparator();
    }

    @Override
    public void visitProcessDecl(ProcessDecl toVisit) {
        int i;
        this.program.append("process ");
        this.program.append(toVisit.getName());
        this.program.append(" ");
        if (toVisit.getPortCount() > 0) {
            this.program.append("[");
            for (i = 0; i < toVisit.getPortCount(); ++i) {
                if (i > 0) {
                    this.program.append(", ");
                }
                toVisit.getPort(i).accept(this);
            }
            this.program.append("] ");
        }
        if (toVisit.getArgCount() > 0) {
            this.program.append("(");
            for (i = 0; i < toVisit.getArgCount(); ++i) {
                if (i > 0) {
                    this.program.append(", ");
                }
                toVisit.getArg(i).accept(this);
            }
            this.program.append(") ");
        }
        this.program.append("is");
        this.printSeparator();
        this.program.append("states ");
        for (i = 0; i < toVisit.getStateCount(); ++i) {
            if (i > 0) {
                this.program.append(", ");
            }
            toVisit.getState(i).accept(this);
        }
        this.printSeparator();
        if (toVisit.getVarCount() > 0) {
            this.program.append("var ");
            this.levelUp();
            for (i = 0; i < toVisit.getVarCount(); ++i) {
                if (i > 0) {
                    this.program.append(", ");
                }
                toVisit.getVar(i).accept(this);
            }
            this.levelDown();
            this.program.append(" ");
        }
        if (toVisit.getInitAction() != null) {
            this.printSeparator();
            this.program.append("init ");
            toVisit.getInitAction().accept(this);
        }
        this.printSeparator();
        this.printSeparator();
        for (i = 0; i < toVisit.getTransitionCount(); ++i) {
            toVisit.getTransition(i).accept(this);
            this.printSeparator();
            this.printSeparator();
        }
    }

    @Override
    public void visitFunctionDecl(FunctionDecl toVisit) {
        int i;
        this.program.append("function ");
        this.program.append(toVisit.getName());
        this.program.append(" ");
        if (toVisit.getArgCount() > 0) {
            this.program.append("(");
            for (i = 0; i < toVisit.getArgCount(); ++i) {
                if (i > 0) {
                    this.program.append(", ");
                }
                toVisit.getArg(i).accept(this);
            }
            this.program.append(") ");
        }
        this.program.append(": ");
        toVisit.getReturnType().accept(this);
        this.program.append(" is");
        this.printSeparator();
        if (toVisit.getVarCount() > 0) {
            this.program.append("var ");
            for (i = 0; i < toVisit.getVarCount(); ++i) {
                if (i > 0) {
                    this.program.append(", ");
                }
                toVisit.getVar(i).accept(this);
            }
            this.program.append(" ");
            this.printSeparator();
        }
        this.program.append("begin");
        this.printSeparator();
        toVisit.getBody().accept(this);
        this.printSeparator();
        this.program.append("end");
    }

    @Override
    public void visitArgumentVariable(ArgumentVariable toVisit) {
        if (toVisit.isRef()) {
            this.program.append("&");
        }
        this.program.append(toVisit.getName());
        this.program.append(": ");
        if (toVisit.isRef()) {
            if (toVisit.isRead() && !toVisit.isWrite()) {
                this.program.append("read ");
            }
            if (toVisit.isWrite() && !toVisit.isRead()) {
                this.program.append("write ");
            }
        }
        toVisit.getType().accept(this);
    }

    @Override
    public void visitLocalVariable(LocalVariable toVisit) {
        this.printSeparator();
        this.printComment(toVisit);
        this.program.append(toVisit.getName());
        this.program.append(": ");
        if (toVisit.getType() == null) {
            this.program.append("none");
            return;
        }
        toVisit.getType().accept(this);
        if (toVisit.getInitializer() != null) {
            this.program.append(" := ");
            toVisit.getInitializer().accept(this);
        }
    }

    @Override
    public void visitPar(Par toVisit) {
        this.program.append("par ");
        this.levelUp();
        for (int i = 0; i < toVisit.getArgCount(); ++i) {
            this.printSeparator();
            if (i > 0) {
                this.program.append(" || ");
            }
            toVisit.getArg(i).accept(this);
        }
        this.levelDown();
        this.printSeparator();
        this.program.append("end par");
    }

    @Override
    public void visitInstance(Instance toVisit) {
        int i;
        this.program.append(toVisit.getType().getName());
        if (toVisit.getPortCount() > 0) {
            this.program.append("[");
            for (i = 0; i < toVisit.getPortCount(); ++i) {
                if (i > 0) {
                    this.program.append(", ");
                }
                this.program.append(toVisit.getPort(i).getName());
            }
            this.program.append("] ");
        }
        if (toVisit.getArgCount() > 0) {
            this.program.append("(");
            for (i = 0; i < toVisit.getArgCount(); ++i) {
                if (i > 0) {
                    this.program.append(", ");
                }
                toVisit.getArg(i).accept(this);
            }
            this.program.append(") ");
        }
    }

    @Override
    public void visitInterfacedComp(InterfacedComp toVisit) {
        if (toVisit.getSyncPortCount() > 0) {
            for (int i = 0; i < toVisit.getSyncPortCount(); ++i) {
                if (i > 0) {
                    this.program.append(", ");
                }
                this.program.append(toVisit.getSyncPort(i).getName());
            }
            this.program.append(" -> ");
        }
        toVisit.getComposition().accept(this);
    }

    @Override
    public void visitState(State toVisit) {
        this.program.append(toVisit.getName());
    }

    @Override
    public void visitTransition(Transition toVisit) {
        this.program.append("from ");
        this.program.append(toVisit.getFrom().getName());
        this.levelUp();
        this.printSeparator();
        toVisit.getAction().accept(this);
        this.levelDown();
    }

    @Override
    public void visitNullStmt(NullStmt toVisit) {
        this.printComment(toVisit);
        this.program.append("null");
    }

    @Override
    public void visitWhileStmt(WhileStmt toVisit) {
        this.printComment(toVisit);
        this.program.append("while ");
        toVisit.getCondition().accept(this);
        this.program.append(" do");
        this.levelUp();
        this.printSeparator();
        toVisit.getBody().accept(this);
        this.printSeparator();
        this.levelDown();
        this.program.append("end while");
    }

    @Override
    public void visitIfStmt(IfStmt toVisit) {
        this.printComment(toVisit);
        this.program.append("if ");
        toVisit.getCondition().accept(this);
        this.program.append(" then");
        this.levelUp();
        this.printSeparator();
        toVisit.getThen().accept(this);
        this.levelDown();
        this.printSeparator();
        if (toVisit.getElse() != null && !(toVisit.getElse() instanceof NullStmt)) {
            this.levelUp();
            this.program.append("else ");
            this.printSeparator();
            toVisit.getElse().accept(this);
            this.levelDown();
            this.printSeparator();
        }
        this.program.append("end if");
    }

    @Override
    public void visitSelect(Select toVisit) {
        this.printComment(toVisit);
        this.program.append("select");
        this.levelUp();
        this.printSeparator();
        for (int i = 0; i < toVisit.getStatementCount(); ++i) {
            if (i > 0) {
                this.program.append("[]");
                this.levelUp();
                this.printSeparator();
            }
            toVisit.getStatement(i).accept(this);
            this.levelDown();
            this.printSeparator();
        }
        this.program.append("end select");
    }

    @Override
    public void visitTo(To toVisit) {
        this.printComment(toVisit);
        this.program.append("to ");
        this.program.append(toVisit.getDest().getName());
    }

    @Override
    public void visitWait(Wait toVisit) {
        this.printComment(toVisit);
        this.program.append("wait ");
        this.visitMinBound(toVisit.getMini());
        this.program.append(", ");
        this.visitMaxBound(toVisit.getMaxi());
    }

    @Override
    public void visitReturnStmt(ReturnStmt toVisit) {
        this.printComment(toVisit);
        this.program.append("return ");
        toVisit.getExpression().accept(this);
    }

    @Override
    public void visitDeterministicAssignment(DeterministicAssignment toVisit) {
        this.printComment(toVisit);
        for (int i = 0; i < toVisit.getAssignmentCount(); ++i) {
            if (i > 0) {
                this.program.append(";");
                this.printSeparator();
            }
            toVisit.getAssignment(i).accept(this);
        }
    }

    @Override
    public void visitNonDeterministicAssignment(NonDeterministicAssignment toVisit) {
        this.printComment(toVisit);
        for (int i = 0; i < toVisit.getLhsCount(); ++i) {
            if (i > 0) {
                this.program.append(", ");
            }
            toVisit.getLhs(i).accept(this);
        }
        this.program.append(" := any");
        if (toVisit.getCondition() != null) {
            this.program.append(" ");
            toVisit.getCondition().accept(this);
        }
    }

    @Override
    public void visitSingleAssignment(SingleAssignment toVisit) {
        toVisit.getLhs().accept(this);
        this.program.append(" := ");
        toVisit.getRhs().accept(this);
    }

    @Override
    public void visitUnExp(UnExp toVisit) {
        this.program.append("(");
        switch (toVisit.getUnop()) {
            case UMINUS: {
                this.program.append("-");
                break;
            }
            case UDOLLAR: {
                this.program.append("$");
                break;
            }
            case FIRST: {
                this.program.append("first");
                break;
            }
            case DEQUEUE: {
                this.program.append("dequeue");
                break;
            }
            case UEMPTY: {
                this.program.append("empty");
                break;
            }
            case UFULL: {
                this.program.append("full");
                break;
            }
            case LENGTH: {
                this.program.append("length");
                break;
            }
            case UNOT: {
                this.program.append("not");
            }
        }
        this.program.append(" ");
        toVisit.getExp().accept(this);
        this.program.append(")");
    }

    @Override
    public void visitBinExp(BinExp toVisit) {
        this.program.append("(");
        switch (toVisit.getBinOp()) {
            case APPEND: {
                this.program.append("append(");
                toVisit.getLeft().accept(this);
                this.program.append(", ");
                toVisit.getRight().accept(this);
                this.program.append(")");
                break;
            }
            case ENQUEUE: {
                this.program.append("enqueue(");
                toVisit.getLeft().accept(this);
                this.program.append(", ");
                toVisit.getRight().accept(this);
                this.program.append(")");
                break;
            }
            case BADD: {
                toVisit.getLeft().accept(this);
                this.program.append(" + ");
                toVisit.getRight().accept(this);
                break;
            }
            case BAND: {
                toVisit.getLeft().accept(this);
                this.program.append(" and ");
                toVisit.getRight().accept(this);
                break;
            }
            case BDIV: {
                toVisit.getLeft().accept(this);
                this.program.append(" / ");
                toVisit.getRight().accept(this);
                break;
            }
            case BEQ: {
                toVisit.getLeft().accept(this);
                this.program.append(" = ");
                toVisit.getRight().accept(this);
                break;
            }
            case BGE: {
                toVisit.getLeft().accept(this);
                this.program.append(" >= ");
                toVisit.getRight().accept(this);
                break;
            }
            case BGT: {
                toVisit.getLeft().accept(this);
                this.program.append(" > ");
                toVisit.getRight().accept(this);
                break;
            }
            case BLE: {
                toVisit.getLeft().accept(this);
                this.program.append(" <= ");
                toVisit.getRight().accept(this);
                break;
            }
            case BLT: {
                toVisit.getLeft().accept(this);
                this.program.append(" < ");
                toVisit.getRight().accept(this);
                break;
            }
            case BMINUS: {
                toVisit.getLeft().accept(this);
                this.program.append(" - ");
                toVisit.getRight().accept(this);
                break;
            }
            case BMOD: {
                toVisit.getLeft().accept(this);
                this.program.append(" % ");
                toVisit.getRight().accept(this);
                break;
            }
            case BMUL: {
                toVisit.getLeft().accept(this);
                this.program.append(" * ");
                toVisit.getRight().accept(this);
                break;
            }
            case BNE: {
                toVisit.getLeft().accept(this);
                this.program.append(" <> ");
                toVisit.getRight().accept(this);
                break;
            }
            case BOR: {
                toVisit.getLeft().accept(this);
                this.program.append(" or ");
                toVisit.getRight().accept(this);
            }
        }
        this.program.append(")");
    }

    @Override
    public void visitNatLiteral(NatLiteral toVisit) {
        this.program.append(toVisit.getValue());
    }

    @Override
    public void visitBoolLiteral(BoolLiteral toVisit) {
        this.program.append(toVisit.isValue());
    }

    @Override
    public void visitVarRef(VarRef toVisit) {
        this.program.append(toVisit.getDecl().getName());
    }

    @Override
    public void visitArrayElem(ArrayElem toVisit) {
        toVisit.getArray().accept(this);
        this.program.append("[");
        toVisit.getIndex().accept(this);
        this.program.append("]");
    }

    @Override
    public void visitRecordElem(RecordElem toVisit) {
        toVisit.getRecord().accept(this);
        this.program.append(".");
        this.program.append(toVisit.getField());
    }

    @Override
    public void visitInlineQueue(InlineQueue toVisit) {
        this.program.append("{|");
        for (int i = 0; i < toVisit.getElemCount(); ++i) {
            if (i > 0) {
                this.program.append(", ");
            }
            toVisit.getElem(i).accept(this);
        }
        this.program.append("|}");
    }

    @Override
    public void visitBoolType(BoolType toVisit) {
        this.program.append("bool");
    }

    @Override
    public void visitNatType(NatType toVisit) {
        this.program.append("nat");
    }

    @Override
    public void visitIntType(IntType toVisit) {
        this.program.append("int");
    }

    @Override
    public void visitInterval(Interval toVisit) {
        toVisit.getMini().accept(this);
        this.program.append("..");
        toVisit.getMaxi().accept(this);
    }

    @Override
    public void visitFiniteBound(FiniteBound toVisit) {
    }

    @Override
    public void visitInfiniteBound(InfiniteBound toVisit) {
    }

    @Override
    public void visitRecord(Record toVisit) {
        this.program.append("record ");
        this.levelUp();
        int fieldCount = toVisit.getFieldCount();
        for (int i = 0; i < fieldCount; ++i) {
            this.printSeparator();
            toVisit.getField(i).accept(this);
            if (i >= fieldCount - 1) continue;
            this.program.append(",");
        }
        this.levelDown();
        this.printSeparator();
        this.program.append("end record");
    }

    @Override
    public void visitField(Field toVisit) {
        this.program.append(toVisit.getName());
        this.program.append(": ");
        toVisit.getType().accept(this);
    }

    @Override
    public void visitArray(Array toVisit) {
        this.program.append("array ");
        toVisit.getSize().accept(this);
        this.program.append(" of ");
        toVisit.getType().accept(this);
    }

    @Override
    public void visitQueue(Queue toVisit) {
        this.program.append("queue ");
        toVisit.getSize().accept(this);
        this.program.append(" of ");
        if (toVisit.getType() == null) {
            this.program.append("none");
        } else {
            toVisit.getType().accept(this);
        }
    }

    @Override
    public void visitTypeId(TypeId toVisit) {
        this.program.append(toVisit.getDecl().getName());
    }

    @Override
    public void visitProfile(Profile toVisit) {
        if (toVisit.getTypeCount() > 0) {
            for (int i = 0; i < toVisit.getTypeCount(); ++i) {
                if (i > 0) {
                    this.program.append(" # ");
                }
                toVisit.getType(i).accept(this);
            }
        } else {
            this.program.append("none");
        }
    }

    @Override
    public void visitInlineArray(InlineArray toVisit) {
        this.program.append("[");
        for (int i = 0; i < toVisit.getElemCount(); ++i) {
            if (i > 0) {
                this.program.append(", ");
            }
            toVisit.getElem(i).accept(this);
        }
        this.program.append("]");
    }

    @Override
    public void visitInlineRecord(InlineRecord toVisit) {
        this.program.append("{");
        for (int i = 0; i < toVisit.getValueCount(); ++i) {
            if (i > 0) {
                this.program.append(", ");
            }
            toVisit.getValue(i).accept(this);
        }
        this.program.append("}");
    }

    @Override
    public void visitValuedField(ValuedField toVisit) {
        this.program.append(toVisit.getField());
        this.program.append(" = ");
        toVisit.getValue().accept(this);
    }

    @Override
    public void visitSynchronization(Synchronization toVisit) {
        this.printComment(toVisit);
        this.program.append(toVisit.getPort().getName());
    }

    @Override
    public void visitReception(Reception toVisit) {
        this.printComment(toVisit);
        this.program.append(toVisit.getPort().getName());
        for (int i = 0; i < toVisit.getPatternCount(); ++i) {
            if (i <= 0) {
                this.program.append("? ");
            } else {
                this.program.append(", ");
            }
            toVisit.getPattern(i).accept(this);
        }
        if (toVisit.getWhere() != null) {
            this.program.append(" where");
            toVisit.getWhere().accept(this);
        }
    }

    @Override
    public void visitEmission(Emission toVisit) {
        this.printComment(toVisit);
        this.program.append(toVisit.getPort().getName());
        for (int i = 0; i < toVisit.getArgCount(); ++i) {
            if (i <= 0) {
                this.program.append("! ");
            } else {
                this.program.append(", ");
            }
            toVisit.getArg(i).accept(this);
        }
    }

    @Override
    public void visitSeq(Seq toVisit) {
        this.printComment(toVisit);
        if (toVisit.getStatementCount() == 0) {
            this.program.append("null");
            return;
        }
        for (int i = 0; i < toVisit.getStatementCount(); ++i) {
            if (i > 0) {
                this.program.append(";");
                this.printSeparator();
            }
            toVisit.getStatement(i).accept(this);
        }
    }

    @Override
    public void visitLocalPortDecl(LocalPortDecl toVisit) {
        this.program.append(toVisit.getName());
        this.program.append(": ");
        if (toVisit.isIn()) {
            this.program.append("in ");
        }
        if (toVisit.isOut()) {
            this.program.append("out ");
        }
        toVisit.getChannel().accept(this);
        if (this.needToPrintBounds(toVisit.getMini(), toVisit.getMaxi())) {
            this.program.append(" in ");
            this.visitMinBound(toVisit.getMini());
            this.program.append(",");
            this.visitMaxBound(toVisit.getMaxi());
        }
    }

    private boolean needToPrintBounds(MinBound min, MaxBound max) {
        if (min == null || max == null) {
            return false;
        }
        if (min instanceof FiniteBound && max instanceof InfiniteBound) {
            FiniteBound finiteMin = (FiniteBound)min;
            return !finiteMin.isStrict() || (float)finiteMin.getVal() != 0.0f;
        }
        return true;
    }

    private void visitMinBound(MinBound bound) {
        if (bound instanceof FiniteBound) {
            FiniteBound finiteBound = (FiniteBound)bound;
            this.program.append(finiteBound.isStrict() ? "]" : "[");
            this.program.append(finiteBound.getVal());
        }
    }

    private void visitMaxBound(MaxBound bound) {
        if (bound instanceof FiniteBound) {
            FiniteBound finiteBound = (FiniteBound)bound;
            this.program.append(finiteBound.getVal());
            this.program.append(finiteBound.isStrict() ? "[" : "]");
        }
        if (bound instanceof InfiniteBound) {
            this.program.append("...");
        }
    }

    @Override
    public void visitParamPortDecl(ParamPortDecl toVisit) {
        this.program.append(toVisit.getName());
        this.program.append(": ");
        if (toVisit.isIn()) {
            this.program.append("in ");
        }
        if (toVisit.isOut()) {
            this.program.append("out ");
        }
        toVisit.getChannel().accept(this);
    }

    @Override
    public void visitPriority(Priority toVisit) {
        int i;
        for (i = 0; i < toVisit.getSupCount(); ++i) {
            if (i > 0) {
                this.program.append(", ");
            }
            this.program.append(toVisit.getSup(i).getName());
        }
        this.program.append(" > ");
        for (i = 0; i < toVisit.getInfCount(); ++i) {
            if (i > 0) {
                this.program.append(", ");
            }
            this.program.append(toVisit.getInf(i).getName());
        }
    }

    @Override
    public void visitConstrExp(ConstrExp toVisit) {
        this.program.append(toVisit.getName());
        if (toVisit.getArg() != null) {
            this.program.append(" (");
            toVisit.getArg().accept(this);
            this.program.append(")");
        }
    }

    @Override
    public void visitFunctionRef(FunctionRef toVisit) {
        this.program.append("(");
        this.program.append(toVisit.getDecl().getName());
        this.program.append("(");
        int length = this.program.length();
        for (Exp param : toVisit.getParamList()) {
            if (this.program.length() > length) {
                this.program.append(", ");
            }
            param.accept(this);
        }
        this.program.append(")");
        this.program.append(")");
    }

    @Override
    public void visitUnion(Union toVisit) {
        this.program.append("union\n\t");
        for (int i = 0; i < toVisit.getConstrCount(); ++i) {
            if (i > 0) {
                this.program.append("\n\t| ");
            }
            toVisit.getConstr(i).accept(this);
        }
        this.program.append("\nend union");
    }

    @Override
    public void visitConstrPattern(ConstrPattern toVisit) {
        this.program.append(toVisit.getName());
        if (toVisit.getArg() != null) {
            this.program.append(" (");
            toVisit.getArg().accept(this);
            this.program.append(")");
        }
    }

    @Override
    public void visitArrayPattern(ArrayPattern toVisit) {
        toVisit.getArray().accept(this);
        this.program.append("[");
        toVisit.getIndex().accept(this);
        this.program.append("]");
    }

    @Override
    public void visitFieldPattern(FieldPattern toVisit) {
        toVisit.getRecord().accept(this);
        this.program.append(".");
        this.program.append(toVisit.getField());
    }

    @Override
    public void visitAnyPattern(AnyPattern toVisit) {
        this.program.append("any");
    }

    @Override
    public void visitCaseStmt(CaseStmt toVisit) {
        this.printComment(toVisit);
        this.program.append("case ");
        toVisit.getExp().accept(this);
        this.program.append(" of");
        this.printSeparator();
        for (int i = 0; i < toVisit.getRuleCount(); ++i) {
            if (i > 0) {
                this.program.append("| ");
            }
            this.levelUp();
            toVisit.getRule(i).accept(this);
            this.levelDown();
            this.printSeparator();
        }
        this.program.append("end case");
    }

    @Override
    public void visitRule(Rule toVisit) {
        toVisit.getLhs().accept(this);
        this.program.append(" -> ");
        toVisit.getAction().accept(this);
    }

    @Override
    public void visitRefArg(RefArg toVisit) {
        this.program.append("&");
        this.program.append(toVisit.getRef().getName());
    }

    @Override
    public void visitConstantDecl(ConstantDecl toVisit) {
        this.program.append("const ");
        this.program.append(toVisit.getName());
        this.program.append(": ");
        toVisit.getType().accept(this);
        this.program.append(" is ");
        toVisit.getValue().accept(this);
    }

    @Override
    public void visitConstantRef(ConstantRef toVisit) {
        this.program.append(toVisit.getDecl().getName());
    }

    @Override
    public void visitConstr(Constr toVisit) {
        this.program.append(toVisit.getName());
        if (toVisit.getType() != null) {
            this.program.append(" of ");
            toVisit.getType().accept(this);
        }
    }

    @Override
    public void visitCondExp(CondExp toVisit) {
        toVisit.getCond().accept(this);
        this.program.append(" ? ");
        toVisit.getIft().accept(this);
        this.program.append(" : ");
        toVisit.getIff().accept(this);
    }

    @Override
    public void visitForeach(Foreach toVisit) {
        this.printComment(toVisit);
        this.program.append("foreach ");
        this.program.append(toVisit.getIter().getName());
        this.program.append(" do");
        this.levelUp();
        this.printSeparator();
        toVisit.getBody().accept(this);
        this.levelDown();
        this.printSeparator();
        this.program.append("end foreach");
    }

    @Override
    public void visitPatternExp(PatternExp toVisit) {
        throw new IllegalArgumentException("PatternExp is an internal representation, can't be printed.");
    }

    @Override
    public void visitPatternStmt(PatternStmt toVisit) {
        throw new IllegalArgumentException("PatternStmt is an internal representation, can't be printed.");
    }

    public static String toString(Program toPrint) {
        return new FiacrePrinter().print(toPrint);
    }

    public static String toString(ProcessDecl toPrint) {
        return new FiacrePrinter().print(toPrint);
    }

    public static String toString(Statement toPrint) {
        return new FiacrePrinter().print(toPrint);
    }

    public static String toString(Exp toPrint) {
        return new FiacrePrinter().print(toPrint);
    }

    public static String toString(Pattern toPrint) {
        return new FiacrePrinter().print(toPrint);
    }

    public static String toString(Type toPrint) {
        return new FiacrePrinter().print(toPrint);
    }

    @Override
    public void visitExternalFunctionDecl(ExternalFunctionDecl toVisit) {
        this.program.append("extern ");
        this.program.append(toVisit.getName());
        this.program.append(" ");
        if (toVisit.getArgCount() > 0) {
            this.program.append("(");
            for (int i = 0; i < toVisit.getArgCount(); ++i) {
                if (i > 0) {
                    this.program.append(", ");
                }
                toVisit.getArg(i).accept(this);
            }
            this.program.append(") ");
        }
        this.program.append(": ");
        toVisit.getReturnType().accept(this);
        this.program.append(" is ");
        this.program.append(toVisit.getExternalName());
        this.printSeparator();
    }

    @Override
    public void visitExternalArgument(ExternalArgument toVisit) {
        if (toVisit.isRead()) {
            this.program.append("read ");
        }
        if (toVisit.isWrite()) {
            this.program.append("write ");
        }
        toVisit.getType().accept(this);
    }

    @Override
    public void visitExternalFunctionRef(ExternalFunctionRef toVisit) {
        this.program.append(toVisit.getDecl().getName());
        this.program.append("(");
        int length = this.program.length();
        for (Exp param : toVisit.getParamList()) {
            if (this.program.length() > length) {
                this.program.append(", ");
            }
            param.accept(this);
        }
        this.program.append(")");
    }
}

