/*
 * Decompiled with CFR 0.152.
 */
package obp.explorer.runtime.obs;

import obp.explorer.runtime.Configuration;
import obp.explorer.runtime.evaluator.Tester;
import obp.explorer.runtime.matcher.Matcher;
import obp.explorer.runtime.obs.AtomicAction;

public abstract class EventWatcher {
    public final short id;

    public EventWatcher(short id) {
        this.id = id;
    }

    public boolean watch(Configuration source, Configuration target) {
        return false;
    }

    public boolean watch(AtomicAction action) {
        return false;
    }

    public static class Action
    extends EventWatcher {
        private final Matcher matcher;

        public Action(short id, Matcher matcher) {
            super(id);
            this.matcher = matcher;
        }

        @Override
        public boolean watch(AtomicAction action) {
            return this.matcher.match(action);
        }

        public String toString() {
            return this.id + " -> A," + this.matcher;
        }
    }

    public static class Predicate
    extends EventWatcher {
        private final Tester predicate;

        public Predicate(short id, Tester predicate) {
            super(id);
            this.predicate = predicate;
        }

        @Override
        public boolean watch(Configuration source, Configuration target) {
            if (this.predicate.test(source)) {
                return false;
            }
            return this.predicate.test(target);
        }

        public String toString() {
            return this.id + " -> P," + this.predicate;
        }
    }
}

