/*
 * Decompiled with CFR 0.152.
 */
package obp.dot;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import obp.dot.DotVisitor;
import obp.dot.Edge;
import obp.dot.Node;
import org.xid.basics.model.ChangeRecorder;
import org.xid.basics.model.ModelObject;
import org.xid.basics.serializer.Boost;
import org.xid.basics.serializer.BoostObject;
import org.xid.basics.serializer.BoostUtil;

public class Graph
implements ModelObject,
BoostObject {
    private boolean directed;
    private float dpi = 72.0f;
    private final List<Node> nodeList = new ArrayList<Node>();
    private final List<Edge> edgeList = new ArrayList<Edge>();

    public Graph() {
    }

    protected Graph(Boost boost) {
        boost.register((BoostObject)this);
        this.directed = boost.readBoolean();
        this.dpi = boost.readFloat();
        for (Object oneChild : BoostUtil.readObjectList((Boost)boost, Node.class)) {
            this.nodeList.add((Node)oneChild);
        }
        for (Object oneChild : BoostUtil.readObjectList((Boost)boost, Edge.class)) {
            this.edgeList.add((Edge)oneChild);
        }
    }

    public boolean isDirected() {
        return this.directed;
    }

    public void setDirected(boolean directed) {
        if (this.directed != directed) {
            this.getChangeRecorder().recordChangeAttribute((ModelObject)this, "directed", (Object)this.directed);
            this.directed = directed;
        }
    }

    public float getDpi() {
        return this.dpi;
    }

    public void setDpi(float dpi) {
        if (this.dpi != dpi) {
            this.getChangeRecorder().recordChangeAttribute((ModelObject)this, "dpi", (Object)Float.valueOf(this.dpi));
            this.dpi = dpi;
        }
    }

    public List<Node> getNodeList() {
        return Collections.unmodifiableList(this.nodeList);
    }

    public int getNodeCount() {
        return this.nodeList.size();
    }

    public Node getNode(int index) {
        if (index < 0 || index >= this.getNodeCount()) {
            return null;
        }
        return this.nodeList.get(index);
    }

    public void addNode(Node newValue) {
        this.addNode(this.getNodeCount(), newValue);
    }

    public void addNode(int index, Node newValue) {
        this.getChangeRecorder().recordAddObject((ModelObject)this, "node", index);
        this.nodeList.add(index, newValue);
    }

    public void removeNode(Node value) {
        int index = this.nodeList.indexOf(value);
        if (index >= 0) {
            this.removeNode(index);
        }
    }

    public void removeNode(int index) {
        Node oldValue = this.nodeList.get(index);
        this.getChangeRecorder().recordRemoveObject((ModelObject)this, "node", index, (Object)oldValue);
        this.nodeList.remove(index);
    }

    public List<Edge> getEdgeList() {
        return Collections.unmodifiableList(this.edgeList);
    }

    public int getEdgeCount() {
        return this.edgeList.size();
    }

    public Edge getEdge(int index) {
        if (index < 0 || index >= this.getEdgeCount()) {
            return null;
        }
        return this.edgeList.get(index);
    }

    public void addEdge(Edge newValue) {
        this.addEdge(this.getEdgeCount(), newValue);
    }

    public void addEdge(int index, Edge newValue) {
        this.getChangeRecorder().recordAddObject((ModelObject)this, "edge", index);
        this.edgeList.add(index, newValue);
    }

    public void removeEdge(Edge value) {
        int index = this.edgeList.indexOf(value);
        if (index >= 0) {
            this.removeEdge(index);
        }
    }

    public void removeEdge(int index) {
        Edge oldValue = this.edgeList.get(index);
        this.getChangeRecorder().recordRemoveObject((ModelObject)this, "edge", index, (Object)oldValue);
        this.edgeList.remove(index);
    }

    public void writeToBoost(Boost boost) {
        boost.writeBoolean(this.directed);
        boost.writeFloat(this.dpi);
        BoostUtil.writeObjectCollection((Boost)boost, this.nodeList);
        BoostUtil.writeObjectCollection((Boost)boost, this.edgeList);
    }

    public void accept(DotVisitor visitor) {
        visitor.visit(this);
    }

    public ChangeRecorder getChangeRecorder() {
        return ChangeRecorder.Stub;
    }
}

