/*
 * Decompiled with CFR 0.152.
 */
package obp.ui.sequence;

import obp.ui.sequence.HorizontalLine;
import org.xid.basics.geometry.Geometry;
import org.xid.basics.ui.diagram.DiagramContext;
import org.xid.basics.ui.diagram.Displayable;
import org.xid.basics.ui.diagram.Element;
import org.xid.basics.ui.diagram.gc.GC;
import org.xid.basics.ui.diagram.gc.GcUtils;

public class HorizontalLineElement
extends Element.Stub {
    private float[] sourcePoint;
    private float[] targetPoint;
    private HorizontalLine hline;
    private float[] rectangle;

    public HorizontalLineElement(HorizontalLine hline, float[] sourcePoint, float[] targetPoint) {
        this.hline = hline;
        this.sourcePoint = sourcePoint;
        this.targetPoint = targetPoint;
        this.updateRectangle();
    }

    public HorizontalLine getModel() {
        return this.hline;
    }

    public float[] getPoint() {
        return this.sourcePoint;
    }

    public void computeBounds(float[] result, DiagramContext context) {
        Geometry.copyPoints((float[])this.rectangle, (float[])result);
    }

    private void updateRectangle() {
        if (this.rectangle == null) {
            this.rectangle = new float[4];
        }
        this.rectangle[0] = this.sourcePoint[0];
        this.rectangle[1] = this.sourcePoint[1];
        this.rectangle[2] = this.targetPoint[0];
        this.rectangle[3] = this.targetPoint[1];
        Geometry.expandRectangle((float[])this.rectangle, (float)5.0f, (float)5.0f);
    }

    public void display(GC gc, DiagramContext context) {
        gc.setLineWidth(1);
        gc.setLineDash(new int[]{5, 5});
        gc.setLineStyle(6);
        GcUtils.drawLine((GC)gc, (float[])this.sourcePoint, (float[])this.targetPoint);
        gc.setLineStyle(1);
        gc.setBackground(context.getResources().getSystemColor(2));
        GcUtils.drawStringAligned((GC)gc, (String)this.hline.getLabel(), (float)((this.sourcePoint[0] + this.targetPoint[0]) / 2.0f), (float)((this.sourcePoint[1] + this.targetPoint[1]) / 2.0f), (int)2);
    }

    public void update(DiagramContext context, float minX, float maxX) {
        context.invalidate((Displayable)this);
        this.sourcePoint[0] = minX - 50.0f;
        this.targetPoint[0] = maxX + 50.0f;
        this.updateRectangle();
        context.invalidate((Displayable)this);
    }
}

