/*
 * Decompiled with CFR 0.152.
 */
package obp.if2.structure.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import obp.if2.If2Visitor;
import obp.if2.behaviour.State;
import obp.if2.structure.Entity;

public abstract class Observer
extends Entity {
    private final List<State> statesList = new ArrayList<State>();

    public List<State> getStatesList() {
        return Collections.unmodifiableList(this.statesList);
    }

    public int getStatesCount() {
        return this.statesList.size();
    }

    public State getStates(int index) {
        if (index < 0 || index >= this.getStatesCount()) {
            return null;
        }
        return this.statesList.get(index);
    }

    public void addStates(State newValue) {
        this.addStates(this.getStatesCount(), newValue);
    }

    public void addStates(int index, State newValue) {
        this.statesList.add(index, newValue);
    }

    public State setStates(int index, State newValue) {
        return this.statesList.set(index, newValue);
    }

    public void addAllStates(Collection<State> toAddList) {
        for (State newValue : toAddList) {
            this.addStates(this.getStatesCount(), newValue);
        }
    }

    public void removeStates(State value) {
        int index = this.statesList.indexOf(value);
        if (index >= 0) {
            this.removeStates(index);
        }
    }

    public void removeStates(int index) {
        this.statesList.remove(index);
    }

    @Override
    public abstract void accept(If2Visitor var1);
}

