/*
 * Decompiled with CFR 0.152.
 */
package obp.if2.behaviour.states;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import obp.if2.If2Visitor;
import obp.if2.behaviour.State;
import obp.if2.structure.Signal;

public abstract class ProcessState
extends State {
    private final List<Signal> savedSignalsList = new ArrayList<Signal>();
    private final List<Signal> discardedSignalsList = new ArrayList<Signal>();

    public List<Signal> getSavedSignalsList() {
        return Collections.unmodifiableList(this.savedSignalsList);
    }

    public int getSavedSignalsCount() {
        return this.savedSignalsList.size();
    }

    public Signal getSavedSignals(int index) {
        if (index < 0 || index >= this.getSavedSignalsCount()) {
            return null;
        }
        return this.savedSignalsList.get(index);
    }

    public void addSavedSignals(Signal newValue) {
        this.addSavedSignals(this.getSavedSignalsCount(), newValue);
    }

    public void addSavedSignals(int index, Signal newValue) {
        this.savedSignalsList.add(index, newValue);
    }

    public Signal setSavedSignals(int index, Signal newValue) {
        return this.savedSignalsList.set(index, newValue);
    }

    public void addAllSavedSignals(Collection<Signal> toAddList) {
        for (Signal newValue : toAddList) {
            this.addSavedSignals(this.getSavedSignalsCount(), newValue);
        }
    }

    public void removeSavedSignals(Signal value) {
        int index = this.savedSignalsList.indexOf(value);
        if (index >= 0) {
            this.removeSavedSignals(index);
        }
    }

    public void removeSavedSignals(int index) {
        this.savedSignalsList.remove(index);
    }

    public List<Signal> getDiscardedSignalsList() {
        return Collections.unmodifiableList(this.discardedSignalsList);
    }

    public int getDiscardedSignalsCount() {
        return this.discardedSignalsList.size();
    }

    public Signal getDiscardedSignals(int index) {
        if (index < 0 || index >= this.getDiscardedSignalsCount()) {
            return null;
        }
        return this.discardedSignalsList.get(index);
    }

    public void addDiscardedSignals(Signal newValue) {
        this.addDiscardedSignals(this.getDiscardedSignalsCount(), newValue);
    }

    public void addDiscardedSignals(int index, Signal newValue) {
        this.discardedSignalsList.add(index, newValue);
    }

    public Signal setDiscardedSignals(int index, Signal newValue) {
        return this.discardedSignalsList.set(index, newValue);
    }

    public void addAllDiscardedSignals(Collection<Signal> toAddList) {
        for (Signal newValue : toAddList) {
            this.addDiscardedSignals(this.getDiscardedSignalsCount(), newValue);
        }
    }

    public void removeDiscardedSignals(Signal value) {
        int index = this.discardedSignalsList.indexOf(value);
        if (index >= 0) {
            this.removeDiscardedSignals(index);
        }
    }

    public void removeDiscardedSignals(int index) {
        this.discardedSignalsList.remove(index);
    }

    @Override
    public abstract void accept(If2Visitor var1);
}

