/*
 * Decompiled with CFR 0.152.
 */
package obp2.language.state_event.diagnosis;

import obp2.language.state_event.diagnosis.dsl.evaluator.EvaluationEnvironment;
import obp2.language.state_event.diagnosis.dsl.evaluator.Linker;
import obp2.language.state_event.diagnosis.dsl.evaluator.SEDiagnosisEvaluator;
import obp2.language.state_event.diagnosis.dsl.model.DiagnosisExp;
import obp2.language.state_event.diagnosis.dsl.parsing.SEDiagnosisParser;
import obp2.language.state_event.model.StateEventModel;
import obp2.language.state_event.model.StateEventTransition;
import obp2.language.state_event.runtime.StateEventConfiguration;
import obp2.runtime.core.IAtomicPropositionsEvaluator;
import obp2.runtime.core.defaults.DefaultLanguageService;

public class SEAtomicPropositionsEvaluator
extends DefaultLanguageService<StateEventConfiguration, StateEventTransition, Void>
implements IAtomicPropositionsEvaluator<StateEventConfiguration, StateEventTransition, Void> {
    String[] atomicPropositions;
    public StateEventModel model;
    EvaluationEnvironment environment;
    DiagnosisExp[] propositions;
    Linker linker = new Linker();
    SEDiagnosisEvaluator evaluator = new SEDiagnosisEvaluator();

    public SEAtomicPropositionsEvaluator(StateEventModel model) {
        this.model = model;
        this.environment = new EvaluationEnvironment(this.model);
    }

    public int[] registerAtomicPropositions(String[] atomicPropositions) {
        int[] result = new int[atomicPropositions.length];
        this.atomicPropositions = atomicPropositions;
        this.propositions = new DiagnosisExp[atomicPropositions.length];
        for (int i = 0; i < this.propositions.length; ++i) {
            this.propositions[i] = this.parse(atomicPropositions[i]);
            result[i] = i;
        }
        return result;
    }

    DiagnosisExp parse(String code) {
        DiagnosisExp expression = SEDiagnosisParser.parse(code, e -> System.err.println(e.getMessage()));
        this.linker.link(expression, this.model);
        return expression;
    }

    public boolean[] getAtomicPropositionValuations(StateEventConfiguration configuration) {
        this.environment.setSource(configuration);
        boolean[] valuations = new boolean[this.propositions.length];
        for (int i = 0; i < this.propositions.length; ++i) {
            valuations[i] = this.evaluator.evaluate(this.propositions[i], this.environment);
        }
        return valuations;
    }

    public boolean[] getAtomicPropositionValuations(StateEventConfiguration source, StateEventTransition fireable, Void payload, StateEventConfiguration target) {
        this.environment.setSource(source);
        this.environment.setFireable(fireable);
        this.environment.setPayload(payload);
        this.environment.setTarget(target);
        boolean[] valuations = new boolean[this.propositions.length];
        for (int i = 0; i < this.propositions.length; ++i) {
            valuations[i] = this.evaluator.evaluate(this.propositions[i], this.environment);
        }
        return valuations;
    }
}

