/*
 * Decompiled with CFR 0.152.
 */
package org.cte.ABCD.compiler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.cte.ABCD.ABCDVisitor;
import org.cte.ABCD.ABCDWalker;
import org.cte.ABCD.model.declarations.ABCDSystem;
import org.cte.ABCD.model.declarations.ParameterDecl;
import org.cte.ABCD.model.declarations.ProcessDecl;
import org.cte.ABCD.model.declarations.VariableDecl;
import org.cte.ABCD.model.expressions.IntegerLit;
import org.cte.ABCD.model.kernel.TypedElement;
import org.cte.ABCD.model.statements.SpecialTypeStmt;
import org.cte.ABCD.model.statements.Transition;
import org.cte.ABCD.model.types.MutexType;
import org.cte.ABCD.model.types.SemaphoreType;
import org.cte.ABCD.model.types.SpecialType;
import org.cte.ABCD.model.types.TimerType;

public class PrimitiveUtils {
    static final String LOCK = "lock";
    static final String UNLOCK = "unlock";
    static final String P = "P";
    static final String V = "V";
    static final String START = "start";
    static final String STOP = "stop";
    static final String TIMEOUT = "timeout";
    static final String[] mutexSelectors = new String[]{"lock", "unlock"};
    static final String[] semaphoreSelectors = new String[]{"P", "V"};
    static final String[] timerSelectors = new String[]{"start", "stop", "timeout"};

    public static List<SpecialTypeStmt> lockOnMutex(TypedElement primitive, ProcessDecl process) {
        return PrimitiveUtils.statementsOnPrimitive(LOCK, primitive, process);
    }

    public static List<SpecialTypeStmt> unlockOnMutex(TypedElement primitive, ProcessDecl process) {
        return PrimitiveUtils.statementsOnPrimitive(UNLOCK, primitive, process);
    }

    public static List<SpecialTypeStmt> POnSemaphore(TypedElement primitive, ProcessDecl process) {
        return PrimitiveUtils.statementsOnPrimitive(P, primitive, process);
    }

    public static List<SpecialTypeStmt> VOnSemaphore(TypedElement primitive, ProcessDecl process) {
        return PrimitiveUtils.statementsOnPrimitive(V, primitive, process);
    }

    public static List<SpecialTypeStmt> startOnTimer(TypedElement primitive, ProcessDecl process) {
        return PrimitiveUtils.statementsOnPrimitive(START, primitive, process);
    }

    public static List<SpecialTypeStmt> stopOnTimer(TypedElement primitive, ProcessDecl process) {
        return PrimitiveUtils.statementsOnPrimitive(STOP, primitive, process);
    }

    public static List<SpecialTypeStmt> timeoutOnTimer(TypedElement primitive, ProcessDecl process) {
        return PrimitiveUtils.statementsOnPrimitive(TIMEOUT, primitive, process);
    }

    public static List<SpecialTypeStmt> statementsOnPrimitive(final String selector, final TypedElement primitive, ProcessDecl process) {
        if (!(primitive.getType() instanceof SpecialType)) {
            return Collections.emptyList();
        }
        final ArrayList<SpecialTypeStmt> stmtList = new ArrayList<SpecialTypeStmt>();
        for (Transition t : process.getTransitionsList()) {
            t.accept(new ABCDWalker(new ABCDVisitor.Stub(){

                @Override
                public void visitSpecialTypeStmt(SpecialTypeStmt stm) {
                    if (stm.getReceiver() == primitive && stm.getSelector().equals(selector)) {
                        stmtList.add(stm);
                    }
                }
            }));
        }
        return stmtList;
    }

    public static List<SpecialTypeStmt> statementsOnPrimitive(final TypedElement primitive, ProcessDecl process) {
        if (!(primitive.getType() instanceof SpecialType)) {
            return Collections.emptyList();
        }
        final ArrayList<SpecialTypeStmt> stmtList = new ArrayList<SpecialTypeStmt>();
        for (Transition t : process.getTransitionsList()) {
            t.accept(new ABCDWalker(new ABCDVisitor.Stub(){

                @Override
                public void visitSpecialTypeStmt(SpecialTypeStmt stm) {
                    if (stm.getReceiver() == primitive) {
                        stmtList.add(stm);
                    }
                }
            }));
        }
        return stmtList;
    }

    public static void checkSelectors(ABCDSystem sys) throws Exception {
        final IntegerLit error = new IntegerLit();
        error.setValue(0);
        sys.accept(new ABCDWalker(new ABCDVisitor.Stub(){

            @Override
            public void visitSpecialTypeStmt(SpecialTypeStmt stm) {
                if (stm.getReceiver().getType() instanceof MutexType) {
                    if (Arrays.binarySearch(mutexSelectors, stm.getSelector()) < 0) {
                        System.err.println("Mutex '" + stm.getReceiver().getName() + "' does not understand '" + stm.getSelector() + "' operation");
                        error.setValue(1);
                    }
                } else if (stm.getReceiver().getType() instanceof SemaphoreType) {
                    if (Arrays.binarySearch(semaphoreSelectors, stm.getSelector()) < 0) {
                        System.err.println("Semaphore '" + stm.getReceiver().getName() + "' does not understand '" + stm.getSelector() + "' operation");
                        error.setValue(1);
                    }
                } else if (stm.getReceiver().getType() instanceof TimerType && Arrays.binarySearch(timerSelectors, stm.getSelector()) < 0) {
                    System.err.println("Timer '" + stm.getReceiver().getName() + "' does not understand '" + stm.getSelector() + "' operation");
                    error.setValue(1);
                }
            }
        }));
        if (error.getValue() == 1) {
            throw new Exception();
        }
    }

    public static List<TypedElement> mutexList(ProcessDecl process) {
        return PrimitiveUtils.primitiveList(process, MutexType.class);
    }

    public static List<TypedElement> semaphoreList(ProcessDecl process) {
        return PrimitiveUtils.primitiveList(process, SemaphoreType.class);
    }

    public static List<TypedElement> timerList(ProcessDecl process) {
        return PrimitiveUtils.primitiveList(process, TimerType.class);
    }

    public static List<VariableDecl> localTimerList(ProcessDecl process) {
        ArrayList<VariableDecl> primitiveList = new ArrayList<VariableDecl>();
        for (VariableDecl aD : process.getVariablesList()) {
            if (!(aD.getType() instanceof TimerType)) continue;
            primitiveList.add(aD);
        }
        return primitiveList;
    }

    public static <T extends SpecialType> List<TypedElement> primitiveList(ProcessDecl process, Class<T> type) {
        ArrayList<TypedElement> primitiveList = new ArrayList<TypedElement>();
        for (ParameterDecl parameterDecl : process.getParametersList()) {
            if (!type.isInstance(parameterDecl.getType())) continue;
            primitiveList.add(parameterDecl);
        }
        if (type.equals(TimerType.class)) {
            for (VariableDecl variableDecl : process.getVariablesList()) {
                if (!type.isInstance(variableDecl.getType())) continue;
                primitiveList.add(variableDecl);
            }
        }
        return primitiveList;
    }
}

