/*
 * Decompiled with CFR 0.152.
 */
package obp.fiacre.checker.type;

import java.util.Stack;
import obp.fiacre.checker.type.CAny;
import obp.fiacre.checker.type.CArray;
import obp.fiacre.checker.type.CBool;
import obp.fiacre.checker.type.CExisting;
import obp.fiacre.checker.type.CInt;
import obp.fiacre.checker.type.CQueue;
import obp.fiacre.checker.type.CRecord;
import obp.fiacre.checker.type.CType;
import obp.fiacre.checker.type.CUnion;
import obp.fiacre.model.AnyPattern;
import obp.fiacre.model.ArrayElem;
import obp.fiacre.model.ArrayPattern;
import obp.fiacre.model.BinExp;
import obp.fiacre.model.BoolLiteral;
import obp.fiacre.model.CondExp;
import obp.fiacre.model.ConstantRef;
import obp.fiacre.model.ConstrExp;
import obp.fiacre.model.ConstrPattern;
import obp.fiacre.model.Exp;
import obp.fiacre.model.ExternalFunctionRef;
import obp.fiacre.model.FieldPattern;
import obp.fiacre.model.FunctionRef;
import obp.fiacre.model.InlineArray;
import obp.fiacre.model.InlineQueue;
import obp.fiacre.model.InlineRecord;
import obp.fiacre.model.ModelVisitor;
import obp.fiacre.model.NatLiteral;
import obp.fiacre.model.Pattern;
import obp.fiacre.model.PatternExp;
import obp.fiacre.model.RecordElem;
import obp.fiacre.model.UnExp;
import obp.fiacre.model.ValuedField;
import obp.fiacre.model.VarRef;

public class ExpCTypeInferrer
extends ModelVisitor.Stub {
    private Stack<CType> typeStack;

    public void clearStack() {
        this.typeStack = new Stack();
    }

    public CType infer(Exp exp) {
        this.clearStack();
        exp.accept(this);
        return this.popType(CType.class);
    }

    public CType infer(Pattern pattern) {
        this.clearStack();
        pattern.accept(this);
        return this.popType(CType.class);
    }

    @Override
    public void visitVarRef(VarRef toVisit) {
        this.typeStack.push(new CExisting(toVisit.getDecl().getType()));
    }

    @Override
    public void visitConstantRef(ConstantRef toVisit) {
        this.typeStack.push(new CExisting(toVisit.getDecl().getType()));
    }

    @Override
    public void visitFunctionRef(FunctionRef toVisit) {
        this.typeStack.push(new CExisting(toVisit.getDecl().getReturnType()));
    }

    @Override
    public void visitExternalFunctionRef(ExternalFunctionRef toVisit) {
        this.typeStack.push(new CExisting(toVisit.getDecl().getReturnType()));
    }

    @Override
    public void visitNatLiteral(NatLiteral toVisit) {
        this.pushType(CInt.intType);
    }

    @Override
    public void visitBoolLiteral(BoolLiteral toVisit) {
        this.pushType(CBool.boolType);
    }

    @Override
    public void visitUnExp(UnExp toVisit) {
        toVisit.getExp().accept(this);
        switch (toVisit.getUnop()) {
            case DEQUEUE: {
                this.pushType(this.popType(CQueue.class));
                break;
            }
            case FIRST: {
                this.pushType(this.popType(CQueue.class).getInner());
                break;
            }
            case UEMPTY: 
            case UFULL: {
                this.popType(CQueue.class);
                this.pushType(CBool.boolType);
                break;
            }
            case UDOLLAR: {
                this.popType(CInt.class);
                this.pushType(CInt.intType);
                break;
            }
            case LENGTH: {
                this.popType(CQueue.class);
                this.pushType(CInt.intType);
                break;
            }
            case UMINUS: {
                this.pushType(this.popType(CInt.class));
                break;
            }
            case UNOT: {
                this.pushType(this.popType(CBool.class));
            }
        }
    }

    @Override
    public void visitBinExp(BinExp toVisit) {
        toVisit.getRight().accept(this);
        toVisit.getLeft().accept(this);
        switch (toVisit.getBinOp()) {
            case ENQUEUE: 
            case APPEND: {
                CQueue enqueueLeft = this.popType(CQueue.class);
                CType enqueueRight = this.popType(CType.class);
                this.checksIsAssignable(enqueueRight, enqueueLeft.getInner());
                this.pushType(enqueueLeft);
                break;
            }
            case BADD: 
            case BDIV: 
            case BMINUS: 
            case BMOD: 
            case BMUL: {
                this.popType(CInt.class);
                this.popType(CInt.class);
                this.pushType(CInt.intType);
                break;
            }
            case BEQ: 
            case BNE: {
                CType leftEq = this.popType(CType.class);
                CType rightEq = this.popType(CType.class);
                this.checksIsAssignable(rightEq, leftEq);
                this.pushType(CBool.boolType);
                break;
            }
            case BGE: 
            case BGT: 
            case BLE: 
            case BLT: {
                this.popType(CInt.class);
                this.popType(CInt.class);
                this.pushType(CBool.boolType);
                break;
            }
            case BAND: 
            case BOR: {
                this.popType(CBool.class);
                this.popType(CBool.class);
                this.pushType(CBool.boolType);
            }
        }
    }

    @Override
    public void visitArrayElem(ArrayElem toVisit) {
        toVisit.getIndex().accept(this);
        this.popType(CInt.class);
        toVisit.getArray().accept(this);
        CArray array = this.popType(CArray.class);
        this.pushType(array.getInner());
    }

    @Override
    public void visitRecordElem(RecordElem toVisit) {
        toVisit.getRecord().accept(this);
        CRecord record = this.popType(CRecord.class);
        CType fieldType = record.getField(toVisit.getField());
        this.pushType(fieldType);
    }

    @Override
    public void visitCondExp(CondExp toVisit) {
        toVisit.getCond().accept(this);
        this.popType(CBool.class);
        toVisit.getIft().accept(this);
        CType ift = this.popType(CType.class);
        toVisit.getIff().accept(this);
        CType iff = this.popType(CType.class);
        this.checksIsAssignable(iff, ift);
        this.pushType(ift);
    }

    @Override
    public void visitConstrExp(ConstrExp toVisit) {
        CType constrType = null;
        if (toVisit.getArg() != null) {
            toVisit.getArg().accept(this);
            constrType = this.popType(CType.class);
        }
        CUnion union = new CUnion();
        union.addConstr(toVisit.getName(), constrType);
        this.pushType(union);
    }

    @Override
    public void visitInlineQueue(InlineQueue toVisit) {
        this.pushType(CQueue.empty);
    }

    @Override
    public void visitInlineArray(InlineArray toVisit) {
        int size = toVisit.getElemCount();
        CType[] innerTypes = new CType[size];
        for (int i = 0; i < size; ++i) {
            toVisit.getElem(i).accept(this);
            innerTypes[i] = this.popType(CType.class);
        }
        CArray array = new CArray(innerTypes[0], size);
        this.pushType(array);
    }

    @Override
    public void visitInlineRecord(InlineRecord toVisit) {
        CRecord record = new CRecord();
        for (ValuedField field : toVisit.getValueList()) {
            field.getValue().accept(this);
            CType found = this.popType(CType.class);
            record.addField(field.getField(), found);
        }
        this.pushType(record);
    }

    @Override
    public void visitAnyPattern(AnyPattern toVisit) {
        this.pushType(CAny.anyType);
    }

    @Override
    public void visitArrayPattern(ArrayPattern toVisit) {
        toVisit.getIndex().accept(this);
        this.popType(CInt.class);
        toVisit.getArray().accept(this);
        CArray array = this.popType(CArray.class);
        this.pushType(array.getInner());
    }

    @Override
    public void visitFieldPattern(FieldPattern toVisit) {
        toVisit.getRecord().accept(this);
        CRecord record = this.popType(CRecord.class);
        CType fieldType = record.getField(toVisit.getField());
        this.pushType(fieldType);
    }

    @Override
    public void visitConstrPattern(ConstrPattern toVisit) {
        CType constrType = null;
        if (toVisit.getArg() != null) {
            toVisit.getArg().accept(this);
            constrType = this.popType(CType.class);
        }
        CUnion union = new CUnion();
        union.addConstr(toVisit.getName(), constrType);
        this.pushType(union);
    }

    @Override
    public void visitPatternExp(PatternExp toVisit) {
        this.pushType(CBool.boolType);
    }

    private void pushType(CType type) {
        this.typeStack.push(type);
    }

    private <T extends CType> T popType(Class<T> kind) {
        CType type = this.typeStack.pop().resolve();
        if (!kind.isInstance(type)) {
            throw new IllegalArgumentException("Type '" + type + "' isn't a '" + kind.getSimpleName() + "'.");
        }
        return (T)((CType)kind.cast(type));
    }

    private void checksIsAssignable(CType found, CType expected) {
        if (!found.isAssignableFrom(expected)) {
            throw new IllegalArgumentException("Expected type '" + expected + "' but found '" + found + "'.");
        }
    }
}

