/*
 * Decompiled with CFR 0.152.
 */
package obp.cc2fiacre;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import obp.cc.ConcreteContext;
import obp.cc.State;
import obp.cc.Transition;
import obp.cc2fiacre.LiteralToFiacre;
import obp.cdl.EventReference;
import obp.cdl.ProcessId;
import obp.event.Event;
import obp.event.Informal;
import obp.event.Input;
import obp.event.Message;
import obp.event.Output;
import obp.event.Value;
import obp.fiacre.model.ArgumentVariable;
import obp.fiacre.model.BinExp;
import obp.fiacre.model.BinOp;
import obp.fiacre.model.DeterministicAssignment;
import obp.fiacre.model.Exp;
import obp.fiacre.model.IfStmt;
import obp.fiacre.model.LocalVariable;
import obp.fiacre.model.ProcessDecl;
import obp.fiacre.model.Program;
import obp.fiacre.model.Queue;
import obp.fiacre.model.Select;
import obp.fiacre.model.Seq;
import obp.fiacre.model.SingleAssignment;
import obp.fiacre.model.Statement;
import obp.fiacre.model.To;
import obp.fiacre.model.Type;
import obp.fiacre.model.TypeId;
import obp.fiacre.model.UnExp;
import obp.fiacre.model.UnOp;
import obp.fiacre.model.VarRef;
import obp.fiacre.model.Variable;
import obp.transfo.cc.ConcreteContextCache;

public class ConcreteContextToFiacre {
    private static final String TMP = "tmp";
    private final ConcreteContext source;
    private final ConcreteContextCache cache;
    private final Program fiacreProgram;
    private final Map<State, obp.fiacre.model.State> statesMap = new HashMap<State, obp.fiacre.model.State>();
    private final Map<String, ArgumentVariable> parameters = new LinkedHashMap<String, ArgumentVariable>();

    public static ProcessDecl toProcess(ConcreteContext source, Program fiacreProgram) {
        ConcreteContextToFiacre transformer = new ConcreteContextToFiacre(source, fiacreProgram);
        return transformer.toProcess();
    }

    private static boolean isQueue(Type type) {
        if (type instanceof TypeId) {
            return ConcreteContextToFiacre.isQueue(((TypeId)type).getDecl().getIs());
        }
        return type instanceof Queue;
    }

    private static Type innerQueue(Type type) {
        if (type instanceof TypeId) {
            return ConcreteContextToFiacre.innerQueue(((TypeId)type).getDecl().getIs());
        }
        if (type instanceof Queue) {
            return ((Queue)type).getType();
        }
        throw new IllegalArgumentException("Internal error, shouldn't be happening, contact OBP team.");
    }

    private ConcreteContextToFiacre(ConcreteContext source, Program fiacreProgram) {
        this.source = source;
        this.fiacreProgram = fiacreProgram;
        this.cache = new ConcreteContextCache(source);
    }

    private ProcessDecl toProcess() {
        ProcessDecl result = new ProcessDecl();
        String processName = this.source.getName() != null ? this.source.getName() : "Context";
        result.setName(processName);
        this.createStates(result);
        To initTo = new To();
        initTo.setDest(this.statesMap.get(this.source.getStartState()));
        result.setInitAction(initTo);
        for (LocalVariable variable : this.fiacreProgram.getRoot().getVarList()) {
            Type type = variable.getType();
            if (!ConcreteContextToFiacre.isQueue(type)) continue;
            this.parameters.put(variable.getName(), this.createQueueArgumentVariable(variable));
        }
        if (!this.parameters.containsKey("toContext")) {
            throw new IllegalArgumentException("Queue named 'toContext' doesn't exist in root component.");
        }
        LocalVariable receiverVariable = this.createTmpVariable();
        result.addVar(receiverVariable);
        for (State sourceState : this.source.getStateList()) {
            obp.fiacre.model.Transition resultTransition = new obp.fiacre.model.Transition();
            resultTransition.setFrom(this.statesMap.get(sourceState));
            ArrayList<Statement> statements = new ArrayList<Statement>();
            ArrayList<Transition> inputTransitions = new ArrayList<Transition>();
            for (Transition sourceTransition : this.cache.getOutTransitions(sourceState)) {
                if (this.isInputTransition(sourceTransition)) {
                    inputTransitions.add(sourceTransition);
                    continue;
                }
                Statement statement = null;
                if (sourceTransition.getAction() != null) {
                    Event reference = sourceTransition.getAction().getReference().getIs();
                    if (reference instanceof Output) {
                        Output output = (Output)reference;
                        Exp value = this.getMessageValue(output.getMessage());
                        String queueName = this.toQueueName(output.getTo());
                        statement = this.createStatementForSend(sourceTransition, queueName, value);
                    } else if (reference instanceof Informal) {
                        To to = new To();
                        to.setDest(this.statesMap.get(sourceTransition.getTarget()));
                        to.addComment("@" + ((Informal)reference).getTag());
                        statement = to;
                    }
                } else {
                    To to = new To();
                    to.setDest(this.statesMap.get(sourceTransition.getTarget()));
                    statement = to;
                }
                if (statement == null) continue;
                statements.add(statement);
            }
            statements.add(this.createStatementForReceives(receiverVariable, inputTransitions));
            if (statements.size() == 0) continue;
            Seq action = new Seq();
            if (statements.size() == 1) {
                action.addStatement((Statement)statements.get(0));
            } else {
                Select select = new Select();
                action.addStatement(select);
                for (Statement statement : statements) {
                    select.addStatement(statement);
                }
            }
            To to = new To();
            to.setDest(this.statesMap.get(sourceState));
            action.addStatement(to);
            resultTransition.setAction(action);
            result.addTransition(resultTransition);
        }
        for (ArgumentVariable argument : this.parameters.values()) {
            result.addArg(argument);
        }
        return result;
    }

    private IfStmt createStatementForSend(Transition sourceTransition, String queueName, Exp value) {
        ArgumentVariable receiverVariable = this.parameters.get(queueName);
        if (receiverVariable == null) {
            throw new IllegalArgumentException("Queue named '" + queueName + "' doesn't exist in root component.");
        }
        VarRef parameter = new VarRef();
        parameter.setDecl(receiverVariable);
        UnExp full = new UnExp();
        full.setUnop(UnOp.UFULL);
        full.setExp(parameter);
        UnExp not = new UnExp();
        not.setUnop(UnOp.UNOT);
        not.setExp(full);
        BinExp enqueue = new BinExp();
        enqueue.setBinOp(BinOp.ENQUEUE);
        enqueue.setLeft(parameter);
        enqueue.setRight(value);
        SingleAssignment single = new SingleAssignment();
        single.setLhs(parameter);
        single.setRhs(enqueue);
        DeterministicAssignment assign = new DeterministicAssignment();
        assign.addAssignment(single);
        Seq seq = new Seq();
        seq.addStatement(assign);
        To to = new To();
        to.setDest(this.statesMap.get(sourceTransition.getTarget()));
        seq.addStatement(to);
        IfStmt ifStmt = new IfStmt();
        ifStmt.setCondition(not);
        ifStmt.setThen(seq);
        return ifStmt;
    }

    private IfStmt createStatementForReceives(LocalVariable receiverVariable, List<Transition> inputTransitions) {
        VarRef parameter = new VarRef();
        parameter.setDecl(this.parameters.get("toContext"));
        UnExp full = new UnExp();
        full.setUnop(UnOp.UEMPTY);
        full.setExp(parameter);
        UnExp not = new UnExp();
        not.setUnop(UnOp.UNOT);
        not.setExp(full);
        VarRef received = new VarRef();
        received.setDecl(receiverVariable);
        UnExp first = new UnExp();
        first.setExp(parameter);
        first.setUnop(UnOp.FIRST);
        SingleAssignment firstSingle = new SingleAssignment();
        firstSingle.setLhs(received);
        firstSingle.setRhs(first);
        DeterministicAssignment firstAssign = new DeterministicAssignment();
        firstAssign.addAssignment(firstSingle);
        UnExp dequeue = new UnExp();
        dequeue.setUnop(UnOp.DEQUEUE);
        dequeue.setExp(parameter);
        SingleAssignment dequeueSingle = new SingleAssignment();
        dequeueSingle.setLhs(parameter);
        dequeueSingle.setRhs(dequeue);
        DeterministicAssignment dequeueAssign = new DeterministicAssignment();
        dequeueAssign.addAssignment(dequeueSingle);
        Seq seq = new Seq();
        seq.addStatement(firstAssign);
        seq.addStatement(dequeueAssign);
        if (!inputTransitions.isEmpty()) {
            Seq receivedTestSeq = new Seq();
            seq.addStatement(receivedTestSeq);
            for (Transition inputTransition : inputTransitions) {
                Input input = (Input)inputTransition.getAction().getReference().getIs();
                Exp value = this.getMessageValue(input.getMessage());
                Seq signalSeq = new Seq();
                To to = new To();
                to.setDest(this.statesMap.get(inputTransition.getTarget()));
                signalSeq.addStatement(to);
                BinExp equalsExp = new BinExp();
                equalsExp.setBinOp(BinOp.BEQ);
                equalsExp.setLeft(received);
                equalsExp.setRight(value);
                IfStmt localIf = new IfStmt();
                localIf.setCondition(equalsExp);
                localIf.setThen(signalSeq);
                receivedTestSeq.addStatement(localIf);
            }
        }
        IfStmt ifStmt = new IfStmt();
        ifStmt.setCondition(not);
        ifStmt.setThen(seq);
        return ifStmt;
    }

    private void createStates(ProcessDecl result) {
        int count = 1;
        for (State sourceState : this.source.getStateList()) {
            obp.fiacre.model.State resultState = new obp.fiacre.model.State();
            resultState.setName("s" + count);
            this.statesMap.put(sourceState, resultState);
            result.addState(resultState);
            ++count;
        }
    }

    private ArgumentVariable createQueueArgumentVariable(Variable variable) {
        ArgumentVariable result = new ArgumentVariable();
        result.setName(variable.getName());
        result.setRead(true);
        result.setWrite(true);
        result.setRef(true);
        result.setType(variable.getType());
        return result;
    }

    private LocalVariable createTmpVariable() {
        LocalVariable variable = new LocalVariable();
        variable.setName(TMP);
        Type queue = this.parameters.get("toContext").getType();
        variable.setType(ConcreteContextToFiacre.innerQueue(queue));
        return variable;
    }

    private boolean isInputTransition(Transition ccTransition) {
        EventReference action = ccTransition.getAction();
        return action != null && action.getReference().getIs() instanceof Input;
    }

    private Exp getMessageValue(Message message) {
        if (message instanceof Value) {
            return LiteralToFiacre.toFiacre(((Value)message).getLiteral(), this.fiacreProgram);
        }
        throw new IllegalArgumentException("'" + message.getClass().getSimpleName() + "' messages aren't supported with Fiacre, use values.");
    }

    private String toQueueName(ProcessId pid) {
        return pid.getName() + "_" + pid.getId();
    }
}

