/*
 * Decompiled with CFR 0.152.
 */
package org.cte.ABCD.model.declarations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import org.cte.ABCD.ABCDVisitor;
import org.cte.ABCD.model.declarations.DeclarationWithParameters;
import org.cte.ABCD.model.declarations.DeclarationWithPorts;
import org.cte.ABCD.model.declarations.DeclarationWithVariables;
import org.cte.ABCD.model.declarations.NamedDeclaration;
import org.cte.ABCD.model.declarations.ParameterDecl;
import org.cte.ABCD.model.declarations.Port;
import org.cte.ABCD.model.declarations.State;
import org.cte.ABCD.model.declarations.VariableDecl;
import org.cte.ABCD.model.statements.Block;
import org.cte.ABCD.model.statements.Transition;

public class ProcessDecl
implements NamedDeclaration,
DeclarationWithPorts,
DeclarationWithParameters,
DeclarationWithVariables {
    private final List<Transition> transitionsList = new ArrayList<Transition>();
    private final List<State> statesList = new ArrayList<State>();
    private Block initialization;
    private String name;
    private final List<Port> portsList = new ArrayList<Port>();
    private final List<ParameterDecl> parametersList = new ArrayList<ParameterDecl>();
    private final List<VariableDecl> variablesList = new ArrayList<VariableDecl>();

    public List<Transition> getTransitionsList() {
        return Collections.unmodifiableList(this.transitionsList);
    }

    public int getTransitionsCount() {
        return this.transitionsList.size();
    }

    public Transition getTransitions(int index) {
        if (index < 0 || index >= this.getTransitionsCount()) {
            return null;
        }
        return this.transitionsList.get(index);
    }

    public void addTransitions(Transition newValue) {
        this.addTransitions(this.getTransitionsCount(), newValue);
    }

    public void addTransitions(int index, Transition newValue) {
        this.transitionsList.add(index, newValue);
    }

    public Transition setTransitions(int index, Transition newValue) {
        return this.transitionsList.set(index, newValue);
    }

    public void addAllTransitions(Collection<Transition> toAddList) {
        for (Transition newValue : toAddList) {
            this.addTransitions(this.getTransitionsCount(), newValue);
        }
    }

    public void removeTransitions(Transition value) {
        int index = this.transitionsList.indexOf(value);
        if (index >= 0) {
            this.removeTransitions(index);
        }
    }

    public void removeTransitions(int index) {
        this.transitionsList.remove(index);
    }

    public void addTransitionsAndOpposite(Transition newValue) {
        this.addTransitions(newValue);
        if (newValue != null) {
            newValue.setParent(this);
        }
    }

    public void addAllTransitionsAndOpposite(Collection<Transition> toAddList) {
        for (Transition newValue : toAddList) {
            this.addTransitionsAndOpposite(this.getTransitionsCount(), newValue);
        }
    }

    public void addTransitionsAndOpposite(int index, Transition newValue) {
        this.addTransitions(index, newValue);
        if (newValue != null) {
            newValue.setParent(this);
        }
    }

    public Transition setTransitionsAndOpposite(int index, Transition newValue) {
        Transition oldValue = this.transitionsList.set(index, newValue);
        if (newValue != null) {
            newValue.setParent(this);
        }
        return oldValue;
    }

    public void removeTransitionsAndOpposite(Transition removed) {
        this.removeTransitions(removed);
        if (removed != null) {
            removed.setParent(null);
        }
    }

    public void removeTransitionsAndOpposite(int index) {
        Transition removed = this.transitionsList.get(index);
        this.removeTransitions(index);
        if (removed != null) {
            removed.setParent(null);
        }
    }

    public List<State> getStatesList() {
        return Collections.unmodifiableList(this.statesList);
    }

    public int getStatesCount() {
        return this.statesList.size();
    }

    public State getStates(int index) {
        if (index < 0 || index >= this.getStatesCount()) {
            return null;
        }
        return this.statesList.get(index);
    }

    public void addStates(State newValue) {
        this.addStates(this.getStatesCount(), newValue);
    }

    public void addStates(int index, State newValue) {
        this.statesList.add(index, newValue);
    }

    public State setStates(int index, State newValue) {
        return this.statesList.set(index, newValue);
    }

    public void addAllStates(Collection<State> toAddList) {
        for (State newValue : toAddList) {
            this.addStates(this.getStatesCount(), newValue);
        }
    }

    public void removeStates(State value) {
        int index = this.statesList.indexOf(value);
        if (index >= 0) {
            this.removeStates(index);
        }
    }

    public void removeStates(int index) {
        this.statesList.remove(index);
    }

    public void addStatesAndOpposite(State newValue) {
        this.addStates(newValue);
        if (newValue != null) {
            newValue.setParent(this);
        }
    }

    public void addAllStatesAndOpposite(Collection<State> toAddList) {
        for (State newValue : toAddList) {
            this.addStatesAndOpposite(this.getStatesCount(), newValue);
        }
    }

    public void addStatesAndOpposite(int index, State newValue) {
        this.addStates(index, newValue);
        if (newValue != null) {
            newValue.setParent(this);
        }
    }

    public State setStatesAndOpposite(int index, State newValue) {
        State oldValue = this.statesList.set(index, newValue);
        if (newValue != null) {
            newValue.setParent(this);
        }
        return oldValue;
    }

    public void removeStatesAndOpposite(State removed) {
        this.removeStates(removed);
        if (removed != null) {
            removed.setParent(null);
        }
    }

    public void removeStatesAndOpposite(int index) {
        State removed = this.statesList.get(index);
        this.removeStates(index);
        if (removed != null) {
            removed.setParent(null);
        }
    }

    public Block getInitialization() {
        return this.initialization;
    }

    public void setInitialization(Block newValue) {
        if (this.initialization == null ? newValue != null : !this.initialization.equals(newValue)) {
            this.initialization = newValue;
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String newValue) {
        if (this.name == null ? newValue != null : !this.name.equals(newValue)) {
            this.name = newValue;
        }
    }

    @Override
    public List<Port> getPortsList() {
        return Collections.unmodifiableList(this.portsList);
    }

    @Override
    public int getPortsCount() {
        return this.portsList.size();
    }

    @Override
    public Port getPorts(int index) {
        if (index < 0 || index >= this.getPortsCount()) {
            return null;
        }
        return this.portsList.get(index);
    }

    @Override
    public void addPorts(Port newValue) {
        this.addPorts(this.getPortsCount(), newValue);
    }

    @Override
    public void addPorts(int index, Port newValue) {
        this.portsList.add(index, newValue);
    }

    @Override
    public Port setPorts(int index, Port newValue) {
        return this.portsList.set(index, newValue);
    }

    @Override
    public void addAllPorts(Collection<Port> toAddList) {
        for (Port newValue : toAddList) {
            this.addPorts(this.getPortsCount(), newValue);
        }
    }

    @Override
    public void removePorts(Port value) {
        int index = this.portsList.indexOf(value);
        if (index >= 0) {
            this.removePorts(index);
        }
    }

    @Override
    public void removePorts(int index) {
        this.portsList.remove(index);
    }

    @Override
    public void addPortsAndOpposite(Port newValue) {
        this.addPorts(newValue);
        if (newValue != null) {
            newValue.setContainer(this);
        }
    }

    @Override
    public void addAllPortsAndOpposite(Collection<Port> toAddList) {
        for (Port newValue : toAddList) {
            this.addPortsAndOpposite(this.getPortsCount(), newValue);
        }
    }

    @Override
    public void addPortsAndOpposite(int index, Port newValue) {
        this.addPorts(index, newValue);
        if (newValue != null) {
            newValue.setContainer(this);
        }
    }

    @Override
    public Port setPortsAndOpposite(int index, Port newValue) {
        Port oldValue = this.portsList.set(index, newValue);
        if (newValue != null) {
            newValue.setContainer(this);
        }
        return oldValue;
    }

    @Override
    public void removePortsAndOpposite(Port removed) {
        this.removePorts(removed);
        if (removed != null) {
            removed.setContainer(null);
        }
    }

    @Override
    public void removePortsAndOpposite(int index) {
        Port removed = this.portsList.get(index);
        this.removePorts(index);
        if (removed != null) {
            removed.setContainer(null);
        }
    }

    @Override
    public List<ParameterDecl> getParametersList() {
        return Collections.unmodifiableList(this.parametersList);
    }

    @Override
    public int getParametersCount() {
        return this.parametersList.size();
    }

    @Override
    public ParameterDecl getParameters(int index) {
        if (index < 0 || index >= this.getParametersCount()) {
            return null;
        }
        return this.parametersList.get(index);
    }

    @Override
    public void addParameters(ParameterDecl newValue) {
        this.addParameters(this.getParametersCount(), newValue);
    }

    @Override
    public void addParameters(int index, ParameterDecl newValue) {
        this.parametersList.add(index, newValue);
    }

    @Override
    public ParameterDecl setParameters(int index, ParameterDecl newValue) {
        return this.parametersList.set(index, newValue);
    }

    @Override
    public void addAllParameters(Collection<ParameterDecl> toAddList) {
        for (ParameterDecl newValue : toAddList) {
            this.addParameters(this.getParametersCount(), newValue);
        }
    }

    @Override
    public void removeParameters(ParameterDecl value) {
        int index = this.parametersList.indexOf(value);
        if (index >= 0) {
            this.removeParameters(index);
        }
    }

    @Override
    public void removeParameters(int index) {
        this.parametersList.remove(index);
    }

    @Override
    public void addParametersAndOpposite(ParameterDecl newValue) {
        this.addParameters(newValue);
        if (newValue != null) {
            newValue.setContainer(this);
        }
    }

    @Override
    public void addAllParametersAndOpposite(Collection<ParameterDecl> toAddList) {
        for (ParameterDecl newValue : toAddList) {
            this.addParametersAndOpposite(this.getParametersCount(), newValue);
        }
    }

    @Override
    public void addParametersAndOpposite(int index, ParameterDecl newValue) {
        this.addParameters(index, newValue);
        if (newValue != null) {
            newValue.setContainer(this);
        }
    }

    @Override
    public ParameterDecl setParametersAndOpposite(int index, ParameterDecl newValue) {
        ParameterDecl oldValue = this.parametersList.set(index, newValue);
        if (newValue != null) {
            newValue.setContainer(this);
        }
        return oldValue;
    }

    @Override
    public void removeParametersAndOpposite(ParameterDecl removed) {
        this.removeParameters(removed);
        if (removed != null) {
            removed.setContainer(null);
        }
    }

    @Override
    public void removeParametersAndOpposite(int index) {
        ParameterDecl removed = this.parametersList.get(index);
        this.removeParameters(index);
        if (removed != null) {
            removed.setContainer(null);
        }
    }

    @Override
    public List<VariableDecl> getVariablesList() {
        return Collections.unmodifiableList(this.variablesList);
    }

    @Override
    public int getVariablesCount() {
        return this.variablesList.size();
    }

    @Override
    public VariableDecl getVariables(int index) {
        if (index < 0 || index >= this.getVariablesCount()) {
            return null;
        }
        return this.variablesList.get(index);
    }

    @Override
    public void addVariables(VariableDecl newValue) {
        this.addVariables(this.getVariablesCount(), newValue);
    }

    @Override
    public void addVariables(int index, VariableDecl newValue) {
        this.variablesList.add(index, newValue);
    }

    @Override
    public VariableDecl setVariables(int index, VariableDecl newValue) {
        return this.variablesList.set(index, newValue);
    }

    @Override
    public void addAllVariables(Collection<VariableDecl> toAddList) {
        for (VariableDecl newValue : toAddList) {
            this.addVariables(this.getVariablesCount(), newValue);
        }
    }

    @Override
    public void removeVariables(VariableDecl value) {
        int index = this.variablesList.indexOf(value);
        if (index >= 0) {
            this.removeVariables(index);
        }
    }

    @Override
    public void removeVariables(int index) {
        this.variablesList.remove(index);
    }

    @Override
    public void addVariablesAndOpposite(VariableDecl newValue) {
        this.addVariables(newValue);
        if (newValue != null) {
            newValue.setContainer(this);
        }
    }

    @Override
    public void addAllVariablesAndOpposite(Collection<VariableDecl> toAddList) {
        for (VariableDecl newValue : toAddList) {
            this.addVariablesAndOpposite(this.getVariablesCount(), newValue);
        }
    }

    @Override
    public void addVariablesAndOpposite(int index, VariableDecl newValue) {
        this.addVariables(index, newValue);
        if (newValue != null) {
            newValue.setContainer(this);
        }
    }

    @Override
    public VariableDecl setVariablesAndOpposite(int index, VariableDecl newValue) {
        VariableDecl oldValue = this.variablesList.set(index, newValue);
        if (newValue != null) {
            newValue.setContainer(this);
        }
        return oldValue;
    }

    @Override
    public void removeVariablesAndOpposite(VariableDecl removed) {
        this.removeVariables(removed);
        if (removed != null) {
            removed.setContainer(null);
        }
    }

    @Override
    public void removeVariablesAndOpposite(int index) {
        VariableDecl removed = this.variablesList.get(index);
        this.removeVariables(index);
        if (removed != null) {
            removed.setContainer(null);
        }
    }

    @Override
    public void accept(ABCDVisitor visitor) {
        visitor.visitProcessDecl(this);
    }

    public boolean equals(Object that) {
        return this.equalsCached(that, new IdentityHashMap<Object, Object>());
    }

    @Override
    public boolean equalsCached(Object that, IdentityHashMap<Object, Object> cache) {
        if (this == that) {
            cache.put(that, this);
            return true;
        }
        if (!(that instanceof ProcessDecl)) {
            return false;
        }
        Object o1 = cache.get(this);
        if (o1 != null) {
            return o1 == that;
        }
        Object o2 = cache.get(that);
        if (o2 != null) {
            return o2 == this;
        }
        return this.equalsFeatures((ProcessDecl)that, cache);
    }

    protected boolean equalsFeatures(ProcessDecl that, IdentityHashMap<Object, Object> cache) {
        int i;
        int l1size = 0;
        int l2size = 0;
        l1size = this.transitionsList.size();
        if (l1size != (l2size = that.transitionsList.size())) {
            return false;
        }
        for (i = 0; i < l1size; ++i) {
            if (this.transitionsList.get(i).equalsCached(that.transitionsList.get(i), cache)) continue;
            return false;
        }
        l1size = this.statesList.size();
        if (l1size != (l2size = that.statesList.size())) {
            return false;
        }
        for (i = 0; i < l1size; ++i) {
            if (this.statesList.get(i).equalsCached(that.statesList.get(i), cache)) continue;
            return false;
        }
        if (this.initialization != null) {
            if (that.initialization == null) {
                return false;
            }
            if (!this.initialization.equalsCached(that.initialization, cache)) {
                return false;
            }
        }
        if (!this.name.equals(that.name)) {
            return false;
        }
        if (this.portsList != null) {
            if (that.portsList == null) {
                return false;
            }
            l1size = this.portsList.size();
            if (l1size != (l2size = that.portsList.size())) {
                return false;
            }
            for (i = 0; i < l1size; ++i) {
                if (this.portsList.get(i).equalsCached(that.portsList.get(i), cache)) continue;
                return false;
            }
        }
        if (this.parametersList != null) {
            if (that.parametersList == null) {
                return false;
            }
            l1size = this.parametersList.size();
            if (l1size != (l2size = that.parametersList.size())) {
                return false;
            }
            for (i = 0; i < l1size; ++i) {
                if (this.parametersList.get(i).equalsCached(that.parametersList.get(i), cache)) continue;
                return false;
            }
        }
        if (this.variablesList != null) {
            if (that.variablesList == null) {
                return false;
            }
            l1size = this.variablesList.size();
            if (l1size != (l2size = that.variablesList.size())) {
                return false;
            }
            for (i = 0; i < l1size; ++i) {
                if (this.variablesList.get(i).equalsCached(that.variablesList.get(i), cache)) continue;
                return false;
            }
        }
        return true;
    }
}

