/*
 * Decompiled with CFR 0.152.
 */
package org.cte.ABCD.compiler;

import org.cte.ABCD.model.declarations.ABCDSystem;
import org.cte.ABCD.model.declarations.ChannelDecl;
import org.cte.ABCD.model.declarations.ChannelTypeDecl;
import org.cte.ABCD.model.declarations.Port;
import org.cte.ABCD.model.declarations.PortMap;
import org.cte.ABCD.model.declarations.ProcessInstance;
import org.cte.ABCD.model.expressions.Reference;
import org.cte.ABCD.model.kernel.Expression;

public class InstantiationChecker {
    private ABCDSystem system;

    public InstantiationChecker(ABCDSystem system) {
        this.system = system;
    }

    public boolean isChannelDecl(Expression exp) {
        return exp instanceof Reference && ((Reference)exp).getRef() instanceof ChannelDecl;
    }

    public boolean areTypesCompatible(ChannelDecl channel, Port port) {
        ChannelTypeDecl cTD;
        ChannelTypeDecl channelTypeDecl = cTD = channel == null ? null : (ChannelTypeDecl)channel.getType();
        if (port == null || cTD == null || cTD.getType() == null || port.getType() == null) {
            System.err.println("InstantiationChecker: null channel type");
            return false;
        }
        return cTD.getType().equals(port.getType());
    }

    public void checkInstances() {
        if (this.system.getCompositionCount() < 1) {
            System.err.println("Missing process instantiation");
        }
        for (ProcessInstance pI : this.system.getCompositionList()) {
            for (PortMap aM : pI.getInputsList()) {
                if (!this.isChannelDecl(aM.getActual()) || this.areTypesCompatible((ChannelDecl)((Reference)aM.getActual()).getRef(), aM.getFormal())) continue;
                System.err.println("Type mismatch when connecting channel '" + ((ChannelDecl)((Reference)aM.getActual()).getRef()).getName() + "' to process '" + pI.getName() + "' (in port) " + aM.getFormal() == null ? "(null)" : aM.getFormal().getName());
            }
            for (PortMap aM : pI.getOutputsList()) {
                if (!this.isChannelDecl(aM.getActual()) || this.areTypesCompatible((ChannelDecl)((Reference)aM.getActual()).getRef(), aM.getFormal())) continue;
                System.err.println("Type mismatch when connecting channel '" + ((ChannelDecl)((Reference)aM.getActual()).getRef()).getName() + "' to process '" + pI.getName() + "' (out port) " + aM.getFormal().getName());
            }
        }
    }
}

