/*
 * Decompiled with CFR 0.152.
 */
package obp.simulation.component;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import obp.simulation.resource.SimulationResources;

public class TraceDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private JButton save;
    private JTextArea traceDisplay;
    private JLabel info;

    public TraceDialog(Frame frame) {
        super(frame, "Trace viewer");
        this.setIconImage(SimulationResources.trace.getImage());
        this.setModal(false);
        this.setAlwaysOnTop(false);
        this.traceDisplay = new JTextArea();
        this.traceDisplay.setEditable(false);
        this.info = new JLabel();
        JToolBar tool = new JToolBar();
        this.save = new JButton(SimulationResources.saveIcon);
        this.save.setActionCommand("save");
        this.save.addActionListener(this);
        tool.add(this.save);
        tool.addSeparator();
        tool.add(this.info);
        this.setLayout(new BorderLayout());
        this.add((Component)new JScrollPane(this.traceDisplay), "Center");
        this.add((Component)tool, "North");
        this.pack();
    }

    public void setTrace(String trace, int nbConfig) {
        this.traceDisplay.setText(trace);
        this.info.setText(nbConfig + " Configurations");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().matches("save")) {
            this.save(this.traceDisplay.getText());
        }
    }

    public void save(String trace) {
        int dialogResult = 0;
        File saveOn = null;
        JFileChooser dialogue = new JFileChooser();
        dialogue.showDialog(this, "Save Trace ...");
        if (dialogue.getSelectedFile() != null) {
            saveOn = dialogue.getSelectedFile();
            if (!saveOn.getName().contains(".txt")) {
                String path = saveOn.getPath();
                saveOn = new File(path + ".txt");
            }
            if (!saveOn.exists()) {
                try {
                    saveOn.createNewFile();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                dialogResult = JOptionPane.showConfirmDialog(this, "Un fichier de mme nom existe dj  cet emplacement.\nVoulez-vous vraiment le remplacer ? ", "Remplacer le fichier", 0);
            }
            if (dialogResult != 1) {
                try {
                    FileWriter fw = new FileWriter(saveOn);
                    fw.write(trace);
                    fw.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

