/*
 * Decompiled with CFR 0.152.
 */
package obp.lua;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.List;
import obp.explorer.ConfsFileHandler;
import obp.explorer.runtime.Behavior;
import obp.explorer.runtime.BehaviorConfiguration;
import obp.explorer.runtime.Configuration;
import obp.explorer.runtime.obs.Action;
import obp.explorer.runtime.obs.AtomicAction;
import obp.lua.LuaUtil;
import org.luaj.vm2.Globals;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.Varargs;
import org.luaj.vm2.lib.OneArgFunction;
import org.luaj.vm2.lib.TwoArgFunction;
import org.luaj.vm2.lib.jse.CoerceJavaToLua;
import org.luaj.vm2.lib.jse.JsePlatform;

public class LuaPrinter {
    private final ConfsFileHandler handler;
    private final Globals lua;
    private final LuaValue luaPrefixFunction;
    private final LuaValue luaConfigurationFunction;
    private final LuaValue luaTransitionFunction;
    private final LuaValue luaSuffixFunction;
    private final LuaTable configurationMetatable;
    private final LuaTable behaviorMetatable;
    private final LuaTable actionMetatable;
    private final LuaTable atomicActionMetatable;

    public LuaPrinter(ConfsFileHandler handler, File printerFile) throws IOException {
        this.handler = handler;
        this.lua = JsePlatform.standardGlobals();
        LuaUtil.parseResource("obp/lua/configuration.lua", this.lua).call();
        this.configurationMetatable = this.createConfigurationMetatable();
        this.behaviorMetatable = this.createBehaviorMetatable();
        this.actionMetatable = this.createActionMetatable();
        this.atomicActionMetatable = (LuaTable)this.lua.get("atomic_action_mt");
        if (printerFile != null) {
            LuaUtil.parseFile(printerFile, this.lua).call();
            this.luaPrefixFunction = this.lua.get("prefix");
            this.luaConfigurationFunction = this.lua.get("configuration");
            this.luaTransitionFunction = this.lua.get("transition");
            this.luaSuffixFunction = this.lua.get("suffix");
        } else {
            this.luaPrefixFunction = null;
            this.luaConfigurationFunction = null;
            this.luaTransitionFunction = null;
            this.luaSuffixFunction = null;
        }
    }

    private LuaTable createConfigurationMetatable() {
        LuaTable metatable = new LuaTable();
        metatable.set("__index", (LuaValue)new TwoArgFunction(){

            public LuaValue call(LuaValue table, LuaValue key) {
                LuaValue configuration = table.rawget("configuration");
                LuaValue result = table.rawget(key);
                if (!result.isnil()) {
                    return result;
                }
                result = configuration.get(key);
                if (!result.isnil()) {
                    return result;
                }
                Configuration instance = (Configuration)configuration.touserdata();
                String name = key.checkjstring();
                short id = LuaPrinter.this.handler.getSymbols().getBehaviorId(name);
                result = LuaPrinter.this.createBehavior(LuaPrinter.this.handler.getBehavior(id), instance.behaviorConfigurations[id]);
                table.set(name, result);
                return result;
            }
        });
        metatable.set("__tostring", (LuaValue)new OneArgFunction(){

            public LuaValue call(LuaValue table) {
                LuaValue configuration = table.get("configuration");
                Configuration instance = (Configuration)configuration.touserdata();
                return LuaValue.valueOf((String)LuaPrinter.this.handler.configurationToString(instance));
            }
        });
        return metatable;
    }

    private LuaTable createBehaviorMetatable() {
        LuaTable metatable = new LuaTable();
        metatable.set("__index", (LuaValue)new TwoArgFunction(){

            public LuaValue call(LuaValue table, LuaValue key) {
                LuaValue behavior = table.get("behavior");
                LuaValue configuration = table.get("configuration");
                String keyString = key.checkjstring();
                if (keyString.equals("state")) {
                    Behavior instance = (Behavior)behavior.touserdata();
                    short id = (short)configuration.get("state").checkint();
                    return LuaValue.valueOf((String)instance.getStateName(id));
                }
                LuaValue result = configuration.get(key);
                if (result.isnil()) {
                    result = behavior.get(key);
                }
                return result;
            }
        });
        metatable.set("__tostring", (LuaValue)new OneArgFunction(){

            public LuaValue call(LuaValue table) {
                Behavior behavior = (Behavior)table.get("behavior").touserdata();
                BehaviorConfiguration configuration = (BehaviorConfiguration)table.get("configuration").touserdata();
                return LuaValue.valueOf((String)behavior.toStringConfiguration(configuration));
            }
        });
        return metatable;
    }

    private LuaTable createActionMetatable() {
        LuaTable metatable = new LuaTable();
        metatable.set("__tostring", (LuaValue)new OneArgFunction(){

            public LuaValue call(LuaValue table) {
                StringBuilder text = new StringBuilder();
                Varargs entry = table.next(LuaValue.NIL);
                while (!entry.arg1().isnil()) {
                    if (text.length() > 1) {
                        text.append(", ");
                    }
                    LuaValue key = entry.arg1();
                    AtomicAction atomic = (AtomicAction)entry.arg(2).get("action").touserdata();
                    text.append(atomic.toFancyString(LuaPrinter.this.handler.getSymbols()));
                    entry = table.next(key);
                }
                return LuaValue.valueOf((String)text.toString());
            }
        });
        return metatable;
    }

    private LuaTable createBehavior(Behavior behavior, BehaviorConfiguration configuration) {
        LuaTable table = new LuaTable();
        table.set("behavior", CoerceJavaToLua.coerce((Object)behavior));
        table.set("configuration", CoerceJavaToLua.coerce((Object)configuration));
        table.setmetatable((LuaValue)this.behaviorMetatable);
        return table;
    }

    private LuaTable createConfiguration(Configuration configuration) {
        LuaTable table = new LuaTable();
        table.set("configuration", CoerceJavaToLua.coerce((Object)configuration));
        table.setmetatable((LuaValue)this.configurationMetatable);
        return table;
    }

    private LuaTable createAction(Action action) {
        LuaTable table = new LuaTable();
        List<AtomicAction> atomicActions = action.atomicActions;
        int size = atomicActions.size();
        for (int i = 0; i < size; ++i) {
            table.insert(i, (LuaValue)this.createAtomicAction(atomicActions.get(i)));
        }
        table.setmetatable((LuaValue)this.actionMetatable);
        return table;
    }

    private LuaTable createAtomicAction(AtomicAction action) {
        LuaTable table = new LuaTable();
        table.set("action", CoerceJavaToLua.coerce((Object)action));
        table.set("context", CoerceJavaToLua.coerce((Object)this.handler));
        table.setmetatable((LuaValue)this.atomicActionMetatable);
        return table;
    }

    public String prefix() {
        return this.luaPrefixFunction != null ? this.luaPrefixFunction.call().checkjstring() : null;
    }

    public String configurationToString(Configuration configuration) {
        String string = null;
        if (this.luaConfigurationFunction != null) {
            LuaTable facade = this.createConfiguration(configuration);
            string = this.luaConfigurationFunction.call((LuaValue)facade).checkjstring();
        }
        if (string == null) {
            string = this.handler.configurationToString(configuration) + "\n\n";
        }
        return string;
    }

    public String transitionToString(Configuration source, Action action, Configuration target) {
        String string = null;
        if (this.luaTransitionFunction != null) {
            LuaTable sourceFacade = this.createConfiguration(source);
            LuaTable targetFacade = this.createConfiguration(target);
            LuaTable actionsFacade = this.createAction(action);
            string = this.luaTransitionFunction.call((LuaValue)sourceFacade, (LuaValue)actionsFacade, (LuaValue)targetFacade).checkjstring();
        }
        if (string == null) {
            string = this.handler.actionToString(action) + "\n\n";
        }
        return string;
    }

    public String suffix() {
        return this.luaSuffixFunction != null ? this.luaSuffixFunction.call().checkjstring() : null;
    }

    public String traceDescription(List<Action> trace) {
        StringBuilder source = new StringBuilder();
        String prefix = this.prefix();
        if (prefix != null) {
            source.append(prefix);
        }
        Configuration sourceConfiguration = this.handler.getConfiguration(0);
        source.append(this.configurationToString(sourceConfiguration));
        for (Action action : trace) {
            Configuration targetConfiguration = this.handler.getConfiguration(action.targetId);
            source.append(this.transitionToString(sourceConfiguration, action, targetConfiguration));
            source.append(this.configurationToString(targetConfiguration));
            sourceConfiguration = targetConfiguration;
        }
        String suffix = this.suffix();
        if (suffix != null) {
            source.append(suffix);
        }
        return source.toString();
    }

    public void descriptionForAll(PrintStream out) {
        int configurationCount = this.handler.readAll();
        String prefix = this.prefix();
        if (prefix != null) {
            out.print(prefix);
        }
        for (int i = 0; i < configurationCount; ++i) {
            Configuration sourceConfiguration = this.handler.getConfiguration(i);
            String string = this.configurationToString(sourceConfiguration);
            out.print(string);
            for (Action action : this.handler.getActionsFrom(i)) {
                Configuration targetConfiguration = this.handler.getConfiguration(action.targetId);
                String actionString = this.transitionToString(sourceConfiguration, action, targetConfiguration);
                out.print(actionString);
            }
        }
        String suffix = this.suffix();
        if (suffix != null) {
            out.print(suffix);
        }
    }
}

