/*
 * Decompiled with CFR 0.152.
 */
package obp.event;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import obp.cdl.ProcessId;
import obp.event.EventVisitor;
import obp.event.Message;
import obp.literal.Literal;
import org.xid.basics.serializer.Boost;
import org.xid.basics.serializer.BoostObject;
import org.xid.basics.serializer.BoostUtil;

public class Signal
implements BoostObject,
Message {
    private String name;
    private ProcessId pid;
    private final List<Literal> argumentList = new ArrayList<Literal>();

    public Signal() {
    }

    protected Signal(Boost boost) {
        boost.register((BoostObject)this);
        this.name = boost.readString();
        this.pid = (ProcessId)boost.readObject(ProcessId.class);
        for (Literal oneChild : BoostUtil.readObjectList((Boost)boost, Literal.class)) {
            this.argumentList.add(oneChild);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String newValue) {
        if (this.name == null ? newValue != null : !this.name.equals(newValue)) {
            this.name = newValue;
        }
    }

    public ProcessId getPid() {
        return this.pid;
    }

    public void setPid(ProcessId newValue) {
        if (this.pid == null ? newValue != null : !this.pid.equals(newValue)) {
            this.pid = newValue;
        }
    }

    public List<Literal> getArgumentList() {
        return Collections.unmodifiableList(this.argumentList);
    }

    public int getArgumentCount() {
        return this.argumentList.size();
    }

    public Literal getArgument(int index) {
        if (index < 0 || index >= this.getArgumentCount()) {
            return null;
        }
        return this.argumentList.get(index);
    }

    public void addArgument(Literal newValue) {
        this.addArgument(this.getArgumentCount(), newValue);
    }

    public void addArgument(int index, Literal newValue) {
        this.argumentList.add(index, newValue);
    }

    public Literal setArgument(int index, Literal newValue) {
        return this.argumentList.set(index, newValue);
    }

    public void addAllArgument(Collection<Literal> toAddList) {
        for (Literal newValue : toAddList) {
            this.addArgument(this.getArgumentCount(), newValue);
        }
    }

    public void removeArgument(Literal value) {
        int index = this.argumentList.indexOf(value);
        if (index >= 0) {
            this.removeArgument(index);
        }
    }

    public void removeArgument(int index) {
        this.argumentList.remove(index);
    }

    public void writeToBoost(Boost boost) {
        boost.writeString(this.name);
        boost.writeObject((BoostObject)this.pid);
        BoostUtil.writeObjectCollection((Boost)boost, this.argumentList);
    }

    @Override
    public void accept(EventVisitor visitor) {
        visitor.visitSignal(this);
    }
}

