/*
 * Decompiled with CFR 0.152.
 */
package plug.utils.ui.graph.layout;

public class OriginalPloegLayout {
    public static void layout(Tree t) {
        OriginalPloegLayout.firstWalk(t);
        OriginalPloegLayout.secondWalk(t, 0.0);
    }

    static void firstWalk(Tree t) {
        if (t.cs == 0) {
            OriginalPloegLayout.setExtremes(t);
            return;
        }
        OriginalPloegLayout.firstWalk(t.c[0]);
        IYL ih = OriginalPloegLayout.updateIYL(OriginalPloegLayout.bottom(t.c[0].el), 0, null);
        for (int i = 1; i < t.cs; ++i) {
            OriginalPloegLayout.firstWalk(t.c[i]);
            double minY = OriginalPloegLayout.bottom(t.c[i].er);
            OriginalPloegLayout.seperate(t, i, ih);
            ih = OriginalPloegLayout.updateIYL(minY, i, ih);
        }
        OriginalPloegLayout.positionRoot(t);
        OriginalPloegLayout.setExtremes(t);
    }

    static void setExtremes(Tree t) {
        if (t.cs == 0) {
            t.el = t;
            t.er = t;
            t.mser = 0.0;
            t.msel = 0.0;
        } else {
            t.el = t.c[0].el;
            t.msel = t.c[0].msel;
            t.er = t.c[t.cs - 1].er;
            t.mser = t.c[t.cs - 1].mser;
        }
    }

    static void seperate(Tree t, int i, IYL ih) {
        Tree sr = t.c[i - 1];
        double mssr = sr.mod;
        Tree cl = t.c[i];
        double mscl = cl.mod;
        while (sr != null && cl != null) {
            double cy;
            double sy;
            double dist;
            if (OriginalPloegLayout.bottom(sr) > ih.lowY) {
                ih = ih.nxt;
            }
            if ((dist = mssr + sr.prelim + sr.w - (mscl + cl.prelim)) > 0.0) {
                mscl += dist;
                OriginalPloegLayout.moveSubtree(t, i, ih.index, dist);
            }
            if ((sy = OriginalPloegLayout.bottom(sr)) <= (cy = OriginalPloegLayout.bottom(cl)) && (sr = OriginalPloegLayout.nextRightContour(sr)) != null) {
                mssr += sr.mod;
            }
            if (!(sy >= cy) || (cl = OriginalPloegLayout.nextLeftContour(cl)) == null) continue;
            mscl += cl.mod;
        }
        if (sr == null && cl != null) {
            OriginalPloegLayout.setLeftThread(t, i, cl, mscl);
        } else if (sr != null && cl == null) {
            OriginalPloegLayout.setRightThread(t, i, sr, mssr);
        }
    }

    static void moveSubtree(Tree t, int i, int si, double dist) {
        t.c[i].mod += dist;
        t.c[i].msel += dist;
        t.c[i].mser += dist;
        OriginalPloegLayout.distributeExtra(t, i, si, dist);
    }

    static Tree nextLeftContour(Tree t) {
        return t.cs == 0 ? t.tl : t.c[0];
    }

    static Tree nextRightContour(Tree t) {
        return t.cs == 0 ? t.tr : t.c[t.cs - 1];
    }

    static double bottom(Tree t) {
        return t.y + t.h;
    }

    static void setLeftThread(Tree t, int i, Tree cl, double modsumcl) {
        Tree li = t.c[0].el;
        li.tl = cl;
        double diff = modsumcl - cl.mod - t.c[0].msel;
        li.mod += diff;
        li.prelim -= diff;
        t.c[0].el = t.c[i].el;
        t.c[0].msel = t.c[i].msel;
    }

    static void setRightThread(Tree t, int i, Tree sr, double modsumsr) {
        Tree ri = t.c[i].er;
        ri.tr = sr;
        double diff = modsumsr - sr.mod - t.c[i].mser;
        ri.mod += diff;
        ri.prelim -= diff;
        t.c[i].er = t.c[i - 1].er;
        t.c[i].mser = t.c[i - 1].mser;
    }

    static void positionRoot(Tree t) {
        t.prelim = (t.c[0].prelim + t.c[0].mod + t.c[t.cs - 1].mod + t.c[t.cs - 1].prelim + t.c[t.cs - 1].w) / 2.0 - t.w / 2.0;
    }

    static void secondWalk(Tree t, double modsum) {
        t.x = t.prelim + (modsum += t.mod);
        OriginalPloegLayout.addChildSpacing(t);
        for (int i = 0; i < t.cs; ++i) {
            OriginalPloegLayout.secondWalk(t.c[i], modsum);
        }
    }

    static void distributeExtra(Tree t, int i, int si, double dist) {
        if (si != i - 1) {
            double nr = i - si;
            t.c[si + 1].shift += dist / nr;
            t.c[i].shift -= dist / nr;
            t.c[i].change -= dist - dist / nr;
        }
    }

    static void addChildSpacing(Tree t) {
        double d = 0.0;
        double modsumdelta = 0.0;
        for (int i = 0; i < t.cs; ++i) {
            t.c[i].mod += (modsumdelta += (d += t.c[i].shift) + t.c[i].change);
        }
    }

    static IYL updateIYL(double minY, int i, IYL ih) {
        while (ih != null && minY >= ih.lowY) {
            ih = ih.nxt;
        }
        return new IYL(minY, i, ih);
    }

    static class IYL {
        double lowY;
        int index;
        IYL nxt;

        public IYL(double lowY, int index, IYL nxt) {
            this.lowY = lowY;
            this.index = index;
            this.nxt = nxt;
        }
    }

    public static class Tree {
        public double w;
        public double h;
        public double x;
        public double y;
        public double prelim;
        public double mod;
        public double shift;
        public double change;
        Tree tl;
        Tree tr;
        Tree el;
        Tree er;
        double msel;
        double mser;
        public Tree[] c;
        int cs;

        public Tree(double w, double h, double y, Tree ... c) {
            this.w = w;
            this.h = h;
            this.y = y;
            this.c = c;
            this.cs = c.length;
        }
    }
}

