/*
 * Decompiled with CFR 0.152.
 */
package obp2.cli;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import obp2.cli.CounterExampleExtractor;
import obp2.core.defaults.FiredTransition;
import obp2.language.buchikripke.runtime.KripkeBuchiConfiguration;
import obp2.language.buchikripke.runtime.StutteringTransition;
import obp2.runtime.core.TreeItem;
import obp2.simulation.trace_storage.TraceEntry;
import plug.utils.Pair;
import plug.utils.marshaling.Marshaller;

public class CounterExampleOnlyActions
extends CounterExampleExtractor {
    public CounterExampleOnlyActions(String propertyToVerify, boolean checkForDeadlocks, boolean onlyKripke) {
        super(propertyToVerify, checkForDeadlocks, onlyKripke);
    }

    @Override
    CounterExampleExtractor toStringCounterExample(PrintStream stream) {
        if (this.counterExample.size() > 0) {
            stream.println("The [ACTION-based] witness trace is: ");
        }
        if (this.showOnlyKripke()) {
            for (TraceEntry traceEntry : this.counterExample) {
                Pair thePair = (Pair)traceEntry.getAction();
                FiredTransition theFired = (FiredTransition)thePair.a;
                if (theFired.getAction() == StutteringTransition.instance) continue;
                TreeItem tree = this.getKripkeModule().getTreeProjector().projectFireable(theFired.getAction());
                stream.print(tree);
                stream.print('\n');
            }
            stream.print('\n');
            return this;
        }
        for (TraceEntry traceEntry : this.counterExample) {
            TreeItem tree = this.module.getTreeProjector().projectFireable(traceEntry.getAction());
            stream.print(tree);
            stream.print('\n');
        }
        stream.print('\n');
        return this;
    }

    @Override
    CounterExampleExtractor toBinaryCounterExample(PrintStream stream) {
        try {
            Marshaller.writeInt((int)this.counterExample.size(), (OutputStream)stream);
            if (this.showOnlyKripke()) {
                for (TraceEntry traceEntry : this.counterExample) {
                    Object actionObject = traceEntry.getAction();
                    if (!(traceEntry.getConfiguration() instanceof KripkeBuchiConfiguration) || !(actionObject instanceof Pair)) continue;
                    Pair thePair = (Pair)actionObject;
                    FiredTransition theFired = (FiredTransition)thePair.a;
                    if (theFired.getAction() == StutteringTransition.instance) continue;
                    Marshaller.writeBuffer((byte[])this.getKripkeModule().getMarshaller().serializeFireable(theFired.getAction()), (OutputStream)stream);
                }
                stream.print('\n');
                return this;
            }
            for (TraceEntry traceEntry : this.counterExample) {
                Marshaller.writeBuffer((byte[])this.module.getMarshaller().serializeFireable(traceEntry.getAction()), (OutputStream)stream);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        stream.print('\n');
        return this;
    }
}

