/*
 * Decompiled with CFR 0.152.
 */
package obp.ui;

import java.io.File;
import obp.OBPConfiguration;
import obp.ui.explorer.ExplorerConfigurationController;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.xid.basics.error.Validator;
import org.xid.basics.progress.ActionMonitor;
import org.xid.basics.ui.action.Action;
import org.xid.basics.ui.action.ActionExecuter;
import org.xid.basics.ui.controller.Controller;
import org.xid.basics.ui.field.CompositeField;
import org.xid.basics.ui.field.Field;
import org.xid.basics.ui.field.TextField;

public class OBPConfigurationController
extends Controller<OBPConfiguration> {
    private final Shell parentShell;
    private final ExplorerConfigurationController explorerController;
    private TextField dotField;
    private CompositeField compositeField;

    public OBPConfigurationController(Shell parentShell) {
        this.parentShell = parentShell;
        this.explorerController = new ExplorerConfigurationController();
    }

    public CompositeField createFields() {
        this.dotField = new TextField("Dot Executable");
        this.dotField.setTooltip("Path to dot executable (present in OBP distribution).");
        this.dotField.addAction((Action)new Action.Stub("\u2026"){

            public int run(ActionMonitor monitor) {
                String newDot;
                FileDialog dialog = new FileDialog(OBPConfigurationController.this.parentShell);
                if (OBPConfigurationController.this.dotField.getValue() != null) {
                    File dotFile = new File(OBPConfigurationController.this.dotField.getValue());
                    dialog.setFilterPath(dotFile.getParent());
                    dialog.setFileName(dotFile.getName());
                }
                if ((newDot = dialog.open()) == null) {
                    return 2;
                }
                OBPConfigurationController.this.dotField.setValue(newDot);
                ((OBPConfiguration)OBPConfigurationController.this.getSubject()).setDotExecutable(newDot);
                return 1;
            }
        });
        this.dotField.setValidator((Validator)new Validator.Stub<String>(1, "Invalid Dot file."){

            public boolean isValid(String value) {
                if (value == null) {
                    return false;
                }
                File file = new File(value);
                return file.exists() && file.isFile() && file.canExecute();
            }
        });
        CompositeField toolsCompositeField = new CompositeField("Tools", 16, new Field[]{this.dotField});
        CompositeField explorerFields = this.explorerController.createFields();
        explorerFields.addListener(this.explorerController.createListener((ActionExecuter)ActionExecuter.DEFAULT_EXECUTER));
        CompositeField explorerCompositeFields = new CompositeField("Explorer", 16, new Field[]{explorerFields});
        this.compositeField = new CompositeField(new Field[]{toolsCompositeField, explorerCompositeFields});
        return this.compositeField;
    }

    public void refreshFields() {
        if (this.getSubject() == null) {
            this.compositeField.setEnable(false);
        } else {
            this.dotField.setValue(((OBPConfiguration)this.getSubject()).getDotExecutable());
            this.explorerController.refreshFields();
            this.compositeField.setEnable(true);
        }
    }

    public void setSubject(OBPConfiguration subject) {
        super.setSubject((Object)subject);
        this.explorerController.setSubject(subject == null ? null : subject.getExplorerConfiguration());
    }

    public boolean updateSubject(Field field) {
        if (field == this.dotField) {
            ((OBPConfiguration)this.getSubject()).setDotExecutable(this.dotField.getValue());
        }
        return this.explorerController.updateSubject(field);
    }
}

