/*
 * Decompiled with CFR 0.152.
 */
package obp.simulation.component;

import com.mxgraph.layout.hierarchical.mxHierarchicalLayout;
import com.mxgraph.model.mxCell;
import com.mxgraph.model.mxGeometry;
import com.mxgraph.swing.mxGraphComponent;
import com.mxgraph.util.mxConstants;
import com.mxgraph.util.mxRectangle;
import com.mxgraph.view.mxGraph;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import obp.obs.Observer;
import obp.obs.State;
import obp.obs.Transition;
import obp.simulation.component.ObserverViewer;

public class JGraphXObserverViewer
implements ObserverViewer {
    private mxGraph graph;
    private mxGraphComponent graphComponent;
    private Observer obpObserver;
    private String startState;
    private String currentState = "";
    private String styleNode = "strokeColor=black;fillColor=#7793A4;fontFamily=Lucida Console;" + mxConstants.STYLE_ROUNDED + "=1";
    private String styleInit = "strokeColor=black;fillColor=green;fontFamily=Lucida Console;" + mxConstants.STYLE_ROUNDED + "=1";
    private String styleReject = "strokeColor=black;fillColor=red;fontFamily=Lucida Console;" + mxConstants.STYLE_ROUNDED + "=1";
    private String styleWait = "strokeColor=black;fillColor=orange;fontFamily=Lucida Console;" + mxConstants.STYLE_ROUNDED + "=1";
    private Object parent;
    private Map<String, mxCell> graphNode = new HashMap<String, mxCell>();

    public JGraphXObserverViewer(Observer obpObserver) {
        this.obpObserver = obpObserver;
        this.graph = new mxGraph();
        this.graph.setAllowDanglingEdges(false);
        this.graph.setAllowLoops(false);
        this.graph.setCellsDeletable(false);
        this.graph.setCellsDisconnectable(false);
        this.graph.setCellsResizable(false);
        this.graph.setConnectableEdges(false);
        this.startState = obpObserver.getStartState().getName();
        this.graphComponent = new mxGraphComponent(this.graph);
        this.graphComponent.setConnectable(false);
        this.parent = this.graph.getDefaultParent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Component buildComponent() {
        this.graph.getModel().beginUpdate();
        try {
            for (State state : this.obpObserver.getStateList()) {
                mxCell v1 = (mxCell)this.graph.insertVertex(this.parent, null, (Object)state.getName(), 80.0, 80.0, 50.0, 60.0);
                if (state.getName().matches(this.startState)) {
                    this.graph.getModel().setStyle((Object)v1, this.styleInit);
                } else {
                    this.graph.getModel().setStyle((Object)v1, this.styleNode);
                }
                this.graphNode.put(state.getName(), v1);
            }
            for (Transition transition : this.obpObserver.getTransitionList()) {
                this.graph.insertEdge(this.parent, null, (Object)"", (Object)this.graphNode.get(transition.getSource().getName()), (Object)this.graphNode.get(transition.getTarget().getName()), mxConstants.STYLE_ROUNDED + "=1");
            }
            mxHierarchicalLayout layout = new mxHierarchicalLayout(this.graph);
            layout.execute(this.parent);
        }
        finally {
            this.graph.getModel().endUpdate();
        }
        this.resizeAllCell();
        this.updateComponent(this.startState);
        return this.graphComponent;
    }

    @Override
    public void updateComponent(String state) {
        if (!state.matches(this.currentState)) {
            this.deselectAllCell();
            this.currentState = state;
            if (this.graphNode.containsKey(state)) {
                if (state.matches(this.startState)) {
                    this.graph.getModel().setStyle((Object)this.graphNode.get(state), this.styleInit);
                } else if (state.matches("reject")) {
                    this.graph.getModel().setStyle((Object)this.graphNode.get(state), this.styleReject);
                } else if (state.matches("success")) {
                    this.graph.getModel().setStyle((Object)this.graphNode.get(state), this.styleInit);
                } else {
                    this.graph.getModel().setStyle((Object)this.graphNode.get(state), this.styleWait);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resizeAllCell() {
        this.graph.getModel().beginUpdate();
        try {
            for (Map.Entry<String, mxCell> node : this.graphNode.entrySet()) {
                mxGeometry g = (mxGeometry)node.getValue().getGeometry().clone();
                mxRectangle bounds = this.graph.getView().getState((Object)node.getValue()).getLabelBounds();
                g.setHeight(bounds.getHeight() + 10.0);
                g.setWidth(bounds.getWidth() + 10.0);
                this.graph.cellsResized(new Object[]{node.getValue()}, new mxRectangle[]{g});
            }
        }
        finally {
            this.graph.getModel().endUpdate();
        }
    }

    private void deselectAllCell() {
        for (Map.Entry<String, mxCell> node : this.graphNode.entrySet()) {
            if (node.getKey().matches(this.startState)) {
                this.graph.getModel().setStyle((Object)node.getValue(), this.styleNode);
                continue;
            }
            this.graph.getModel().setStyle((Object)node.getValue(), this.styleNode);
        }
    }
}

